/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTReader;

public class MidPointFunctionTest {
    @Test
    public void testMidPointSimple() throws Exception {
        LineString line = (LineString)new WKTReader().read("LINESTRING(0 0, 10 10)");
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Function midPointFunction = ff.function("midPoint", new Expression[]{ff.literal((Object)line)});
        Point midPoint = (Point)midPointFunction.evaluate((Object)line);
        MidPointFunctionTest.assertMidPoint(midPoint, new Coordinate(5.0, 5.0));
    }

    private static void assertMidPoint(Point midPoint, Coordinate expected) {
        Assert.assertTrue((String)("Unexpected value: " + String.valueOf(midPoint)), (boolean)expected.equals2D(midPoint.getCoordinate(), 1.0E-6));
    }

    @Test
    public void testMidPointComplex() throws Exception {
        LineString line = (LineString)new WKTReader().read("LINESTRING(0 0, 0 10, 10 10, 20 10, 20 0)");
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Function midPointFunction = ff.function("midPoint", new Expression[]{ff.literal((Object)line)});
        Point midPoint = (Point)midPointFunction.evaluate((Object)line);
        MidPointFunctionTest.assertMidPoint(midPoint, new Coordinate(10.0, 10.0));
    }

    @Test
    public void testMidPointOnPoint() throws Exception {
        Point point = (Point)new WKTReader().read("POINT(5 3)");
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Function midPointFunction = ff.function("midPoint", new Expression[]{ff.literal((Object)point)});
        Point midPoint = (Point)midPointFunction.evaluate((Object)point);
        MidPointFunctionTest.assertMidPoint(midPoint, new Coordinate(5.0, 3.0));
    }

    @Test
    public void testMidPointOnPolygon() throws Exception {
        Polygon polygon = (Polygon)new WKTReader().read("POLYGON((0 0, 5 0, 5 5, 0 5, 0 0))");
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Function midPointFunction = ff.function("midPoint", new Expression[]{ff.literal((Object)polygon)});
        Point midPoint = (Point)midPointFunction.evaluate((Object)polygon);
        MidPointFunctionTest.assertMidPoint(midPoint, new Coordinate(5.0, 5.0));
    }
}

