/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.Arrays;
import java.util.HashSet;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.SchemaException;
import org.geotools.filter.Capabilities;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.function.FilterFunction_geometryType;
import org.geotools.filter.visitor.CapabilitiesFilterSplitter;
import org.geotools.filter.visitor.ClientTransactionAccessor;
import org.junit.Assert;
import org.locationtech.jts.geom.Envelope;

public class AbstractCapabilitiesFilterSplitterTests {
    protected FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    protected TestAccessor accessor;
    protected static final String typeName = "test";
    protected static final String geomAtt = "geom";
    protected static final String nameAtt = "name";
    protected static final String numAtt = "num";
    protected Function testFunction = new FilterFunction_geometryType();

    protected CapabilitiesFilterSplitter newVisitor(Capabilities supportedCaps) throws SchemaException {
        return new CapabilitiesFilterSplitter(supportedCaps, (FeatureType)DataUtilities.createType((String)typeName, (String)"geom:Point,name:String,num:int"), (ClientTransactionAccessor)this.accessor);
    }

    protected PropertyIsEqualTo createPropertyIsEqualToFilter(String attr, String value) throws IllegalFilterException {
        return this.ff.equals((Expression)this.ff.property(attr), (Expression)this.ff.literal((Object)value));
    }

    protected Envelope createTestEnvelope() {
        return new Envelope(10.0, 20.0, 10.0, 20.0);
    }

    protected void runTest(Filter filter, Capabilities supportedCaps, String attToEdit) throws SchemaException {
        CapabilitiesFilterSplitter visitor = this.newVisitor(new Capabilities());
        if (this.accessor != null) {
            this.accessor.setUpdate("", null);
        }
        filter.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)filter, (Object)visitor.getFilterPost());
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)visitor.getFilterPre());
        visitor = this.newVisitor(supportedCaps);
        filter.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)visitor.getFilterPost());
        Assert.assertEquals((Object)filter, (Object)visitor.getFilterPre());
        if (attToEdit != null && this.accessor != null) {
            HashSet<FeatureId> idSet = new HashSet<FeatureId>();
            idSet.add(this.ff.featureId("fid"));
            Id updateFilter = this.ff.id(idSet);
            this.accessor.setUpdate(attToEdit, (Filter)updateFilter);
            visitor = this.newVisitor(supportedCaps);
            filter.accept((FilterVisitor)visitor, null);
            Assert.assertEquals((Object)filter, (Object)visitor.getFilterPost());
            Assert.assertEquals((Object)this.ff.or(filter, (Filter)updateFilter), (Object)visitor.getFilterPre());
        }
    }

    protected PropertyIsEqualTo createFunctionFilter() throws Exception {
        FilterFunction_geometryType geomTypeExpr = new FilterFunction_geometryType();
        geomTypeExpr.setParameters(Arrays.asList(this.ff.property(geomAtt)));
        PropertyIsEqualTo filter = this.ff.equals((Expression)geomTypeExpr, (Expression)this.ff.literal((Object)"Polygon"));
        return filter;
    }

    protected Capabilities newCapabilities(Class type) {
        Capabilities caps = new Capabilities();
        caps.addType(type);
        return caps;
    }

    public static class TestAccessor
    implements ClientTransactionAccessor {
        private Filter updateFilter;
        private String attribute;

        public Filter getDeleteFilter() {
            return null;
        }

        public Filter getUpdateFilter(String attributePath) {
            if (attributePath.equals(this.attribute)) {
                return this.updateFilter;
            }
            return null;
        }

        public void setUpdate(String attribute, Filter updateFilter) {
            this.attribute = attribute;
            this.updateFilter = updateFilter;
        }
    }
}

