/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.BindingFilterVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BindingFilterVisitorTest {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory();
    BindingFilterVisitor visitor;
    SimpleFeatureType ft;

    @Before
    public void setup() throws Exception {
        this.ft = DataUtilities.createType((String)"test", (String)"theGeom:LineString,b:java.lang.Byte,s:java.lang.Short,i:java.lang.Integer,l:java.lang.Long,d:java.lang.Double,label:String");
        this.visitor = new BindingFilterVisitor((FeatureType)this.ft);
    }

    @Test
    public void equalsTest() {
        PropertyIsEqualTo source = this.ff.equal((Expression)this.ff.property("i"), (Expression)this.ff.literal((Object)"10"), true);
        PropertyIsEqualTo bound = (PropertyIsEqualTo)source.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)10, (Object)((Literal)bound.getExpression2()).getValue());
        source = this.ff.equal((Expression)this.ff.literal((Object)"10"), (Expression)this.ff.property("i"), true);
        bound = (PropertyIsEqualTo)source.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)10, (Object)((Literal)bound.getExpression1()).getValue());
    }

    @Test
    public void notEqualsTest() {
        PropertyIsNotEqualTo source = this.ff.notEqual((Expression)this.ff.property("i"), (Expression)this.ff.literal((Object)"10"), true);
        PropertyIsNotEqualTo bound = (PropertyIsNotEqualTo)source.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)10, (Object)((Literal)bound.getExpression2()).getValue());
        source = this.ff.notEqual((Expression)this.ff.literal((Object)"10"), (Expression)this.ff.property("i"), true);
        bound = (PropertyIsNotEqualTo)source.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)10, (Object)((Literal)bound.getExpression1()).getValue());
    }

    @Test
    public void between() {
        PropertyIsBetween source = this.ff.between((Expression)this.ff.property("i"), (Expression)this.ff.literal((Object)"10"), (Expression)this.ff.literal((Object)"20"));
        PropertyIsBetween bound = (PropertyIsBetween)source.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)10, (Object)((Literal)bound.getLowerBoundary()).getValue());
        Assert.assertEquals((Object)20, (Object)((Literal)bound.getUpperBoundary()).getValue());
        source = this.ff.between((Expression)this.ff.literal((Object)"10"), (Expression)this.ff.property("i"), (Expression)this.ff.property("i"));
        bound = (PropertyIsBetween)source.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)10, (Object)((Literal)bound.getExpression()).getValue());
        source = this.ff.between((Expression)this.ff.literal((Object)"10"), (Expression)this.ff.property("i"), (Expression)this.ff.property("d"));
        bound = (PropertyIsBetween)source.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)"10", (Object)((Literal)bound.getExpression()).getValue());
    }
}

