/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.Divide;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Multiply;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.expression.Subtract;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.ExpressionTypeVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExpressionTypeVisitorTest {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory();
    ExpressionTypeVisitor visitor;
    SimpleFeatureType ft;

    @Before
    public void setup() throws Exception {
        this.ft = DataUtilities.createType((String)"test", (String)"theGeom:LineString,b:java.lang.Byte,s:java.lang.Short,i:java.lang.Integer,l:java.lang.Long,d:java.lang.Double,label:String");
        this.visitor = new ExpressionTypeVisitor((FeatureType)this.ft);
    }

    @Test
    public void testNumbers() {
        Add add = this.ff.add((Expression)this.ff.literal((Object)1), (Expression)this.ff.property("s"));
        Assert.assertEquals(Short.class, (Object)add.accept((ExpressionVisitor)this.visitor, null));
        Multiply mul = this.ff.multiply((Expression)this.ff.property("l"), (Expression)this.ff.property("s"));
        Assert.assertEquals(Long.class, (Object)mul.accept((ExpressionVisitor)this.visitor, null));
        Divide div = this.ff.divide((Expression)this.ff.literal((Object)BigInteger.valueOf(10L)), (Expression)this.ff.property("s"));
        Assert.assertEquals(BigInteger.class, (Object)div.accept((ExpressionVisitor)this.visitor, null));
        Subtract sub = this.ff.subtract((Expression)this.ff.literal((Object)BigInteger.valueOf(10L)), (Expression)this.ff.property("d"));
        Assert.assertEquals(BigDecimal.class, (Object)sub.accept((ExpressionVisitor)this.visitor, null));
    }

    @Test
    public void testFunction() {
        Function func = this.ff.function("abs", new Expression[]{this.ff.literal(10)});
        Assert.assertEquals(Integer.class, (Object)func.accept((ExpressionVisitor)this.visitor, null));
    }

    @Test
    public void testIfThenElse() {
        Function func = this.ff.function("if_then_else", new Expression[]{this.ff.literal(true), this.ff.literal(10), this.ff.literal(20)});
        Assert.assertEquals(Integer.class, (Object)func.accept((ExpressionVisitor)this.visitor, null));
    }

    @Test
    public void testProperty() {
        PropertyName pn = this.ff.property("s");
        Assert.assertEquals(Short.class, (Object)pn.accept((ExpressionVisitor)this.visitor, null));
    }
}

