/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.temporal.Instant;
import org.geotools.api.temporal.Period;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.temporal.TemporalFilterTestSupport;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;

public class ExtractBoundsFilterVisitorTest
extends TemporalFilterTestSupport {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    ExtractBoundsFilterVisitor visitor = new ExtractBoundsFilterVisitor();
    Envelope infinity = this.visitor.infinity();

    @Test
    public void testInclude() {
        Envelope env = (Envelope)Filter.INCLUDE.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)this.infinity, (Object)env);
    }

    @Test
    public void testExclude() {
        Envelope env = (Envelope)Filter.EXCLUDE.accept((FilterVisitor)this.visitor, null);
        Assert.assertTrue((boolean)env.isNull());
    }

    @Test
    public void testNonSpatial() {
        PropertyIsLessThan f = this.ff.less((Expression)this.ff.property("att"), (Expression)this.ff.literal(10));
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)this.infinity, (Object)env);
    }

    @Test
    public void testBbox() {
        BBOX f = this.ff.bbox("geom", -10.0, -10.0, 10.0, 10.0, null);
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(-10.0, 10.0, -10.0, 10.0), (Object)env);
    }

    @Test
    public void testAnd() {
        And f = this.ff.and((Filter)this.ff.bbox("geom", -10.0, -10.0, 10.0, 10.0, null), (Filter)this.ff.equals((Expression)this.ff.property("att"), (Expression)this.ff.literal((Object)"10")));
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(-10.0, 10.0, -10.0, 10.0), (Object)env);
    }

    @Test
    public void testOr() {
        Or f = this.ff.or((Filter)this.ff.bbox("geom", -10.0, -10.0, 10.0, 10.0, null), (Filter)this.ff.equals((Expression)this.ff.property("att"), (Expression)this.ff.literal((Object)"10")));
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)this.infinity, (Object)env);
    }

    @Test
    public void testEnvelopeIntersects() {
        Intersects f = this.ff.intersects((Expression)this.ff.property("geom"), (Expression)this.ff.literal((Object)new Envelope(-10.0, 10.0, -10.0, 10.0)));
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(-10.0, 10.0, -10.0, 10.0), (Object)env);
    }

    @Test
    public void testTouches() {
        Coordinate[] coords = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(10.0, 10.0)};
        LineString lineString = new GeometryFactory().createLineString(coords);
        Touches filter = this.ff.touches((Expression)this.ff.property("name"), (Expression)this.ff.literal((Object)lineString));
        Envelope env = (Envelope)filter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(0.0, 10.0, 0.0, 10.0), (Object)env);
    }

    @Test
    public void testBeyond() {
        Coordinate[] coords = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(10.0, 10.0)};
        LineString lineString = new GeometryFactory().createLineString(coords);
        Beyond filter = this.ff.beyond((Expression)this.ff.property("name"), (Expression)this.ff.literal((Object)lineString), 100.0, "m");
        Envelope env = (Envelope)filter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)this.infinity, (Object)env);
    }

    @Test
    public void testNotBeyond() {
        Coordinate[] coords = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(10.0, 10.0)};
        LineString lineString = new GeometryFactory().createLineString(coords);
        Beyond filter = this.ff.beyond((Expression)this.ff.property("name"), (Expression)this.ff.literal((Object)lineString), 100.0, "m");
        Envelope env = (Envelope)filter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)this.infinity, (Object)env);
    }

    @Test
    public void testNull() {
        PropertyIsNull filter = this.ff.isNull((Expression)this.ff.property("name"));
        Envelope env = (Envelope)filter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)this.infinity, (Object)env);
    }

    @Test
    public void testDWithin() {
        Point geom = new GeometryFactory().createPoint(new Coordinate(0.0, 0.0));
        DWithin filter = this.ff.dwithin((Expression)this.ff.property("name"), (Expression)this.ff.literal((Object)geom), 100.0, "metre");
        Envelope env = (Envelope)filter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(-100.0, 100.0, -100.0, 100.0), (Object)env);
    }

    @Test
    public void testAndDWithin() {
        Point geom = new GeometryFactory().createPoint(new Coordinate(0.0, 0.0));
        DWithin filter = this.ff.dwithin((Expression)this.ff.property("geom"), (Expression)this.ff.literal((Object)geom), 100.0, "metre");
        filter = this.ff.and((Filter)filter, (Filter)this.ff.bbox((Expression)this.ff.property("geom"), 50.0, 50.0, 150.0, 150.0, null));
        Envelope env = (Envelope)filter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(50.0, 100.0, 50.0, 100.0), (Object)env);
    }

    @Test
    public void testDisjoint() {
        Coordinate[] coords = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(10.0, 10.0)};
        LineString lineString = new GeometryFactory().createLineString(coords);
        Disjoint filter = this.ff.disjoint((Expression)this.ff.property("name"), (Expression)this.ff.literal((Object)lineString));
        Envelope env = (Envelope)filter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)this.infinity, (Object)env);
    }

    @Test
    public void testAndDisjoint() {
        Coordinate[] coords = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(10.0, 10.0)};
        LineString lineString = new GeometryFactory().createLineString(coords);
        Disjoint filter = this.ff.disjoint((Expression)this.ff.property("name"), (Expression)this.ff.literal((Object)lineString));
        filter = this.ff.and((Filter)filter, (Filter)this.ff.bbox((Expression)this.ff.property("geom"), 50.0, 50.0, 150.0, 150.0, null));
        Envelope env = (Envelope)filter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(50.0, 150.0, 50.0, 150.0), (Object)env);
    }

    @Test
    public void testAndTemporalBetween() throws Exception {
        Instant start = this.instant("2016-01-01T00:00:00.000-0500");
        Instant end = this.instant("2106-01-02T00:00:00.000-0500");
        And f = this.ff.and((Filter)this.ff.bbox("geom", -10.0, -10.0, 10.0, 10.0, null), (Filter)this.ff.between((Expression)this.ff.literal((Object)"someDate"), (Expression)this.ff.literal((Object)start), (Expression)this.ff.literal((Object)end)));
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(-10.0, 10.0, -10.0, 10.0), (Object)env);
    }

    @Test
    public void testAndTemporalAfter() throws Exception {
        Instant start = this.instant("2016-01-01T00:00:00.000-0500");
        And f = this.ff.and((Filter)this.ff.bbox("geom", -10.0, -10.0, 10.0, 10.0, null), (Filter)this.ff.after((Expression)this.ff.literal((Object)"someDate"), (Expression)this.ff.literal((Object)start)));
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(-10.0, 10.0, -10.0, 10.0), (Object)env);
    }

    @Test
    public void testAndTemporalBefore() throws Exception {
        Instant start = this.instant("2016-01-01T00:00:00.000-0500");
        And f = this.ff.and((Filter)this.ff.bbox("geom", -10.0, -10.0, 10.0, 10.0, null), (Filter)this.ff.before((Expression)this.ff.literal((Object)"someDate"), (Expression)this.ff.literal((Object)start)));
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(-10.0, 10.0, -10.0, 10.0), (Object)env);
    }

    @Test
    public void testAndTemporalBegins() throws Exception {
        Instant start = this.instant("2016-01-01T00:00:00.000-0500");
        And f = this.ff.and((Filter)this.ff.bbox("geom", -10.0, -10.0, 10.0, 10.0, null), (Filter)this.ff.begins((Expression)this.ff.literal((Object)"someDate"), (Expression)this.ff.literal((Object)start)));
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(-10.0, 10.0, -10.0, 10.0), (Object)env);
    }

    @Test
    public void testAndTemporalBegunBy() throws Exception {
        Instant start = this.instant("2016-01-01T00:00:00.000-0500");
        And f = this.ff.and((Filter)this.ff.bbox("geom", -10.0, -10.0, 10.0, 10.0, null), (Filter)this.ff.begunBy((Expression)this.ff.literal((Object)"someDate"), (Expression)this.ff.literal((Object)start)));
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(-10.0, 10.0, -10.0, 10.0), (Object)env);
    }

    @Test
    public void testAndTemporalDuring() throws Exception {
        Period p = this.period("2016-01-01T00:00:00.000-0500", "2106-01-02T00:00:00.000-0500");
        And f = this.ff.and((Filter)this.ff.bbox("geom", -10.0, -10.0, 10.0, 10.0, null), (Filter)this.ff.during((Expression)this.ff.literal((Object)"someDate"), (Expression)this.ff.literal((Object)p)));
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(-10.0, 10.0, -10.0, 10.0), (Object)env);
    }

    @Test
    public void testAndTemporalEndedBy() throws Exception {
        Instant start = this.instant("2016-01-01T00:00:00.000-0500");
        And f = this.ff.and((Filter)this.ff.bbox("geom", -10.0, -10.0, 10.0, 10.0, null), (Filter)this.ff.endedBy((Expression)this.ff.literal((Object)"someDate"), (Expression)this.ff.literal((Object)start)));
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(-10.0, 10.0, -10.0, 10.0), (Object)env);
    }

    @Test
    public void testAndTemporalEnds() throws Exception {
        Instant start = this.instant("2016-01-01T00:00:00.000-0500");
        And f = this.ff.and((Filter)this.ff.bbox("geom", -10.0, -10.0, 10.0, 10.0, null), (Filter)this.ff.ends((Expression)this.ff.literal((Object)"someDate"), (Expression)this.ff.literal((Object)start)));
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(-10.0, 10.0, -10.0, 10.0), (Object)env);
    }

    @Test
    public void testAndTemporalMeets() throws Exception {
        Period p = this.period("2016-01-01T00:00:00.000-0500", "2106-01-02T00:00:00.000-0500");
        And f = this.ff.and((Filter)this.ff.bbox("geom", -10.0, -10.0, 10.0, 10.0, null), (Filter)this.ff.meets((Expression)this.ff.literal((Object)"someDate"), (Expression)this.ff.literal((Object)p)));
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(-10.0, 10.0, -10.0, 10.0), (Object)env);
    }

    @Test
    public void testAndTemporalMetBy() throws Exception {
        Period p = this.period("2016-01-01T00:00:00.000-0500", "2106-01-02T00:00:00.000-0500");
        And f = this.ff.and((Filter)this.ff.bbox("geom", -10.0, -10.0, 10.0, 10.0, null), (Filter)this.ff.metBy((Expression)this.ff.literal((Object)"someDate"), (Expression)this.ff.literal((Object)p)));
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(-10.0, 10.0, -10.0, 10.0), (Object)env);
    }

    @Test
    public void testAndTemporalOverlappedBy() throws Exception {
        Period p = this.period("2016-01-01T00:00:00.000-0500", "2106-01-02T00:00:00.000-0500");
        And f = this.ff.and((Filter)this.ff.bbox("geom", -10.0, -10.0, 10.0, 10.0, null), (Filter)this.ff.overlappedBy((Expression)this.ff.literal((Object)"someDate"), (Expression)this.ff.literal((Object)p)));
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(-10.0, 10.0, -10.0, 10.0), (Object)env);
    }

    @Test
    public void testAndTemporalTContains() throws Exception {
        Period p = this.period("2016-01-01T00:00:00.000-0500", "2106-01-02T00:00:00.000-0500");
        And f = this.ff.and((Filter)this.ff.bbox("geom", -10.0, -10.0, 10.0, 10.0, null), (Filter)this.ff.tcontains((Expression)this.ff.literal((Object)"someDate"), (Expression)this.ff.literal((Object)p)));
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(-10.0, 10.0, -10.0, 10.0), (Object)env);
    }

    @Test
    public void testAndTemporalTEquals() throws Exception {
        Period p = this.period("2016-01-01T00:00:00.000-0500", "2106-01-02T00:00:00.000-0500");
        And f = this.ff.and((Filter)this.ff.bbox("geom", -10.0, -10.0, 10.0, 10.0, null), (Filter)this.ff.tequals((Expression)this.ff.literal((Object)"someDate"), (Expression)this.ff.literal((Object)p)));
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(-10.0, 10.0, -10.0, 10.0), (Object)env);
    }

    @Test
    public void testAndTemporalTOverlaps() throws Exception {
        Period p = this.period("2016-01-01T00:00:00.000-0500", "2106-01-02T00:00:00.000-0500");
        And f = this.ff.and((Filter)this.ff.bbox("geom", -10.0, -10.0, 10.0, 10.0, null), (Filter)this.ff.toverlaps((Expression)this.ff.literal((Object)"someDate"), (Expression)this.ff.literal((Object)p)));
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(-10.0, 10.0, -10.0, 10.0), (Object)env);
    }

    @Test
    public void testAndIsNull() throws Exception {
        And f = this.ff.and((Filter)this.ff.bbox("geom", -10.0, -10.0, 10.0, 10.0, null), (Filter)this.ff.isNull((Expression)this.ff.literal((Object)"someDate")));
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(-10.0, 10.0, -10.0, 10.0), (Object)env);
    }

    @Test
    public void testAndIsNil() throws Exception {
        And f = this.ff.and((Filter)this.ff.bbox("geom", -10.0, -10.0, 10.0, 10.0, null), (Filter)this.ff.isNil((Expression)this.ff.literal((Object)"someDate"), null));
        Envelope env = (Envelope)f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)new Envelope(-10.0, 10.0, -10.0, 10.0), (Object)env);
    }
}

