/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.List;
import org.geotools.api.filter.BinaryComparisonOperator;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.function.JsonPointerFunction;
import org.geotools.filter.visitor.JsonPointerFilterSplittingVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JsonPointerFilterSplitterVisitorTest {
    private static final String PATH = "/some/test/path";
    private static final String TEST_VALUE = "testValue";
    FilterFactory ff = CommonFactoryFinder.getFilterFactory();
    JsonPointerFilterSplittingVisitor visitor;

    @Before
    public void setUp() {
        FilterCapabilities caps = new FilterCapabilities();
        caps.addType(JsonPointerFilterSplittingVisitor.class);
        caps.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
        this.visitor = new JsonPointerFilterSplittingVisitor(caps, null, null);
    }

    @Test
    public void jsonPointerSplitTest() {
        Function function = this.ff.function("jsonPointer", new Expression[]{this.ff.property("TestColumn"), this.ff.literal((Object)PATH)});
        PropertyIsEqualTo testFilter = this.ff.equals((Expression)function, (Expression)this.ff.literal((Object)TEST_VALUE));
        this.visitor.visit(testFilter, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPost());
        BinaryComparisonOperator preFilter = (BinaryComparisonOperator)this.visitor.getFilterPre();
        JsonPointerFunction jsonPointerFunction = (JsonPointerFunction)preFilter.getExpression1();
        List parameters = jsonPointerFunction.getParameters();
        PropertyName propertyName = (PropertyName)parameters.get(0);
        Assert.assertEquals((Object)"TestColumn", (Object)propertyName.getPropertyName());
        Literal literal = (Literal)parameters.get(1);
        Assert.assertEquals((Object)PATH, (Object)literal.getValue());
    }

    @Test
    public void nonJsonPointerSplittingTest() {
        PropertyIsEqualTo testFilter = this.ff.equals((Expression)this.ff.property("testProperty"), (Expression)this.ff.literal((Object)TEST_VALUE));
        this.visitor.visit(testFilter, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPost());
        BinaryComparisonOperator preFilter = (BinaryComparisonOperator)this.visitor.getFilterPre();
        Assert.assertFalse((boolean)(preFilter.getExpression2() instanceof JsonPointerFunction));
    }
}

