/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import org.geotools.geometry.jts.Geometries;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class GeometriesTest {
    private static GeometryFactory geomFactory = new GeometryFactory();
    private static final Coordinate[] coords = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(0.0, 10.0), new Coordinate(10.0, 10.0), new Coordinate(10.0, 0.0), new Coordinate(0.0, 0.0)};

    @Test
    public void testGetBinding() {
        Assert.assertEquals(Point.class, (Object)Geometries.POINT.getBinding());
        Assert.assertEquals(MultiPoint.class, (Object)Geometries.MULTIPOINT.getBinding());
        Assert.assertEquals(LineString.class, (Object)Geometries.LINESTRING.getBinding());
        Assert.assertEquals(MultiLineString.class, (Object)Geometries.MULTILINESTRING.getBinding());
        Assert.assertEquals(Polygon.class, (Object)Geometries.POLYGON.getBinding());
        Assert.assertEquals(MultiPolygon.class, (Object)Geometries.MULTIPOLYGON.getBinding());
        Assert.assertEquals(Geometry.class, (Object)Geometries.GEOMETRY.getBinding());
        Assert.assertEquals(GeometryCollection.class, (Object)Geometries.GEOMETRYCOLLECTION.getBinding());
    }

    @Test
    public void testGetByObject() {
        Point point = geomFactory.createPoint(coords[0]);
        Assert.assertEquals((Object)Geometries.POINT, (Object)Geometries.get((Geometry)point));
        MultiPoint multiPoint = geomFactory.createMultiPoint((CoordinateSequence)new CoordinateArraySequence(coords));
        Assert.assertEquals((Object)Geometries.MULTIPOINT, (Object)Geometries.get((Geometry)multiPoint));
        LineString line = geomFactory.createLineString(coords);
        Assert.assertEquals((Object)Geometries.LINESTRING, (Object)Geometries.get((Geometry)line));
        LineString[] lines = new LineString[]{geomFactory.createLineString(new Coordinate[]{coords[0], coords[1]}), geomFactory.createLineString(new Coordinate[]{coords[2], coords[3]})};
        MultiLineString multiLine = geomFactory.createMultiLineString(lines);
        Assert.assertEquals((Object)Geometries.MULTILINESTRING, (Object)Geometries.get((Geometry)multiLine));
        Polygon poly = geomFactory.createPolygon(geomFactory.createLinearRing(coords), null);
        Assert.assertEquals((Object)Geometries.POLYGON, (Object)Geometries.get((Geometry)poly));
        Polygon[] polys = new Polygon[]{poly, poly};
        MultiPolygon multiPoly = geomFactory.createMultiPolygon(polys);
        Assert.assertEquals((Object)Geometries.MULTIPOLYGON, (Object)Geometries.get((Geometry)multiPoly));
        GeometryCollection gc = geomFactory.createGeometryCollection((Geometry[])polys);
        Assert.assertEquals((Object)Geometries.GEOMETRYCOLLECTION, (Object)Geometries.get((Geometry)gc));
    }

    @Test
    public void testGetSubclass() {
        class DerivedLine
        extends LineString {
            DerivedLine(CoordinateSequence seq, GeometryFactory gf) {
                super(seq, gf);
            }
        }
        Assert.assertEquals((Object)Geometries.LINESTRING, (Object)Geometries.getForBinding(DerivedLine.class));
        abstract class DerivedGeometry
        extends Geometry {
            DerivedGeometry(GeometryFactory gf) {
                super(gf);
            }
        }
        Assert.assertEquals((Object)Geometries.GEOMETRY, (Object)Geometries.getForBinding(DerivedGeometry.class));
    }

    @Test
    public void testGetSubclassByObject() {
        class DerivedLine
        extends LineString {
            DerivedLine(CoordinateSequence seq, GeometryFactory gf) {
                super(seq, gf);
            }
        }
        Assert.assertEquals((Object)Geometries.LINESTRING, (Object)Geometries.getForBinding(DerivedLine.class));
    }

    @Test
    public void testGetName() {
        for (Geometries type : Geometries.values()) {
            String className = type.getBinding().getSimpleName();
            Assert.assertTrue((boolean)type.getName().equalsIgnoreCase(className));
            if (className.startsWith("Multi")) {
                Assert.assertTrue((boolean)type.getSimpleName().equalsIgnoreCase(className.substring(5)));
                continue;
            }
            Assert.assertTrue((boolean)type.getSimpleName().equalsIgnoreCase(className));
        }
    }

    @Test
    public void testGetForSQLType() {
        for (Geometries type : Geometries.values()) {
            int sqlType = type.getSQLType();
            Assert.assertEquals((Object)type, (Object)Geometries.getForSQLType((int)sqlType));
        }
    }
}

