/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.eclipse.imagen.media.viewer.ImageViewer;
import org.geotools.geometry.jts.LiteShape;
import org.geotools.geometry.jts.OffsetCurveBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class OffsetCurveBuilderTest {
    static final double EPS = 0.2;
    static final boolean INTERACTIVE = true;
    static final boolean INTERACTIVE_ON_SUCCESS = Boolean.getBoolean("org.geotools.image.test.interactive.on.success");
    Geometry curve;
    Geometry offsetCurve;
    @Rule
    public TestWatcher interactiveReporter = new TestWatcher(){

        protected void succeeded(Description description) {
            if (OffsetCurveBuilderTest.this.curve != null && INTERACTIVE_ON_SUCCESS) {
                this.displayCurves(false);
            }
        }

        protected void failed(Throwable e, Description description) {
            if (OffsetCurveBuilderTest.this.curve != null) {
                this.displayCurves(true);
            }
        }

        private void displayCurves(boolean failed) {
            BufferedImage image = this.drawCurves();
            ImageDisplay dialog = new ImageDisplay(image, failed ? "Failure" : "Success");
            dialog.setModal(true);
            dialog.setVisible(true);
        }

        private BufferedImage drawCurves() {
            int SIZE = 400;
            BufferedImage bi = new BufferedImage(400, 400, 5);
            Envelope envelope = OffsetCurveBuilderTest.this.curve.getEnvelopeInternal();
            if (OffsetCurveBuilderTest.this.offsetCurve != null) {
                envelope.expandToInclude(OffsetCurveBuilderTest.this.offsetCurve.getEnvelopeInternal());
            }
            if (envelope.getWidth() == 0.0) {
                envelope.expandBy(envelope.getHeight(), 0.0);
            }
            if (envelope.getHeight() == 0.0) {
                envelope.expandBy(0.0, envelope.getWidth());
            }
            envelope.expandBy(envelope.getWidth() * 0.1, envelope.getHeight() * 0.1);
            double scale = 400.0 / Math.max(envelope.getWidth(), envelope.getHeight());
            double tx = -envelope.getMinX() * scale;
            double ty = envelope.getMinY() * scale + 400.0;
            AffineTransform at = new AffineTransform(scale, 0.0, 0.0, -scale, tx, ty);
            Graphics2D graphics = bi.createGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, 400, 400);
            graphics.setColor(Color.BLACK);
            graphics.setStroke(new BasicStroke(4.0f));
            graphics.draw((Shape)new LiteShape(OffsetCurveBuilderTest.this.curve, at, false));
            graphics.setColor(Color.RED);
            graphics.setStroke(new BasicStroke(4.0f, 2, 1, 1.0f, new float[]{8.0f, 8.0f}, 0.0f));
            graphics.draw((Shape)new LiteShape(OffsetCurveBuilderTest.this.offsetCurve, at, false));
            graphics.dispose();
            return bi;
        }
    };

    Geometry offset(Geometry geometry, double offset) {
        this.curve = geometry;
        this.offsetCurve = new OffsetCurveBuilder(offset).offset(this.curve);
        return this.offsetCurve;
    }

    Geometry geometry(String wkt) throws ParseException {
        return new WKTReader().read(wkt);
    }

    @Test
    public void nullSafe() {
        Geometry offset = new OffsetCurveBuilder(10.0).offset(null);
        Assert.assertNull((Object)offset);
    }

    @Test
    public void testHorizontalSegmentPositiveOffset() throws ParseException {
        Geometry offset = this.simpleOffsetTest("LINESTRING(0 0, 10 0)", 2.0);
        Assert.assertEquals((double)2.0, (double)offset.getEnvelopeInternal().getMinY(), (double)0.0);
    }

    @Test
    public void testHorizontalSegmentNegativeOffset() throws ParseException {
        Geometry offset = this.simpleOffsetTest("LINESTRING(0 0, 10 0)", -2.0);
        Assert.assertEquals((double)offset.getEnvelopeInternal().getMinY(), (double)-2.0, (double)0.0);
    }

    @Test
    public void testDiagonalSegmentPositiveOffset() throws ParseException {
        this.simpleOffsetTest("LINESTRING(0 0, 10 10)", 2.0);
    }

    @Test
    public void testAllDiagonalsLeft() throws Exception {
        double offset = 2.0;
        this.testAllDiagonals(offset);
    }

    @Test
    public void testAllDiagonalsRight() throws Exception {
        double offset = -2.0;
        this.testAllDiagonals(offset);
    }

    private void testAllDiagonals(double offset) {
        double[] ordinates = new double[4];
        ordinates[0] = 0.0;
        ordinates[1] = 0.0;
        for (int i = 0; i < 360; ++i) {
            double angle = Math.toRadians(i);
            ordinates[2] = 10.0 * Math.cos(angle);
            ordinates[3] = 10.0 * Math.sin(angle);
            this.curve = new GeometryFactory().createLineString(new PackedCoordinateSequenceFactory().create(ordinates, 2, 0));
            this.simpleOffsetTest(this.curve, offset);
        }
    }

    @Test
    public void testLShapedInternal() throws ParseException {
        this.simpleOffsetTest("LINESTRING(0 10, 0 0, 10 0)", 2.0);
    }

    @Test
    public void testLShapedExternal() throws ParseException {
        this.simpleOffsetTest("LINESTRING(0 10, 0 0, 10 0)", 2.0);
    }

    @Test
    public void testUShapedInternal() throws ParseException {
        this.simpleOffsetTest("LINESTRING(0 10, 0 0, 10 0, 10 10)", 2.0);
    }

    @Test
    public void testUShapedExternal() throws ParseException {
        this.simpleOffsetTest("LINESTRING(0 10, 0 0, 10 0, 10 10)", -2.0);
    }

    @Test
    public void testClockArmsRight() throws ParseException {
        for (int i = 30; i < 360; ++i) {
            this.testClockArms(-2.0, i);
        }
    }

    @Test
    public void testClockArmsLeft() throws ParseException {
        for (int i = 1; i < 330; ++i) {
            this.testClockArms(2.0, i);
        }
    }

    private void testClockArms(double offset, int a) {
        double angle = Math.toRadians(a);
        double[] ordinates = new double[]{10.0, 0.0, 0.0, 0.0, 10.0 * Math.cos(angle), 10.0 * Math.sin(angle)};
        this.curve = new GeometryFactory().createLineString(new PackedCoordinateSequenceFactory().create(ordinates, 2, 0));
        this.simpleOffsetTest(this.curve, offset);
    }

    @Test
    public void testTriangleOuter() throws Exception {
        Geometry offset = this.simpleOffsetTest("LINEARRING(0 10, 0 0, 10 0, 0 10)", -2.0);
        MatcherAssert.assertThat((Object)offset, (Matcher)CoreMatchers.instanceOf(LinearRing.class));
    }

    @Test
    public void testTriangleInner() throws Exception {
        Geometry offset = this.simpleOffsetTest("LINEARRING(0 10, 0 0, 10 0, 0 10)", 2.0);
        MatcherAssert.assertThat((Object)offset, (Matcher)CoreMatchers.instanceOf(LinearRing.class));
    }

    @Test
    public void testSimpleLoopGenerator() throws Exception {
        this.simpleOffsetTest("LINESTRING(0 0, 5 0, 5 -1, 7 -1, 7 0,  10 0)", 2.0);
    }

    @Test
    public void testElongatedLoopGenerator() throws Exception {
        Geometry geom = this.geometry("LINESTRING(0 0, 5 0, 5 -10, 7 -10, 7 0,  10 0)");
        Geometry offset = this.offset(geom, 1.5);
        Assert.assertTrue((boolean)offset.isValid());
        Assert.assertTrue((offset.getLength() > 0.0 ? 1 : 0) != 0);
        Geometry expected = this.geometry("LINESTRING (0 1.5, 5 1.5, 5.260472266500395 1.477211629518312, 5.513030214988503 1.4095389311788626, 5.75 1.299038105676658, 5.964181414529809 1.149066664678467, 6.149066664678467 0.9641814145298091, 6.299038105676658 0.7500000000000002, 6.409538931178862 0.5130302149885032, 6.477211629518312 0.2604722665003956, 6.5 0.0000000000000001, 6.5 -8.5, 5.5 -8.5, 5.5 0.0000000000000001, 5.522788370481688 0.2604722665003956, 5.590461068821138 0.5130302149885032, 5.700961894323342 0.7499999999999998, 5.850933335321533 0.9641814145298091, 6.035818585470191 1.149066664678467, 6.25 1.299038105676658, 6.486969785011497 1.4095389311788624, 6.739527733499605 1.477211629518312, 7 1.5, 10 1.5)");
        Assert.assertTrue((boolean)expected.equalsExact(offset, 0.1));
    }

    @Test
    public void testElongatedNonLoopGenerator() throws Exception {
        this.simpleOffsetTest("LINESTRING(0 0, 4 0, 4 -10, 9 -10, 9 0,  10 0)", 2.0);
    }

    @Test
    public void testSelfIntersectLeft() throws Exception {
        Geometry geom = this.geometry("LINESTRING(0 0, 10 0, 10 -10, 3 -10, 3 3)");
        Geometry offset = this.offset(geom, 2.0);
        Assert.assertTrue((boolean)offset.isValid());
        Assert.assertTrue((offset.getLength() > 0.0 ? 1 : 0) != 0);
        Geometry expected = this.geometry("LINESTRING (0 2, 10 2, 10.34729635533386 1.969615506024416, 10.684040286651337 1.8793852415718169, 11 1.7320508075688774, 11.28557521937308 1.532088886237956, 11.532088886237956 1.2855752193730787, 11.732050807568877 1.0000000000000002, 11.879385241571816 0.6840402866513376, 11.969615506024416 0.3472963553338608, 12 0.0000000000000001, 12 -10, 11.969615506024416 -10.34729635533386, 11.879385241571818 -10.684040286651337, 11.732050807568877 -11, 11.532088886237956 -11.28557521937308, 11.28557521937308 -11.532088886237956, 11 -11.732050807568877, 10.684040286651339 -11.879385241571816, 10.34729635533386 -11.969615506024416, 10 -12, 2.9999999999999996 -12, 2.6527036446661394 -11.969615506024416, 2.3159597133486622 -11.879385241571816, 2 -11.732050807568877, 1.714424780626921 -11.532088886237956, 1.467911113762044 -11.28557521937308, 1.2679491924311228 -11, 1.1206147584281831 -10.684040286651337, 1.030384493975584 -10.34729635533386, 1 -10, 1 3)");
        Assert.assertTrue((boolean)expected.equalsExact(offset, 0.1));
    }

    @Test
    public void testSelfIntersectRight() throws Exception {
        Geometry geom = this.geometry("LINESTRING(0 0, 10 0, 10 -10, 3 -10, 3 3)");
        Geometry offset = this.offset(geom, -1.0);
        Assert.assertTrue((boolean)offset.isValid());
        Assert.assertTrue((offset.getLength() > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.geometry("LINESTRING (0 -1, 9 -1, 9 -9, 4 -9, 4 3)"), (Object)offset);
    }

    @Test
    public void testLoopRoad1() throws Exception {
        String wkt = "LINESTRING (13 470, 0 270, 24 251, 67 264)";
        this.simpleOffsetTest(wkt, 50.0);
    }

    @Test
    public void testLoopRoad2() throws Exception {
        String wkt = "LINESTRING (13 470, 0 270, 24 251, 67 264, 108 279)";
        this.simpleOffsetTest(wkt, 50.0);
    }

    @Test
    public void testLoopRoad3() throws Exception {
        String wkt = "LINESTRING (67 264, 108 279, 134 279, 143 262, 135 0)";
        this.simpleOffsetTest(wkt, -50.0);
    }

    @Test
    public void testSpike() throws Exception {
        String wkt = "LINESTRING (20 0, 0 67, 9 138, 8 134)";
        this.simpleOffsetTest(wkt, 50.0);
        this.simpleOffsetTest(wkt, -50.0);
        this.simpleOffsetTest(wkt, 100.0);
        this.simpleOffsetTest(wkt, -100.0);
    }

    @Test
    public void testInwardsSpike() throws Exception {
        String wkt = "LINESTRING (594005.44863915 4920198.37095076, 594015.86677618 4920163.01783546, 594006.98015873 4920062.97719912, 593985.83866536 4920003.77506624, 593948.20205744 4919978.69410905, 593949.41233583 4919981.13611074)";
        this.simpleOffsetTest(wkt, 50.0);
        this.simpleOffsetTest(wkt, -50.0);
        this.simpleOffsetTest(wkt, 100.0);
        this.simpleOffsetTest(wkt, -100.0);
    }

    private Geometry simpleOffsetTest(String wkt, double offsetDistance) throws ParseException {
        Geometry geom = this.geometry(wkt);
        return this.simpleOffsetTest(geom, offsetDistance);
    }

    private Geometry simpleOffsetTest(Geometry geom, double offsetDistance) {
        Geometry offset = this.offset(geom, offsetDistance);
        Assert.assertTrue((boolean)offset.isValid());
        Assert.assertTrue((offset.getLength() > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)Math.abs(offsetDistance), (double)offset.distance(geom), (double)(0.2 * Math.abs(offsetDistance)));
        offset.apply(geom1 -> {
            if (geom1 instanceof LineString) {
                LineString ls = (LineString)geom1;
                CoordinateSequence cs = ls.getCoordinateSequence();
                if (cs.size() < 2) {
                    return;
                }
                double px = cs.getOrdinate(0, 0);
                double py = cs.getOrdinate(0, 1);
                for (int i = 1; i < cs.size(); ++i) {
                    double cx = cs.getOrdinate(i, 0);
                    double cy = cs.getOrdinate(i, 1);
                    if (cx == px && cy == py) {
                        Assert.fail((String)("Found two subsequent ordinates with the same value: " + cx + ", " + py));
                    }
                    px = cx;
                    py = cy;
                }
            }
        });
        return offset;
    }

    public static void main(String ... args) throws ParseException {
        double tolerance = 1.0;
        String wkt = "LINESTRING (809 2365, 796 2165, 820 2146, 863 2159, 904 2174, 930 2174, 939 2157, 931 1895)";
        Geometry geom = new WKTReader().read(wkt);
        Envelope envelope = geom.getEnvelopeInternal();
        final double minx = envelope.getMinX();
        final double miny = envelope.getMinY();
        geom.apply(new CoordinateSequenceFilter(){

            public boolean isGeometryChanged() {
                return true;
            }

            public boolean isDone() {
                return false;
            }

            public void filter(CoordinateSequence seq, int i) {
                double x = seq.getOrdinate(i, 0);
                double y = seq.getOrdinate(i, 1);
                x -= minx;
                y -= miny;
                x = (double)Math.round(x / 1.0) * 1.0;
                y = (double)Math.round(y / 1.0) * 1.0;
                seq.setOrdinate(i, 0, x);
                seq.setOrdinate(i, 1, y);
            }
        });
    }

    static class ImageDisplay
    extends JDialog {
        private static final long serialVersionUID = -8640087805737551918L;
        boolean accept = false;

        public ImageDisplay(RenderedImage image, String title) {
            JPanel content = new JPanel(new BorderLayout());
            this.setContentPane(content);
            this.setTitle(title);
            JLabel topLabel = new JLabel("<html><body>The curve (black) and its offset (red) </html></body>");
            topLabel.setBorder(new EmptyBorder(4, 4, 4, 4));
            content.add((Component)topLabel, "North");
            ImageViewer imageViewer = new ImageViewer();
            imageViewer.setSize(400, 400);
            imageViewer.setImage(image);
            content.add((Component)imageViewer);
            JButton close = new JButton("Close");
            close.addActionListener(e -> this.setVisible(false));
            content.add((Component)close, "South");
            this.pack();
        }
    }
}

