/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.crs.GeosProjectionHandlerFactory;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class GeosProjectionHandlerFactoryTest {
    @Test
    public void testAngleSatelliteFarAway() {
        Assert.assertEquals((double)89.635, (double)GeosProjectionHandlerFactory.getInnerAngle((double)1000000.0, (double)6371.0), (double)0.001);
    }

    @Test
    public void testAngleSatelliteEarth() {
        Assert.assertEquals((double)3.043, (double)GeosProjectionHandlerFactory.getInnerAngle((double)6380.0, (double)6371.0), (double)0.001);
    }

    @Test
    public void testValidAreaMiddle() throws Exception {
        CoordinateReferenceSystem geos = CRS.decode("AUTO:97004,9001,0,0");
        ReferencedEnvelope re = new ReferencedEnvelope(-6000000.0, 6000000.0, -6000000.0, 6000000.0, geos);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)re, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)false);
        Geometry validArea = handler.getValidArea();
        MatcherAssert.assertThat((Object)validArea, (Matcher)Matchers.instanceOf(Polygon.class));
        Polygon validPolygon = (Polygon)validArea;
        Envelope envelope = validPolygon.getEnvelopeInternal();
        Assert.assertEquals((double)-80.0, (double)envelope.getMinX(), (double)0.5);
        Assert.assertEquals((double)80.0, (double)envelope.getMaxX(), (double)0.5);
        Assert.assertEquals((double)-80.0, (double)envelope.getMinY(), (double)0.5);
        Assert.assertEquals((double)80.0, (double)envelope.getMaxY(), (double)0.5);
    }

    @Test
    public void testValidAreaWest() throws Exception {
        CoordinateReferenceSystem geos = CRS.decode("AUTO:97004,9001,-135,0");
        ReferencedEnvelope re = new ReferencedEnvelope(-6000000.0, 6000000.0, -6000000.0, 6000000.0, geos);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)re, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)false);
        Geometry validArea = handler.getValidArea();
        MatcherAssert.assertThat((Object)validArea, (Matcher)Matchers.instanceOf(MultiPolygon.class));
        Assert.assertEquals((long)2L, (long)validArea.getNumGeometries());
        Envelope e1 = validArea.getGeometryN(0).getEnvelopeInternal();
        Assert.assertEquals((double)-180.0, (double)e1.getMinX(), (double)0.5);
        Assert.assertEquals((double)-55.0, (double)e1.getMaxX(), (double)0.5);
        Assert.assertEquals((double)-80.0, (double)e1.getMinY(), (double)0.5);
        Assert.assertEquals((double)80.0, (double)e1.getMaxY(), (double)0.5);
        Envelope e2 = validArea.getGeometryN(1).getEnvelopeInternal();
        Assert.assertEquals((double)145.0, (double)e2.getMinX(), (double)0.5);
        Assert.assertEquals((double)180.0, (double)e2.getMaxX(), (double)0.5);
        Assert.assertEquals((double)-66.0, (double)e2.getMinY(), (double)0.5);
        Assert.assertEquals((double)66.0, (double)e2.getMaxY(), (double)0.5);
    }

    @Test
    public void testValidAreaEast() throws Exception {
        CoordinateReferenceSystem geos = CRS.decode("AUTO:97004,9001,135,0");
        ReferencedEnvelope re = new ReferencedEnvelope(-6000000.0, 6000000.0, -6000000.0, 6000000.0, geos);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)re, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)false);
        Geometry validArea = handler.getValidArea();
        MatcherAssert.assertThat((Object)validArea, (Matcher)Matchers.instanceOf(MultiPolygon.class));
        Assert.assertEquals((long)2L, (long)validArea.getNumGeometries());
        Envelope e1 = validArea.getGeometryN(0).getEnvelopeInternal();
        Assert.assertEquals((double)55.0, (double)e1.getMinX(), (double)0.5);
        Assert.assertEquals((double)180.0, (double)e1.getMaxX(), (double)0.5);
        Assert.assertEquals((double)-80.0, (double)e1.getMinY(), (double)0.5);
        Assert.assertEquals((double)80.0, (double)e1.getMaxY(), (double)0.5);
        Envelope e2 = validArea.getGeometryN(1).getEnvelopeInternal();
        Assert.assertEquals((double)-180.0, (double)e2.getMinX(), (double)0.5);
        Assert.assertEquals((double)-145.0, (double)e2.getMaxX(), (double)0.5);
        Assert.assertEquals((double)-66.0, (double)e2.getMinY(), (double)0.5);
        Assert.assertEquals((double)66.0, (double)e2.getMaxY(), (double)0.5);
    }
}

