/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import java.util.List;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;

public class PlateCarreeProjectionHandlerFactoryTest {
    private static final ReferencedEnvelope WORLD = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, null);

    @Test
    public void testWorldValidArea_NoWrap() throws Exception {
        CoordinateReferenceSystem plateCarree = CRS.decode("EPSG:4326", true);
        ReferencedEnvelope re = new ReferencedEnvelope((Envelope)WORLD, plateCarree);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)re, (CoordinateReferenceSystem)plateCarree, (boolean)false);
        Assert.assertNotNull((Object)handler);
        List envs = handler.getQueryEnvelopes();
        Assert.assertEquals((long)1L, (long)envs.size());
        Assert.assertTrue((boolean)JTS.equals((Envelope)new Envelope(-180.0, 180.0, -90.0, 90.0), (Envelope)((Envelope)envs.get(0)), (double)1.0E-6));
    }

    @Test
    public void testDatelineCrossing_WithWrap() throws Exception {
        CoordinateReferenceSystem plateCarree = CRS.decode("EPSG:4326", true);
        ReferencedEnvelope crossing = new ReferencedEnvelope(170.0, 190.0, -10.0, 10.0, plateCarree);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)crossing, (CoordinateReferenceSystem)plateCarree, (boolean)true);
        Assert.assertNotNull((Object)handler);
        List envelopes = handler.getQueryEnvelopes();
        Assert.assertEquals((long)2L, (long)envelopes.size());
        ReferencedEnvelope e0 = (ReferencedEnvelope)envelopes.get(0);
        ReferencedEnvelope e1 = (ReferencedEnvelope)envelopes.get(1);
        ReferencedEnvelope west = e0.getMinimum(0) < e1.getMinimum(0) ? e0 : e1;
        ReferencedEnvelope east = west == e0 ? e1 : e0;
        Assert.assertTrue((boolean)JTS.equals((Envelope)new Envelope(-180.0, -170.0, -10.0, 10.0), (Envelope)west, (double)1.0E-6));
        Assert.assertTrue((boolean)JTS.equals((Envelope)new Envelope(170.0, 180.0, -10.0, 10.0), (Envelope)east, (double)1.0E-6));
    }
}

