/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.geotools.styling.DefaultResourceLocator;
import org.geotools.util.URLs;
import org.junit.Assert;
import org.junit.Test;

public class DefaultResourceLocatorTest {
    @Test
    public void testRelativeFileURL() throws Exception {
        DefaultResourceLocator locator = new DefaultResourceLocator();
        locator.setSourceUrl(this.getClass().getResource("test-data/blob.gif"));
        this.checkURL(locator.locateResource("blob.gif"));
        this.checkURL(locator.locateResource("file:blob.gif"));
        this.checkURL(locator.locateResource("file://blob.gif"));
        this.checkURL(locator.locateResource("file://./blob.gif"));
    }

    @Test
    public void testPreserveURLQuery() throws Exception {
        DefaultResourceLocator locator = new DefaultResourceLocator();
        locator.setSourceUrl(this.getClass().getResource("test-data/blob.gif"));
        URL url = locator.locateResource("blob.gif?query=parameter");
        Assert.assertEquals((Object)"query=parameter", (Object)url.getQuery());
        File file = URLs.urlToFile((URL)url);
        Assert.assertTrue((boolean)file.exists());
    }

    @Test
    public void testPreserveURLQueryWithColors() throws Exception {
        DefaultResourceLocator locator = new DefaultResourceLocator();
        locator.setSourceUrl(this.getClass().getResource("test-data/blob.gif"));
        URL url = locator.locateResource("blob.gif?fill=#ff0000&stroke=#000000");
        String external = url.toExternalForm();
        Assert.assertTrue((external.indexOf(63) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"fill=#ff0000&stroke=#000000", (Object)external.split("\\?")[1]);
        File file = URLs.urlToFile((URL)url);
        Assert.assertTrue((boolean)file.exists());
    }

    void checkURL(URL url) {
        File f = URLs.urlToFile((URL)url);
        Assert.assertTrue((boolean)f.exists());
    }

    @Test
    public void testInvalidPath() throws Exception {
        DefaultResourceLocator locator = new DefaultResourceLocator();
        URL testURL = new URL("resource", null, -1, "target", new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                return new URLConnection(u){

                    @Override
                    public void connect() throws IOException {
                    }

                    @Override
                    public long getLastModified() {
                        return 0L;
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        return new ByteArrayInputStream(new byte[0]);
                    }

                    @Override
                    public OutputStream getOutputStream() throws IOException {
                        return new ByteArrayOutputStream();
                    }
                };
            }
        });
        locator.setSourceUrl(testURL);
        Assert.assertEquals((Object)new URL("file://test"), (Object)locator.locateResource("file://test"));
    }
}

