/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.Symbolizer;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.visitor.FeatureStyleScaleStyleVisitor;
import org.junit.Assert;
import org.junit.Test;

public class FeatureStyleScaleStyleVisitorTest {
    @Test
    public void testMaxScaleDenominator() {
        StyleBuilder sb = new StyleBuilder();
        Style style = sb.createStyle();
        Rule rule = sb.createRule(new Symbolizer[0]);
        FeatureTypeStyle fts = sb.createFeatureTypeStyle("featureType", rule);
        fts.getOptions().put("maxScaleDenominator", "1000");
        fts.getOptions().put("minScaleDenominator", "10");
        style.featureTypeStyles().add(fts);
        FeatureStyleScaleStyleVisitor visitor = new FeatureStyleScaleStyleVisitor();
        visitor.visit(style);
        Style copiedStyle = (Style)visitor.getCopy();
        Rule copiedRule = (Rule)((FeatureTypeStyle)copiedStyle.featureTypeStyles().get(0)).rules().get(0);
        Assert.assertEquals((double)1000.0, (double)copiedRule.getMaxScaleDenominator(), (double)1.0E-10);
        Assert.assertEquals((double)10.0, (double)copiedRule.getMinScaleDenominator(), (double)1.0E-10);
    }

    @Test
    public void testNoScaleDenominator() {
        StyleBuilder sb = new StyleBuilder();
        Style style = sb.createStyle();
        Rule rule = sb.createRule(new Symbolizer[0]);
        FeatureTypeStyle fts = sb.createFeatureTypeStyle("featureType", rule);
        style.featureTypeStyles().add(fts);
        FeatureStyleScaleStyleVisitor visitor = new FeatureStyleScaleStyleVisitor();
        visitor.visit(style);
        Style copiedStyle = (Style)visitor.getCopy();
        Rule copiedRule = (Rule)((FeatureTypeStyle)copiedStyle.featureTypeStyles().get(0)).rules().get(0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)copiedRule.getMaxScaleDenominator(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)copiedRule.getMinScaleDenominator(), (double)1.0E-10);
    }

    @Test
    public void testRuleScaleDenominator() {
        StyleBuilder sb = new StyleBuilder();
        Style style = sb.createStyle();
        Rule rule = sb.createRule(new Symbolizer[0]);
        rule.setMinScaleDenominator(100.0);
        rule.setMaxScaleDenominator(5000.0);
        FeatureTypeStyle fts = sb.createFeatureTypeStyle("featureType", rule);
        fts.getOptions().put("maxScaleDenominator", "1000");
        fts.getOptions().put("minScaleDenominator", "10");
        style.featureTypeStyles().add(fts);
        FeatureStyleScaleStyleVisitor visitor = new FeatureStyleScaleStyleVisitor();
        visitor.visit(style);
        Style copiedStyle = (Style)visitor.getCopy();
        Rule copiedRule = (Rule)((FeatureTypeStyle)copiedStyle.featureTypeStyles().get(0)).rules().get(0);
        Assert.assertEquals((double)5000.0, (double)copiedRule.getMaxScaleDenominator(), (double)1.0E-10);
        Assert.assertEquals((double)100.0, (double)copiedRule.getMinScaleDenominator(), (double)1.0E-10);
    }
}

