/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.object;

import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.temporal.DateAndTime;
import org.geotools.api.temporal.TemporalReferenceSystem;
import org.geotools.api.util.InternationalString;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.temporal.object.DefaultDateAndTime;
import org.geotools.temporal.reference.DefaultTemporalReferenceSystem;
import org.geotools.util.SimpleInternationalString;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultDateAndTimeTest {
    private DateAndTime dateAndTime1;
    private DateAndTime dateAndTime2;

    @Before
    public void setUp() {
        NamedIdentifier name = new NamedIdentifier(Citations.CRS, "Gregorian calendar");
        DefaultTemporalReferenceSystem frame = new DefaultTemporalReferenceSystem((ReferenceIdentifier)name, null);
        int[] cal1 = new int[]{1981, 6, 25};
        int[] cal2 = new int[]{2000, 1, 1};
        Number[] clck1 = new Number[]{8, 16, 25};
        Number[] clck2 = new Number[]{15, 55, 1};
        SimpleInternationalString calendarEraName = new SimpleInternationalString("Cenozoic");
        this.dateAndTime1 = new DefaultDateAndTime((TemporalReferenceSystem)frame, null, (InternationalString)calendarEraName, cal1, clck1);
        this.dateAndTime2 = new DefaultDateAndTime((TemporalReferenceSystem)frame, null, (InternationalString)calendarEraName, cal2, clck2);
    }

    @After
    public void tearDown() {
        this.dateAndTime1 = null;
        this.dateAndTime2 = null;
    }

    @Test
    public void testGetClockTime() {
        Number[] result = this.dateAndTime1.getClockTime();
        MatcherAssert.assertThat((Object)this.dateAndTime2.getClockTime(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)result)));
    }

    @Test
    public void testGetCalendarEraName() {
        InternationalString result = this.dateAndTime1.getCalendarEraName();
        Assert.assertEquals((Object)this.dateAndTime2.getCalendarEraName(), (Object)result);
    }

    @Test
    public void testGetCalendarDate() {
        int[] result = this.dateAndTime1.getCalendarDate();
        MatcherAssert.assertThat((Object)this.dateAndTime2.getCalendarDate(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)result)));
    }

    @Test
    public void testSetCalendarEraName() {
        InternationalString result = this.dateAndTime1.getCalendarEraName();
        ((DefaultDateAndTime)this.dateAndTime1).setCalendarEraName((InternationalString)new SimpleInternationalString("new Era"));
        Assert.assertNotEquals((Object)this.dateAndTime1.getCalendarEraName(), (Object)result);
    }

    @Test
    public void testSetCalendarDate() {
        int[] result = this.dateAndTime1.getCalendarDate();
        int[] caldate = new int[]{1990, 3, 6};
        ((DefaultDateAndTime)this.dateAndTime1).setCalendarDate(caldate);
        MatcherAssert.assertThat((Object)this.dateAndTime1.getCalendarDate(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)result)));
    }

    @Test
    public void testSetClockTime() {
        Number[] result = this.dateAndTime1.getClockTime();
        Number[] clk = new Number[]{15, 23, 5.7};
        ((DefaultDateAndTime)this.dateAndTime1).setClockTime(clk);
        MatcherAssert.assertThat((Object)this.dateAndTime1.getClockTime(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)result)));
    }

    @Test
    public void testEquals() {
        Assert.assertNotEquals(null, (Object)this.dateAndTime1);
        Assert.assertEquals((Object)this.dateAndTime1, (Object)this.dateAndTime1);
    }

    @Test
    public void testHashCode() {
        int result = this.dateAndTime1.hashCode();
        Assert.assertNotEquals((long)this.dateAndTime2.hashCode(), (long)result);
    }

    @Test
    public void testToString() {
        String result = this.dateAndTime1.toString();
        Assert.assertNotEquals((Object)this.dateAndTime2.toString(), (Object)result);
    }
}

