/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.h2;

import java.io.Reader;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;
import org.h2.jdbc.JdbcClob;

public class H2ClobConverterFactory
implements ConverterFactory {
    H2ClobConverter converter = new H2ClobConverter();

    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (!String.class.equals(target)) {
            return null;
        }
        if (!JdbcClob.class.isAssignableFrom(source)) {
            return null;
        }
        return this.converter;
    }

    static class H2ClobConverter
    implements Converter {
        H2ClobConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            JdbcClob clob = (JdbcClob)source;
            StringBuilder sb = new StringBuilder();
            char[] cbuf = new char[4096];
            try (Reader r = clob.getCharacterStream();){
                int read;
                while ((read = r.read(cbuf)) > 0) {
                    sb.append(cbuf, 0, read);
                }
                T t = target.cast(sb.toString());
                return t;
            }
        }
    }
}

