/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.colorconvert;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.imagen.ColorSpaceImageN;
import org.eclipse.imagen.IHSColorSpace;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.PointOpImage;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.ROIShape;
import org.eclipse.imagen.RasterFactory;
import org.eclipse.imagen.iterator.RandomIter;
import org.eclipse.imagen.media.colorconvert.ColorSpaceImageNExt;
import org.eclipse.imagen.media.colorconvert.ColorSpaceImageNExtWrapper;
import org.eclipse.imagen.media.iterators.RandomIterFactory;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.range.RangeDouble;
import org.eclipse.imagen.media.range.RangeFactory;
import org.eclipse.imagen.media.util.ImageUtil;

public class ColorConvertOpImage
extends PointOpImage {
    private static final Logger LOGGER = Logger.getLogger(ColorConvertOpImage.class.toString());
    public static final boolean ARRAY_CALC = true;
    public static final boolean TILE_CACHED = true;
    private static final ColorSpace rgbColorSpace = ColorSpace.getInstance(1000);
    private static SoftReference softRef = null;
    private ImageParameters srcParam = null;
    private ImageParameters dstParam = null;
    private ImageParameters tempParam = null;
    private ColorConvertOp colorConvertOp = null;
    private int caseNumber;
    private boolean hasROI;
    private boolean hasNoData;
    private ROI roi;
    private Rectangle roiBounds;
    private Range nodata;
    private final boolean caseA;
    private final boolean caseB;
    private final boolean caseC;
    private PlanarImage roiImage;
    private float[] destinationNoData;
    private float[] destinationNoDataNoJAI;
    private double[] background;

    private static synchronized ColorConvertOp getColorConvertOp(ColorSpace src, ColorSpace dst) {
        HashMap colorConvertOpBuf = null;
        if (softRef == null || (colorConvertOpBuf = (HashMap)softRef.get()) == null) {
            colorConvertOpBuf = new HashMap();
            softRef = new SoftReference<HashMap>(colorConvertOpBuf);
        }
        ArrayList<ColorSpace> hashcode = new ArrayList<ColorSpace>(2);
        hashcode.add(0, src);
        hashcode.add(1, dst);
        ColorConvertOp op = (ColorConvertOp)colorConvertOpBuf.get(hashcode);
        if (op == null) {
            op = new ColorConvertOp(src, dst, null);
            colorConvertOpBuf.put(hashcode, op);
        }
        return op;
    }

    private static float getMinValue(int dataType) {
        float minValue = 0.0f;
        switch (dataType) {
            case 0: {
                minValue = 0.0f;
                break;
            }
            case 2: {
                minValue = -32768.0f;
                break;
            }
            case 1: {
                minValue = 0.0f;
                break;
            }
            case 3: {
                minValue = -2.1474836E9f;
                break;
            }
            default: {
                minValue = 0.0f;
            }
        }
        return minValue;
    }

    private static float getRange(int dataType) {
        float range = 1.0f;
        switch (dataType) {
            case 0: {
                range = 255.0f;
                break;
            }
            case 2: {
                range = 65535.0f;
                break;
            }
            case 1: {
                range = 65535.0f;
                break;
            }
            case 3: {
                range = 4.2949673E9f;
                break;
            }
            default: {
                range = 1.0f;
            }
        }
        return range;
    }

    public ColorConvertOpImage(RenderedImage source, Map config, ImageLayout layout, ColorModel colorModel, Range nodata, ROI roi, double[] destNoData) {
        super(source, layout, config, true);
        this.colorModel = colorModel;
        this.srcParam = new ImageParameters(source.getColorModel(), source.getSampleModel());
        this.dstParam = new ImageParameters(colorModel, this.sampleModel);
        Object srcColorSpace = this.srcParam.getColorModel().getColorSpace();
        Object dstColorSpace = this.dstParam.getColorModel().getColorSpace();
        if (srcColorSpace instanceof ColorSpaceImageN && dstColorSpace instanceof ColorSpaceImageN) {
            this.caseNumber = 1;
            this.tempParam = this.createTempParam();
        } else if (srcColorSpace instanceof ColorSpaceImageN) {
            if (srcColorSpace instanceof IHSColorSpace) {
                srcColorSpace = ColorSpaceImageNExt.getIHSColorSpaceJAIEXT();
            }
            if (dstColorSpace != rgbColorSpace) {
                this.caseNumber = 2;
                this.tempParam = this.createTempParam();
                this.colorConvertOp = ColorConvertOpImage.getColorConvertOp(rgbColorSpace, (ColorSpace)dstColorSpace);
            } else {
                this.caseNumber = 3;
            }
        } else if (dstColorSpace instanceof ColorSpaceImageN) {
            if (dstColorSpace instanceof IHSColorSpace) {
                dstColorSpace = ColorSpaceImageNExt.getIHSColorSpaceJAIEXT();
            }
            if (srcColorSpace != rgbColorSpace) {
                this.caseNumber = 4;
                this.tempParam = this.createTempParam();
                this.colorConvertOp = ColorConvertOpImage.getColorConvertOp((ColorSpace)srcColorSpace, rgbColorSpace);
            } else {
                this.caseNumber = 5;
            }
        } else {
            this.caseNumber = 6;
            this.colorConvertOp = ColorConvertOpImage.getColorConvertOp((ColorSpace)srcColorSpace, (ColorSpace)dstColorSpace);
        }
        boolean bl = this.hasROI = roi != null;
        if (this.hasROI) {
            this.roi = roi;
            this.roiBounds = roi.getBounds();
        }
        boolean bl2 = this.hasNoData = nodata != null;
        if (this.hasNoData) {
            this.nodata = nodata;
        }
        this.caseA = !this.hasNoData && !this.hasROI;
        this.caseB = !this.hasNoData && this.hasROI;
        this.caseC = this.hasNoData && !this.hasROI;
        int numComponents = ((ColorSpace)srcColorSpace).getNumComponents();
        int numNoData = destNoData.length;
        int dataType = this.getSourceImage(0).getSampleModel().getDataType();
        boolean isFloat = dataType == 5 || dataType == 4;
        float minValue = ColorConvertOpImage.getMinValue(dataType);
        float range = ColorConvertOpImage.getRange(dataType);
        this.destinationNoDataNoJAI = new float[numComponents];
        this.destinationNoData = new float[numComponents];
        if (numComponents != numNoData) {
            if (numNoData <= 0) {
                throw new IllegalArgumentException("Input NoData have not been defined");
            }
            float nod = (float)destNoData[0];
            if (!isFloat) {
                nod = (nod - minValue) / range;
            }
            for (int i = 0; i < numComponents; ++i) {
                this.destinationNoDataNoJAI[i] = nod;
                this.destinationNoData[i] = (float)destNoData[0];
            }
        } else {
            for (int i = 0; i < numComponents; ++i) {
                float nod = (float)destNoData[i];
                this.destinationNoDataNoJAI[i] = nod = (nod - minValue) / range;
                this.destinationNoData[i] = (float)destNoData[i];
            }
        }
        this.destinationNoDataNoJAI = ((ColorSpace)srcColorSpace).toCIEXYZ(this.destinationNoDataNoJAI);
        this.destinationNoDataNoJAI = ((ColorSpace)dstColorSpace).fromCIEXYZ(this.destinationNoDataNoJAI);
        this.background = new double[numComponents];
        dataType = this.sampleModel.getDataType();
        if (dataType != 5 && dataType != 4) {
            minValue = ColorConvertOpImage.getMinValue(dataType);
            range = ColorConvertOpImage.getRange(dataType);
            for (int i = 0; i < numComponents; ++i) {
                double bkg = this.destinationNoDataNoJAI[0];
                this.background[i] = bkg = bkg * (double)range + (double)minValue;
                this.destinationNoDataNoJAI[i] = (float)bkg;
            }
        } else {
            for (int i = 0; i < numComponents; ++i) {
                this.background[i] = this.destinationNoDataNoJAI[i];
            }
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        WritableRaster tempRas = null;
        Raster source = sources[0];
        if (!destRect.equals(source.getBounds())) {
            source = source.createChild(destRect.x, destRect.y, destRect.width, destRect.height, destRect.x, destRect.y, null);
        }
        ROI roiTile = null;
        RandomIter roiIter = null;
        boolean roiContainsTile = false;
        boolean roiDisjointTile = false;
        if (this.hasROI) {
            Rectangle srcRectExpanded = this.mapDestRect(destRect, 0);
            srcRectExpanded.setRect(srcRectExpanded.getMinX() - 1.0, srcRectExpanded.getMinY() - 1.0, srcRectExpanded.getWidth() + 2.0, srcRectExpanded.getHeight() + 2.0);
            if (!this.roiBounds.intersects(srcRectExpanded)) {
                roiDisjointTile = true;
            } else {
                roiTile = this.roi.intersect((ROI)new ROIShape((Shape)srcRectExpanded));
                roiContainsTile = roiTile.contains(srcRectExpanded);
                if (!roiContainsTile) {
                    if (!roiTile.intersects(srcRectExpanded)) {
                        roiDisjointTile = true;
                    } else {
                        PlanarImage roiIMG = this.getImage();
                        roiIter = RandomIterFactory.create((RenderedImage)roiIMG, null, (boolean)true, (boolean)true);
                    }
                }
            }
        }
        switch (this.caseNumber) {
            case 1: {
                tempRas = this.computeRectColorSpaceJAIToRGB(source, this.srcParam, null, this.tempParam);
                this.computeRectColorSpaceJAIFromRGB(tempRas, this.tempParam, dest, this.dstParam);
                break;
            }
            case 2: {
                tempRas = this.computeRectColorSpaceJAIToRGB(source, this.srcParam, null, this.tempParam);
                this.computeRectNonColorSpaceJAI(tempRas, this.tempParam, dest, this.dstParam, destRect, roiDisjointTile, roiContainsTile, roiIter);
                break;
            }
            case 3: {
                this.computeRectColorSpaceJAIToRGB(source, this.srcParam, dest, this.dstParam);
                break;
            }
            case 4: {
                tempRas = this.createTempWritableRaster(source);
                this.computeRectNonColorSpaceJAI(source, this.srcParam, tempRas, this.tempParam, destRect, roiDisjointTile, roiContainsTile, roiIter);
                this.computeRectColorSpaceJAIFromRGB(tempRas, this.tempParam, dest, this.dstParam);
                break;
            }
            case 5: {
                this.computeRectColorSpaceJAIFromRGB(source, this.srcParam, dest, this.dstParam);
                break;
            }
            case 6: {
                this.computeRectNonColorSpaceJAI(source, this.srcParam, dest, this.dstParam, destRect, roiDisjointTile, roiContainsTile, roiIter);
            }
        }
    }

    private WritableRaster computeRectColorSpaceJAIToRGB(Raster src, ImageParameters srcParam, WritableRaster dest, ImageParameters dstParam) {
        ColorSpaceImageNExt colorSpaceJAIExt;
        src = this.convertRasterToUnsigned(src);
        ColorSpaceImageN colorSpaceJAI = (ColorSpaceImageN)srcParam.getColorModel().getColorSpace();
        if (colorSpaceJAI instanceof ColorSpaceImageNExt) {
            colorSpaceJAIExt = (ColorSpaceImageNExt)colorSpaceJAI;
        } else if (colorSpaceJAI instanceof IHSColorSpace) {
            colorSpaceJAIExt = ColorSpaceImageNExt.getIHSColorSpaceJAIEXT();
        } else {
            colorSpaceJAIExt = new ColorSpaceImageNExtWrapper(colorSpaceJAI);
            LOGGER.log(Level.SEVERE, "Input colorspace is not an instance of ColorSpaceImageNExt, No ROI/NoData support provided");
        }
        dest = colorSpaceJAIExt.toRGB(src, srcParam.getComponentSize(), dest, dstParam.getComponentSize(), this.roi, this.nodata, this.destinationNoData);
        dest = this.convertRasterToSigned(dest);
        return dest;
    }

    private WritableRaster computeRectColorSpaceJAIFromRGB(Raster src, ImageParameters srcParam, WritableRaster dest, ImageParameters dstParam) {
        ColorSpaceImageNExt colorSpaceJAIExt;
        src = this.convertRasterToUnsigned(src);
        ColorSpaceImageN colorSpaceJAI = (ColorSpaceImageN)dstParam.getColorModel().getColorSpace();
        if (colorSpaceJAI instanceof ColorSpaceImageNExt) {
            colorSpaceJAIExt = (ColorSpaceImageNExt)colorSpaceJAI;
        } else if (colorSpaceJAI instanceof IHSColorSpace) {
            colorSpaceJAIExt = ColorSpaceImageNExt.getIHSColorSpaceJAIEXT();
        } else {
            colorSpaceJAIExt = new ColorSpaceImageNExtWrapper(colorSpaceJAI);
            LOGGER.log(Level.SEVERE, "Input colorspace is not an instance of ColorSpaceImageNExt, No ROI/NoData support provided");
        }
        dest = colorSpaceJAIExt.fromRGB(src, srcParam.getComponentSize(), dest, dstParam.getComponentSize(), this.roi, this.nodata, this.destinationNoData);
        dest = this.convertRasterToSigned(dest);
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeRectNonColorSpaceJAI(Raster src, ImageParameters srcParam, WritableRaster dest, ImageParameters dstParam, Rectangle destRect, boolean roiDisjointTile, boolean roiContainsTile, RandomIter roiIter) {
        boolean noFloat;
        boolean bl = noFloat = !srcParam.isFloat() && !dstParam.isFloat();
        if (this.caseA && this.colorConvertOp != null && noFloat) {
            WritableRaster d;
            Raster s = src;
            if (s.getMinX() != destRect.x || s.getMinY() != destRect.y || s.getWidth() != destRect.width || s.getHeight() != destRect.height) {
                s = s.createChild(destRect.x, destRect.y, destRect.width, destRect.height, destRect.x, destRect.y, null);
            }
            if ((d = dest).getMinX() != destRect.x || d.getMinY() != destRect.y || d.getWidth() != destRect.width || d.getHeight() != destRect.height) {
                d = d.createWritableChild(destRect.x, destRect.y, destRect.width, destRect.height, destRect.x, destRect.y, null);
            }
            Class<?> clazz = this.colorConvertOp.getClass();
            synchronized (clazz) {
                this.colorConvertOp.filter(s, d);
            }
        } else {
            this.computeRectNonColorSpaceJAIInternal(src, srcParam, dest, dstParam, destRect, roiDisjointTile, roiContainsTile, roiIter);
        }
    }

    private void computeRectNonColorSpaceJAIInternal(Raster src, ImageParameters srcParam, WritableRaster dest, ImageParameters dstParam, Rectangle destRect, boolean roiDisjointTile, boolean roiContainsTile, RandomIter roiIter) {
        RangeDouble noData;
        ColorSpace srcColorSpace = srcParam.getColorModel().getColorSpace();
        ColorSpace dstColorSpace = dstParam.getColorModel().getColorSpace();
        boolean srcFloat = srcParam.isFloat();
        float srcMinValue = srcParam.getMinValue();
        float srcRange = srcParam.getRange();
        boolean dstFloat = dstParam.isFloat();
        float dstMinValue = dstParam.getMinValue();
        float dstRange = dstParam.getRange();
        int rectYMax = destRect.y + destRect.height;
        int rectXMax = destRect.x + destRect.width;
        int srcNumComponents = srcColorSpace.getNumComponents();
        int dstNumComponents = dstColorSpace.getNumComponents();
        float[] srcPixel = new float[srcNumComponents];
        RangeDouble rangeDouble = noData = this.hasNoData ? RangeFactory.convertToDoubleRange((Range)this.nodata) : null;
        if (roiDisjointTile) {
            ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)destRect, (double[])this.background);
            return;
        }
        if (this.caseA || this.hasROI && roiContainsTile) {
            for (int y = destRect.y; y < rectYMax; ++y) {
                for (int x = destRect.x; x < rectXMax; ++x) {
                    int i;
                    srcPixel = src.getPixel(x, y, srcPixel);
                    if (!srcFloat) {
                        for (i = 0; i < srcNumComponents; ++i) {
                            srcPixel[i] = (srcPixel[i] - srcMinValue) / srcRange;
                        }
                    }
                    float[] xyzPixel = srcColorSpace.toCIEXYZ(srcPixel);
                    float[] dstPixel = dstColorSpace.fromCIEXYZ(xyzPixel);
                    if (!dstFloat) {
                        for (i = 0; i < dstNumComponents; ++i) {
                            dstPixel[i] = dstPixel[i] * dstRange + dstMinValue;
                        }
                    }
                    dest.setPixel(x, y, dstPixel);
                }
            }
        } else if (this.caseB) {
            for (int y = destRect.y; y < rectYMax; ++y) {
                for (int x = destRect.x; x < rectXMax; ++x) {
                    float[] dstPixel;
                    if (!this.roiBounds.contains(x, y) || roiIter.getSample(x, y, 0) <= 0) {
                        dstPixel = this.destinationNoDataNoJAI;
                    } else {
                        int i;
                        srcPixel = src.getPixel(x, y, srcPixel);
                        if (!srcFloat) {
                            for (i = 0; i < srcNumComponents; ++i) {
                                srcPixel[i] = (srcPixel[i] - srcMinValue) / srcRange;
                            }
                        }
                        float[] xyzPixel = srcColorSpace.toCIEXYZ(srcPixel);
                        dstPixel = dstColorSpace.fromCIEXYZ(xyzPixel);
                        if (!dstFloat) {
                            for (i = 0; i < dstNumComponents; ++i) {
                                dstPixel[i] = dstPixel[i] * dstRange + dstMinValue;
                            }
                        }
                    }
                    dest.setPixel(x, y, dstPixel);
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int y = destRect.y; y < rectYMax; ++y) {
                for (int x = destRect.x; x < rectXMax; ++x) {
                    float[] dstPixel;
                    int i;
                    srcPixel = src.getPixel(x, y, srcPixel);
                    boolean valid = true;
                    for (i = 0; i < srcNumComponents && valid; valid &= !noData.contains((double)srcPixel[i]), ++i) {
                    }
                    if (!valid) {
                        dstPixel = this.destinationNoDataNoJAI;
                    } else {
                        if (!srcFloat) {
                            for (i = 0; i < srcNumComponents; ++i) {
                                srcPixel[i] = (srcPixel[i] - srcMinValue) / srcRange;
                            }
                        }
                        float[] xyzPixel = srcColorSpace.toCIEXYZ(srcPixel);
                        dstPixel = dstColorSpace.fromCIEXYZ(xyzPixel);
                        if (!dstFloat) {
                            for (i = 0; i < dstNumComponents; ++i) {
                                dstPixel[i] = dstPixel[i] * dstRange + dstMinValue;
                            }
                        }
                    }
                    dest.setPixel(x, y, dstPixel);
                }
            }
        } else {
            for (int y = destRect.y; y < rectYMax; ++y) {
                for (int x = destRect.x; x < rectXMax; ++x) {
                    float[] dstPixel;
                    if (!this.roiBounds.contains(x, y) || roiIter.getSample(x, y, 0) <= 0) {
                        dstPixel = this.destinationNoDataNoJAI;
                    } else {
                        int i;
                        srcPixel = src.getPixel(x, y, srcPixel);
                        boolean valid = true;
                        for (i = 0; i < srcNumComponents && valid; valid &= !noData.contains((double)srcPixel[i]), ++i) {
                        }
                        if (!valid) {
                            dstPixel = this.destinationNoDataNoJAI;
                        } else {
                            if (!srcFloat) {
                                for (i = 0; i < srcNumComponents; ++i) {
                                    srcPixel[i] = (srcPixel[i] - srcMinValue) / srcRange;
                                }
                            }
                            float[] xyzPixel = srcColorSpace.toCIEXYZ(srcPixel);
                            dstPixel = dstColorSpace.fromCIEXYZ(xyzPixel);
                            if (!dstFloat) {
                                for (i = 0; i < dstNumComponents; ++i) {
                                    dstPixel[i] = dstPixel[i] * dstRange + dstMinValue;
                                }
                            }
                        }
                    }
                    dest.setPixel(x, y, dstPixel);
                }
            }
        }
    }

    private ImageParameters createTempParam() {
        ColorModel cm = null;
        SampleModel sm = null;
        if (this.srcParam.getDataType() > this.dstParam.getDataType()) {
            cm = this.srcParam.getColorModel();
            sm = this.srcParam.getSampleModel();
        } else {
            cm = this.dstParam.getColorModel();
            sm = this.dstParam.getSampleModel();
        }
        cm = new ComponentColorModel(rgbColorSpace, cm.getComponentSize(), cm.hasAlpha(), cm.isAlphaPremultiplied(), cm.getTransparency(), sm.getDataType());
        return new ImageParameters(cm, sm);
    }

    private WritableRaster createTempWritableRaster(Raster src) {
        Point origin = new Point(src.getMinX(), src.getMinY());
        return RasterFactory.createWritableRaster((SampleModel)src.getSampleModel(), (Point)origin);
    }

    private Raster convertRasterToUnsigned(Raster ras) {
        int type = ras.getSampleModel().getDataType();
        WritableRaster tempRas = null;
        if (type == 3 || type == 2) {
            int minX = ras.getMinX();
            int minY = ras.getMinY();
            int w = ras.getWidth();
            int h = ras.getHeight();
            int[] buf = ras.getPixels(minX, minY, w, h, (int[])null);
            this.convertBufferToUnsigned(buf, type);
            tempRas = this.createTempWritableRaster(ras);
            tempRas.setPixels(minX, minY, w, h, buf);
            return tempRas;
        }
        return ras;
    }

    private WritableRaster convertRasterToSigned(WritableRaster ras) {
        int type = ras.getSampleModel().getDataType();
        WritableRaster tempRas = null;
        if (type == 3 || type == 2) {
            int minX = ras.getMinX();
            int minY = ras.getMinY();
            int w = ras.getWidth();
            int h = ras.getHeight();
            int[] buf = ras.getPixels(minX, minY, w, h, (int[])null);
            this.convertBufferToSigned(buf, type);
            tempRas = ras instanceof WritableRaster ? ras : this.createTempWritableRaster(ras);
            tempRas.setPixels(minX, minY, w, h, buf);
            return tempRas;
        }
        return ras;
    }

    private void convertBufferToSigned(int[] buf, int type) {
        block4: {
            block3: {
                if (buf == null) {
                    return;
                }
                if (type != 2) break block3;
                int i = 0;
                while (i < buf.length) {
                    int n = i++;
                    buf[n] = buf[n] + Short.MIN_VALUE;
                }
                break block4;
            }
            if (type != 3) break block4;
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (int)(((long)buf[i] & 0xFFFFFFFFL) + Integer.MIN_VALUE);
            }
        }
    }

    private void convertBufferToUnsigned(int[] buf, int type) {
        block4: {
            block3: {
                if (buf == null) {
                    return;
                }
                if (type != 2) break block3;
                int i = 0;
                while (i < buf.length) {
                    int n = i++;
                    buf[n] = buf[n] - Short.MIN_VALUE;
                }
                break block4;
            }
            if (type != 3) break block4;
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (int)(((long)buf[i] & 0xFFFFFFFFL) - Integer.MIN_VALUE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlanarImage getImage() {
        PlanarImage img = this.roiImage;
        if (img == null) {
            ColorConvertOpImage colorConvertOpImage = this;
            synchronized (colorConvertOpImage) {
                img = this.roiImage;
                if (img == null) {
                    this.roiImage = img = this.roi.getAsImage();
                }
            }
        }
        return img;
    }

    private final class ImageParameters {
        private boolean isFloat;
        private ColorModel colorModel;
        private SampleModel sampleModel;
        private float minValue;
        private float range;
        private int[] componentSize;
        private int dataType;

        ImageParameters(ColorModel cm, SampleModel sm) {
            this.colorModel = cm;
            this.sampleModel = sm;
            this.dataType = sm.getDataType();
            this.isFloat = this.dataType == 4 || this.dataType == 5;
            this.minValue = ColorConvertOpImage.getMinValue(this.dataType);
            this.range = ColorConvertOpImage.getRange(this.dataType);
            this.componentSize = cm.getComponentSize();
        }

        public boolean isFloat() {
            return this.isFloat;
        }

        public ColorModel getColorModel() {
            return this.colorModel;
        }

        public SampleModel getSampleModel() {
            return this.sampleModel;
        }

        public float getMinValue() {
            return this.minValue;
        }

        public float getRange() {
            return this.range;
        }

        public int[] getComponentSize() {
            return this.componentSize;
        }

        public int getDataType() {
            return this.dataType;
        }
    }
}

