/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.scale;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.util.Map;
import org.eclipse.imagen.BorderExtender;
import org.eclipse.imagen.CRIFImpl;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.Interpolation;
import org.eclipse.imagen.InterpolationBicubic;
import org.eclipse.imagen.InterpolationBicubic2;
import org.eclipse.imagen.InterpolationBilinear;
import org.eclipse.imagen.InterpolationNearest;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.media.opimage.CopyOpImage;
import org.eclipse.imagen.media.opimage.RIFUtil;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.range.RangeFactory;
import org.eclipse.imagen.media.scale.Scale2BicubicOpImage;
import org.eclipse.imagen.media.scale.Scale2BilinearOpImage;
import org.eclipse.imagen.media.scale.Scale2GeneralOpImage;
import org.eclipse.imagen.media.scale.Scale2NearestOpImage;
import org.eclipse.imagen.media.translate.TranslateIntOpImage;

public class Scale2CRIF
extends CRIFImpl {
    static final float TOLERANCE = 0.01f;

    public Scale2CRIF() {
        super("Scale2");
    }

    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        double destinationNoData;
        ImageLayout layout = RIFUtil.getImageLayoutHint((RenderingHints)renderHints);
        BorderExtender extender = RIFUtil.getBorderExtenderHint((RenderingHints)renderHints);
        RenderedImage source = paramBlock.getRenderedSource(0);
        double xScale = paramBlock.getDoubleParameter(0);
        double yScale = paramBlock.getDoubleParameter(1);
        double xTrans = paramBlock.getDoubleParameter(2);
        double yTrans = paramBlock.getDoubleParameter(3);
        Interpolation interp = (Interpolation)paramBlock.getObjectParameter(4);
        Range nodata = (Range)paramBlock.getObjectParameter(7);
        nodata = RangeFactory.convert((Range)nodata, (int)source.getSampleModel().getDataType());
        double[] backgroundValues = (double[])paramBlock.getObjectParameter(8);
        Object property = paramBlock.getObjectParameter(5);
        ROI roi = null;
        boolean useRoiAccessor = false;
        if (property instanceof ROI) {
            roi = (ROI)property;
            PlanarImage temp = PlanarImage.wrapRenderedImage((RenderedImage)source);
            temp.setProperty("ROI", (Object)roi);
            source = temp;
            useRoiAccessor = (Boolean)paramBlock.getObjectParameter(6);
        }
        Rectangle sourceBounds = new Rectangle(source.getMinX(), source.getMinY(), source.getWidth(), source.getHeight());
        if (xScale == 1.0 && yScale == 1.0 && xTrans == 0.0 && yTrans == 0.0 && (roi == null || roi.getBounds().isEmpty() || roi.contains(sourceBounds))) {
            return new CopyOpImage(source, (Map)renderHints, layout);
        }
        if (xScale == 1.0 && yScale == 1.0 && Math.abs(xTrans - (double)((int)xTrans)) < (double)0.01f && Math.abs(yTrans - (double)((int)yTrans)) < (double)0.01f && layout == null && (roi == null || roi.getBounds().isEmpty() || roi.contains(sourceBounds))) {
            return new TranslateIntOpImage(source, (Map)renderHints, (int)xTrans, (int)yTrans);
        }
        SampleModel sm = source.getSampleModel();
        boolean isBinary = sm instanceof MultiPixelPackedSampleModel && sm.getSampleSize(0) == 1 && (sm.getDataType() == 0 || sm.getDataType() == 1 || sm.getDataType() == 3);
        boolean nearestInterp = interp instanceof org.eclipse.imagen.media.interpolators.InterpolationNearest || interp instanceof InterpolationNearest;
        boolean bilinearInterp = interp instanceof org.eclipse.imagen.media.interpolators.InterpolationBilinear || interp instanceof InterpolationBilinear;
        boolean bicubicInterp = interp instanceof org.eclipse.imagen.media.interpolators.InterpolationBicubic || interp instanceof InterpolationBicubic || interp instanceof InterpolationBicubic2;
        int dataType = source.getSampleModel().getDataType();
        double d = backgroundValues != null && backgroundValues.length > 0 ? backgroundValues[0] : (destinationNoData = nodata != null ? nodata.getMin().doubleValue() : 0.0);
        if (interp instanceof InterpolationNearest) {
            interp = new org.eclipse.imagen.media.interpolators.InterpolationNearest(nodata, useRoiAccessor, destinationNoData, dataType);
        } else if (interp instanceof InterpolationBilinear) {
            interp = new org.eclipse.imagen.media.interpolators.InterpolationBilinear(interp.getSubsampleBitsH(), nodata, useRoiAccessor, destinationNoData, dataType);
        } else if (interp instanceof InterpolationBicubic) {
            InterpolationBicubic bic = (InterpolationBicubic)interp;
            interp = new org.eclipse.imagen.media.interpolators.InterpolationBicubic(bic.getSubsampleBitsH(), nodata, useRoiAccessor, destinationNoData, dataType, true, bic.getPrecisionBits());
        } else if (interp instanceof InterpolationBicubic2) {
            InterpolationBicubic2 bic = (InterpolationBicubic2)interp;
            interp = new org.eclipse.imagen.media.interpolators.InterpolationBicubic(bic.getSubsampleBitsH(), nodata, useRoiAccessor, destinationNoData, dataType, false, bic.getPrecisionBits());
        }
        if (nearestInterp && isBinary) {
            return new Scale2GeneralOpImage(source, layout, (Map)renderHints, extender, interp, xScale, yScale, xTrans, yTrans, useRoiAccessor, nodata, backgroundValues);
        }
        if (nearestInterp && !isBinary) {
            return new Scale2NearestOpImage(source, layout, (Map)renderHints, extender, interp, xScale, yScale, xTrans, yTrans, useRoiAccessor, nodata, backgroundValues);
        }
        if (bilinearInterp && !isBinary) {
            return new Scale2BilinearOpImage(source, layout, (Map)renderHints, extender, interp, xScale, yScale, xTrans, yTrans, useRoiAccessor, nodata, backgroundValues);
        }
        if (bilinearInterp && isBinary) {
            return new Scale2GeneralOpImage(source, layout, (Map)renderHints, extender, interp, xScale, yScale, xTrans, yTrans, useRoiAccessor, nodata, backgroundValues);
        }
        if (bicubicInterp && !isBinary) {
            return new Scale2BicubicOpImage(source, layout, (Map)renderHints, extender, interp, xScale, yScale, xTrans, yTrans, useRoiAccessor, nodata, backgroundValues);
        }
        if (bicubicInterp && isBinary) {
            return new Scale2GeneralOpImage(source, layout, (Map)renderHints, extender, interp, xScale, yScale, xTrans, yTrans, useRoiAccessor, nodata, backgroundValues);
        }
        return new Scale2GeneralOpImage(source, layout, (Map)renderHints, extender, interp, xScale, yScale, xTrans, yTrans, useRoiAccessor, nodata, backgroundValues);
    }

    public RenderedImage create(RenderContext renderContext, ParameterBlock paramBlock) {
        return paramBlock.getRenderedSource(0);
    }

    public RenderContext mapRenderContext(int i, RenderContext renderContext, ParameterBlock paramBlock, RenderableImage image) {
        float scale_x = paramBlock.getFloatParameter(0);
        float scale_y = paramBlock.getFloatParameter(1);
        float trans_x = paramBlock.getFloatParameter(2);
        float trans_y = paramBlock.getFloatParameter(3);
        AffineTransform scale = new AffineTransform((double)scale_x, 0.0, 0.0, (double)scale_y, (double)trans_x, (double)trans_y);
        RenderContext rc = (RenderContext)renderContext.clone();
        AffineTransform usr2dev = rc.getTransform();
        usr2dev.concatenate(scale);
        rc.setTransform(usr2dev);
        return rc;
    }

    public Rectangle2D getBounds2D(ParameterBlock paramBlock) {
        RenderableImage source = paramBlock.getRenderableSource(0);
        float scale_x = paramBlock.getFloatParameter(0);
        float scale_y = paramBlock.getFloatParameter(1);
        float trans_x = paramBlock.getFloatParameter(2);
        float trans_y = paramBlock.getFloatParameter(3);
        float x0 = source.getMinX();
        float y0 = source.getMinY();
        float w = source.getWidth();
        float h = source.getHeight();
        float d_x0 = x0 * scale_x + trans_x;
        float d_y0 = y0 * scale_y + trans_y;
        float d_w = w * scale_x;
        float d_h = h * scale_y;
        return new Rectangle2D.Float(d_x0, d_y0, d_w, d_h);
    }
}

