/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin.debug;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import sun.java2d.ReentrantContext;

public final class MarlinDebugThreadLocal
extends ReentrantContext {
    private static final ThreadLocal<MarlinDebugThreadLocal> ctxTL = new ThreadLocal();
    private final ArrayList<Point2D> points = new ArrayList(10);

    public static MarlinDebugThreadLocal get() {
        MarlinDebugThreadLocal ctx = ctxTL.get();
        if (ctx == null) {
            ctx = new MarlinDebugThreadLocal();
            ctxTL.set(ctx);
        }
        return ctx;
    }

    public static void release(MarlinDebugThreadLocal ctx) {
        ctx.reset();
    }

    public static void sampleUsage() {
        MarlinDebugThreadLocal dbgCtx = MarlinDebugThreadLocal.get();
        try {
            dbgCtx.addPoint(0.0, 0.0);
        }
        finally {
            MarlinDebugThreadLocal.release(dbgCtx);
        }
    }

    private MarlinDebugThreadLocal() {
    }

    public void reset() {
        this.points.clear();
    }

    public List<Point2D> getPoints() {
        return this.points;
    }

    public void addPoint(double x, double y) {
        this.points.add(new Point2D.Double(x, y));
    }
}

