/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import sun.awt.SunToolkit;
import sun.java2d.pipe.RenderBuffer;
import sun.security.action.GetPropertyAction;

public abstract class RenderQueue {
    private static final int BUFFER_SIZE = RenderQueue.align(RenderQueue.getInteger("sun.java2d.render.bufferSize", 0x100000, 32768, 0x1000000), 1024);
    protected final RenderBuffer buf;
    protected final Set<Object> refSet = new HashSet<Object>(64);

    protected RenderQueue() {
        this.buf = RenderBuffer.allocate(BUFFER_SIZE);
    }

    public final void lock() {
        SunToolkit.awtLock();
    }

    public final boolean tryLock() {
        return SunToolkit.awtTryLock();
    }

    public final void unlock() {
        SunToolkit.awtUnlock();
    }

    public final void addReference(Object ref) {
        this.refSet.add(ref);
    }

    public final RenderBuffer getBuffer() {
        return this.buf;
    }

    public final void ensureCapacity(int opsize) {
        if (this.buf.remaining() < opsize) {
            this.flushNow();
        }
    }

    public final void ensureCapacityAndAlignment(int opsize, int first8ByteValueOffset) {
        this.ensureCapacity(opsize + 4);
        this.ensureAlignment(first8ByteValueOffset);
    }

    public final void ensureAlignment(int first8ByteValueOffset) {
        int first8ByteValuePosition = this.buf.position() + first8ByteValueOffset;
        if ((first8ByteValuePosition & 7) != 0) {
            this.buf.putInt(90);
        }
    }

    public abstract void flushNow();

    public abstract void flushAndInvokeNow(Runnable var1);

    public void flushNow(int position) {
        this.buf.position(position);
        this.flushNow();
    }

    public static int getInteger(String key, int def, int min, int max) {
        String property = AccessController.doPrivileged(new GetPropertyAction(key));
        int value = def;
        if (property != null) {
            try {
                value = Integer.decode(property);
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid integer value for " + key + " = " + property);
            }
        }
        if (value < min || value > max) {
            System.out.println("Invalid value for " + key + " = " + value + "; expected value in range[" + min + ", " + max + "] !");
            value = def;
        }
        return value;
    }

    protected static int align(int val, int norm) {
        int ceil = (int)Math.ceil((float)val / (float)norm);
        return ceil * norm;
    }

    static {
        System.out.println("RenderQueue: sun.java2d.render.bufferSize = " + BUFFER_SIZE);
    }
}

