/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wms.map;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.Position2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.GridReaderLayer;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.WebMapServer;
import org.geotools.ows.wms.map.WMSCoverageReader;
import org.geotools.ows.wms.request.GetMapRequest;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RendererUtilities;

public class WMSLayer
extends GridReaderLayer {
    static Style STYLE;

    public WMSLayer(WebMapServer wms, Layer layer) {
        super((GridCoverage2DReader)new WMSCoverageReader(wms, layer), STYLE);
    }

    public WMSLayer(WebMapServer wms, Layer layer, String style) {
        super((GridCoverage2DReader)new WMSCoverageReader(wms, layer, style), STYLE);
    }

    public WMSLayer(WebMapServer wms, Layer layer, String style, String imageFromat) {
        super((GridCoverage2DReader)new WMSCoverageReader(wms, layer, style, imageFromat), STYLE);
    }

    public WMSCoverageReader getReader() {
        return (WMSCoverageReader)this.reader;
    }

    public synchronized ReferencedEnvelope getBounds() {
        WMSCoverageReader wmsReader = this.getReader();
        if (wmsReader != null) {
            return wmsReader.bounds;
        }
        return super.getBounds();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getFeatureInfoAsText(Position2D pos, int featureCount) throws IOException {
        GetMapRequest mapRequest = this.getReader().mapRequest;
        try (InputStream is = this.getReader().getFeatureInfo(pos, "text/plain", featureCount, mapRequest);){
            String string;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                string = sb.toString();
            }
            return string;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw (IOException)new IOException("Failed to grab feature info").initCause(t);
        }
    }

    public InputStream getFeatureInfo(Position2D pos, String infoFormat, int featureCount) throws IOException {
        GetMapRequest mapRequest = this.getReader().mapRequest;
        return this.getReader().getFeatureInfo(pos, infoFormat, featureCount, mapRequest);
    }

    public InputStream getFeatureInfo(ReferencedEnvelope bbox, int width, int height, int x, int y, String infoFormat, int featureCount) throws IOException {
        try {
            this.getReader().initMapRequest(bbox, width, height, null);
            AffineTransform at = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)bbox, (Rectangle)new Rectangle(width, height));
            Point2D.Double screenPos = new Point2D.Double(x, y);
            Point2D.Double worldPos = new Point2D.Double(x, y);
            at.inverseTransform(screenPos, worldPos);
            Position2D fromPos = new Position2D(((Point2D)worldPos).getX(), ((Point2D)worldPos).getY());
            Position2D toPos = new Position2D();
            MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)bbox.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)this.getReader().requestedEnvelope.getCoordinateReferenceSystem(), (boolean)true);
            mt.transform((Position)fromPos, (Position)toPos);
            GetMapRequest mapRequest = this.getLastGetMap();
            return this.getReader().getFeatureInfo(toPos, infoFormat, featureCount, mapRequest);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw (IOException)new IOException("Unexpected issue during GetFeatureInfo execution").initCause(t);
        }
    }

    public WebMapServer getWebMapServer() {
        return this.getReader().wms;
    }

    public List<Layer> getWMSLayers() {
        return ((WMSCoverageReader)this.reader).getLayers();
    }

    public List<String> getWMSStyles() {
        return ((WMSCoverageReader)this.reader).getStyles();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.reader.getCoordinateReferenceSystem();
    }

    public GetMapRequest getLastGetMap() {
        return this.getReader().mapRequest;
    }

    public void addLayer(Layer layer) {
        this.addLayer(layer, "");
    }

    public void addLayer(Layer layer, String style) {
        this.getReader().addLayer(layer, style);
    }

    public boolean isNativelySupported(CoordinateReferenceSystem crs) {
        try {
            String code = CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)false);
            return code != null && this.getReader().validSRS.contains(code);
        }
        catch (Throwable t) {
            return false;
        }
    }

    static {
        StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
        RasterSymbolizer symbolizer = factory.createRasterSymbolizer();
        Rule rule = factory.createRule();
        rule.symbolizers().add(symbolizer);
        FeatureTypeStyle type = factory.createFeatureTypeStyle();
        type.rules().add(rule);
        STYLE = factory.createStyle();
        STYLE.featureTypeStyles().add(type);
    }
}

