/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config.wms.parameters;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.geotools.ows.wms.xml.Dimension;
import org.geotools.ows.wms.xml.Extent;
import org.geowebcache.config.wms.parameters.WMSDimensionProvider;
import org.geowebcache.filter.parameters.ParameterException;
import org.geowebcache.filter.parameters.ParameterFilter;

public class NaiveWMSDimensionFilter
extends ParameterFilter
implements WMSDimensionProvider {
    private static final long serialVersionUID = 8217550988333856916L;
    private Dimension dimension;
    private Extent extent;

    public NaiveWMSDimensionFilter(Dimension dimension, Extent extent) {
        Preconditions.checkNotNull((Object)dimension);
        Preconditions.checkNotNull((Object)extent);
        this.dimension = dimension;
        this.extent = extent;
        Object keyName = dimension.getName();
        if (((String)keyName).compareToIgnoreCase("time") != 0 && ((String)keyName).compareToIgnoreCase("elevation") != 0) {
            keyName = "dim_" + (String)keyName;
        }
        this.setKey((String)keyName);
        this.setDefaultValue(extent.getDefaultValue());
    }

    public String apply(String str) throws ParameterException {
        if (str == null || str.isEmpty()) {
            return this.getDefaultValue();
        }
        return str;
    }

    public List<String> getLegalValues() {
        return null;
    }

    @Override
    public void appendDimensionElement(StringBuilder str, String indent) {
        str.append(indent).append("<Dimension name=\"").append(this.dimension.getName());
        str.append("\" units=\"").append(this.dimension.getUnits()).append("\"></Dimension>\n");
    }

    @Override
    public void appendExtentElement(StringBuilder str, String indent) {
        str.append(indent).append("<Extent name=\"" + this.extent.getName() + "\"");
        if (this.extent.getDefaultValue() != null) {
            str.append(" default=\"" + this.extent.getDefaultValue() + "\"");
        }
        str.append(">");
        if (this.extent.getValue() != null) {
            str.append(this.extent.getValue());
        }
        str.append("</Extent>\n");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof NaiveWMSDimensionFilter)) return false;
        NaiveWMSDimensionFilter nwmsdf = (NaiveWMSDimensionFilter)o;
        if (!super.equals(o)) return false;
        if (!this.equals(this.dimension, nwmsdf.dimension)) return false;
        if (!this.equals(this.extent, nwmsdf.extent)) return false;
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + this.hashCode(this.dimension);
        hashCode = 31 * hashCode + this.hashCode(this.extent);
        return hashCode;
    }

    public NaiveWMSDimensionFilter clone() {
        return new NaiveWMSDimensionFilter(this.dimension, this.extent);
    }

    private boolean equals(Extent a, Extent b) {
        if (a == null || b == null) {
            return a == b;
        }
        return Objects.equals(a.getName(), b.getName()) && Objects.equals(a.getDefaultValue(), b.getDefaultValue()) && Objects.equals(a.getNearestValue(), b.getNearestValue()) && Objects.equals(a.isMultipleValues(), b.isMultipleValues()) && Objects.equals(a.isCurrent(), b.isCurrent());
    }

    private int hashCode(Extent a) {
        return a == null ? 1 : Objects.hash(a.getName(), a.getDefaultValue(), a.getNearestValue(), a.isMultipleValues(), a.isCurrent());
    }

    private boolean equals(Dimension a, Dimension b) {
        if (a == null || b == null) {
            return a == b;
        }
        return Objects.equals(a.getName(), b.getName()) && Objects.equals(a.getUnits(), b.getUnits()) && Objects.equals(a.getUnitSymbol(), b.getUnitSymbol()) && Objects.equals(a.isCurrent(), b.isCurrent()) && this.equals(a.getExtent(), b.getExtent());
    }

    private int hashCode(Dimension a) {
        int hash = Objects.hash(a.getName(), a.getUnits(), a.getUnitSymbol(), a.isCurrent());
        return 31 * hash + this.hashCode(a.getExtent());
    }

    public String toString() {
        return "NaiveWMSDimensionFilter [dimension=" + String.valueOf(this.dimension) + ", extent=" + String.valueOf(this.extent) + "]";
    }
}

