/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.io.codec;

import it.geosolutions.imageio.stream.input.FileImageInputStreamExtImpl;
import it.geosolutions.imageio.stream.input.ImageInputStreamAdapter;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.geotools.util.logging.Logging;
import org.geowebcache.io.FileResource;
import org.geowebcache.io.Resource;
import org.geowebcache.io.codec.ImageDecoder;
import org.geowebcache.io.codec.ImageEncoderImpl;

public class ImageDecoderImpl
implements ImageDecoder {
    private static final Logger LOGGER = Logging.getLogger((String)ImageEncoderImpl.class.getName());
    public static final String OPERATION_NOT_SUPPORTED = "Operation not supported";
    private final boolean isAggressiveInputStreamSupported;
    private final List<String> supportedMimeTypes;
    private ImageReaderSpi spi;

    public ImageDecoderImpl(boolean aggressiveInputStreamOptimization, List<String> supportedMimeTypes) {
        this(aggressiveInputStreamOptimization, supportedMimeTypes, null);
    }

    public ImageDecoderImpl(boolean aggressiveInputStreamOptimization, List<String> supportedMimeTypes, String preferredSpi) {
        this.isAggressiveInputStreamSupported = aggressiveInputStreamOptimization;
        this.supportedMimeTypes = new ArrayList<String>(supportedMimeTypes);
        Object backupSPI = null;
        for (String mimeType : supportedMimeTypes) {
            ImageReaderSpi readerSpi;
            Iterator<ImageReader> reader = ImageIO.getImageReadersByMIMEType(mimeType);
            if (!reader.hasNext() || (readerSpi = reader.next().getOriginatingProvider()) == null) continue;
            if (preferredSpi == null) {
                this.spi = readerSpi;
                break;
            }
            if (readerSpi.getClass().getName().equals(preferredSpi)) {
                this.spi = readerSpi;
                break;
            }
            if (backupSPI != null) continue;
            backupSPI = readerSpi;
        }
        if (this.spi == null) {
            if (backupSPI == null) {
                throw new IllegalArgumentException("No ImageReaderSpi found for the selected mimetypes: " + String.valueOf(supportedMimeTypes));
            }
            LOGGER.log(Level.WARNING, "Preferred SPI not found, using the first available one: " + backupSPI.getClass().getName());
            this.spi = backupSPI;
        }
    }

    @Override
    public BufferedImage decode(Object source, boolean aggressiveInputStreamOptimization, Map<String, Object> map) throws Exception {
        if (!this.isAggressiveInputStreamSupported() && aggressiveInputStreamOptimization) {
            throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED);
        }
        ImageReaderSpi newSpi = this.getReaderSpi();
        if (newSpi != null) {
            ImageReader reader = null;
            ImageInputStream stream = null;
            try {
                reader = newSpi.createReaderInstance();
                if (source instanceof FileResource) {
                    FileResource resource = (FileResource)source;
                    stream = new FileImageInputStreamExtImpl(resource.getFile());
                    reader.setInput(stream);
                    BufferedImage bufferedImage = reader.read(0);
                    return bufferedImage;
                }
                if ((source = ((Resource)source).getInputStream()) instanceof InputStream) {
                    InputStream inputStream = (InputStream)source;
                    stream = this.isAggressiveInputStreamSupported() ? new ImageInputStreamAdapter(inputStream) : new MemoryCacheImageInputStream(inputStream);
                    reader.setInput(stream);
                    BufferedImage bufferedImage = reader.read(0);
                    return bufferedImage;
                }
                try {
                    throw new IllegalArgumentException("Wrong input object");
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    throw e;
                }
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                    stream = null;
                }
            }
        }
        return null;
    }

    ImageReaderSpi getReaderSpi() {
        return this.spi;
    }

    @Override
    public List<String> getSupportedMimeTypes() {
        return this.supportedMimeTypes;
    }

    @Override
    public boolean isAggressiveInputStreamSupported() {
        return this.isAggressiveInputStreamSupported;
    }
}

