/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.io.codec;

import it.geosolutions.imageio.stream.output.ImageOutputStreamAdapter;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.eclipse.imagen.media.colorindexer.ColorIndexer;
import org.eclipse.imagen.media.colorindexer.Quantizer;
import org.geotools.image.ImageWorker;
import org.geotools.util.logging.Logging;
import org.geowebcache.io.codec.ImageEncoder;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeType;

public class ImageEncoderImpl
implements ImageEncoder {
    private static final Logger LOGGER = Logging.getLogger((String)ImageEncoderImpl.class.getName());
    public static final String OPERATION_NOT_SUPPORTED = "Operation not supported";
    private final boolean isAggressiveOutputStreamSupported;
    private final List<String> supportedMimeTypes;
    private ImageWriterSpi spi;
    private Map<String, String> inputParams;
    private WriteHelper helper;

    @Override
    public void encode(RenderedImage image, Object destination, boolean aggressiveOutputStreamOptimization, MimeType type, Map<String, ?> map) throws Exception {
        block15: {
            if (!this.isAggressiveOutputStreamSupported() && aggressiveOutputStreamOptimization) {
                throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED);
            }
            ImageWriterSpi newSpi = this.getWriterSpi();
            if (newSpi != null) {
                ImageWriter writer = null;
                ImageInputStream stream = null;
                try {
                    writer = newSpi.createWriterInstance();
                    if (destination instanceof OutputStream) {
                        OutputStream outputStream = (OutputStream)destination;
                        stream = this.isAggressiveOutputStreamSupported() ? new ImageOutputStreamAdapter(outputStream) : new MemoryCacheImageOutputStream(outputStream);
                        ImageWriteParam params = null;
                        RenderedImage finalImage = image;
                        if (this.helper != null) {
                            params = this.helper.prepareParams(this.inputParams, writer);
                            finalImage = this.helper.prepareImage(image, type);
                        }
                        writer.setOutput(stream);
                        writer.write(null, new IIOImage(finalImage, null, null), params);
                        break block15;
                    }
                    throw new IllegalArgumentException("Wrong output object");
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    throw e;
                }
                finally {
                    if (writer != null) {
                        writer.dispose();
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                        stream = null;
                    }
                }
            }
        }
    }

    ImageWriterSpi getWriterSpi() {
        return this.spi;
    }

    @Override
    public List<String> getSupportedMimeTypes() {
        return this.supportedMimeTypes;
    }

    @Override
    public boolean isAggressiveOutputStreamSupported() {
        return this.isAggressiveOutputStreamSupported;
    }

    public ImageEncoderImpl(boolean aggressiveOutputStreamOptimization, List<String> supportedMimeTypes, Map<String, String> inputParams) {
        this(aggressiveOutputStreamOptimization, supportedMimeTypes, inputParams, null);
    }

    public ImageEncoderImpl(boolean aggressiveOutputStreamOptimization, List<String> supportedMimeTypes, Map<String, String> inputParams, String preferredSpi) {
        this.isAggressiveOutputStreamSupported = aggressiveOutputStreamOptimization;
        this.supportedMimeTypes = new ArrayList<String>(supportedMimeTypes);
        this.inputParams = inputParams;
        Object backupSPI = null;
        for (String mimeType : supportedMimeTypes) {
            ImageWriterSpi writerSpi;
            Iterator<ImageWriter> writer = ImageIO.getImageWritersByMIMEType(mimeType);
            if (!writer.hasNext() || (writerSpi = writer.next().getOriginatingProvider()) == null) continue;
            if (preferredSpi == null) {
                this.spi = writerSpi;
                break;
            }
            if (writerSpi.getClass().getName().equals(preferredSpi)) {
                this.spi = writerSpi;
                break;
            }
            if (backupSPI != null) continue;
            backupSPI = writerSpi;
        }
        if (this.spi == null) {
            if (backupSPI == null) {
                throw new IllegalArgumentException("No ImageWriterSpi found for the selected mimetypes: " + String.valueOf(supportedMimeTypes));
            }
            LOGGER.log(Level.WARNING, "Preferred SPI not found, using the first available one: " + backupSPI.getClass().getName());
            this.spi = backupSPI;
        }
        this.helper = WriteHelper.getWriteHelperForName(supportedMimeTypes.get(0));
    }

    protected WriteHelper getHelper() {
        return this.helper;
    }

    private static RenderedImage applyPalette(RenderedImage canvas) {
        if (!(canvas.getColorModel() instanceof IndexColorModel)) {
            ImageWorker imageWorker = new ImageWorker(canvas);
            RenderedImage image = imageWorker.rescaleToBytes().forceComponentColorModel().getRenderedImage();
            ColorIndexer indexer = new Quantizer(256).subsample().buildColorIndexer(image);
            if (indexer != null) {
                image = new ImageWorker(image).colorIndex(indexer).getRenderedImage();
            }
            return image;
        }
        return canvas;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum WriteHelper {
        PNG(new String[]{"image/png", "image/png8", "image/png; mode=8bit", "image/png24", "image/png; mode=24bit", "image/png;%20mode=24bit"}){

            @Override
            public ImageWriteParam prepareParameters(ImageWriter writer, String compression, boolean compressUsed, float compressionRate) {
                ImageWorker.PNGImageWriteParam params = null;
                if ("com.sun.imageio.plugins.png.PNGImageWriter".equals(writer.getClass().getName())) {
                    params = new ImageWorker.PNGImageWriteParam();
                    params.setCompressionMode(1);
                }
                return params;
            }

            @Override
            public RenderedImage prepareImage(RenderedImage image, MimeType type) {
                boolean isPNG8 = ImageMime.png8.equals((Object)type);
                if (isPNG8) {
                    return ImageEncoderImpl.applyPalette(image);
                }
                return image;
            }
        }
        ,
        JPEG(new String[]{"image/jpeg"}){

            @Override
            protected ImageWriteParam prepareParameters(ImageWriter writer, String compression, boolean compressUsed, float compressionRate) {
                ImageWriteParam params = writer.getDefaultWriteParam();
                params.setCompressionMode(2);
                if (compressUsed) {
                    params.setCompressionType(compression);
                }
                if (compressionRate > -1.0f) {
                    params.setCompressionQuality(compressionRate);
                }
                if (params instanceof JPEGImageWriteParam) {
                    JPEGImageWriteParam jpegParams = (JPEGImageWriteParam)params;
                    jpegParams.setOptimizeHuffmanTables(true);
                    try {
                        jpegParams.setProgressiveMode(1);
                    }
                    catch (UnsupportedOperationException e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                    params = jpegParams;
                }
                return params;
            }
        }
        ,
        GIF(new String[]{"image/gif"}){

            @Override
            public RenderedImage prepareImage(RenderedImage image, MimeType type) {
                return ImageEncoderImpl.applyPalette(image);
            }
        }
        ,
        TIFF("image/tiff"),
        BMP("image/bmp");

        private final List<String> formatNames;

        private WriteHelper(String ... formatNames) {
            this.formatNames = List.of(formatNames);
        }

        public ImageWriteParam prepareParams(Map<String, String> inputParams, ImageWriter writer) {
            String compression = inputParams.get("COMPRESSION");
            boolean compressUsed = compression != null && !compression.isEmpty() && !compression.equalsIgnoreCase("null");
            String compressionRateValue = inputParams.get("COMPRESSION_RATE");
            float compressionRate = -1.0f;
            if (compressionRateValue != null) {
                try {
                    compressionRate = Float.parseFloat(compressionRateValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ImageWriteParam params = this.prepareParameters(writer, compression, compressUsed, compressionRate);
            return params;
        }

        protected ImageWriteParam prepareParameters(ImageWriter writer, String compression, boolean compressUsed, float compressionRate) {
            ImageWriteParam params = writer.getDefaultWriteParam();
            params.setCompressionMode(2);
            if (compressUsed) {
                params.setCompressionType(compression);
            }
            if (compressionRate > -1.0f) {
                params.setCompressionQuality(compressionRate);
            }
            return params;
        }

        public RenderedImage prepareImage(RenderedImage image, MimeType type) {
            return image;
        }

        private boolean isFormatNameAccepted(String formatName) {
            String format;
            boolean accepted = false;
            Iterator<String> iterator = this.formatNames.iterator();
            while (iterator.hasNext() && !(accepted = (format = iterator.next()).equalsIgnoreCase(formatName))) {
            }
            return accepted;
        }

        public static WriteHelper getWriteHelperForName(String formatName) {
            if (PNG.isFormatNameAccepted(formatName)) {
                return PNG;
            }
            if (JPEG.isFormatNameAccepted(formatName)) {
                return JPEG;
            }
            if (GIF.isFormatNameAccepted(formatName)) {
                return GIF;
            }
            if (TIFF.isFormatNameAccepted(formatName)) {
                return TIFF;
            }
            if (BMP.isFormatNameAccepted(formatName)) {
                return BMP;
            }
            return null;
        }
    }
}

