/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wms;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import org.geowebcache.service.wms.WMSTileFuser;

class BufferedImageWrapper {
    protected BufferedImage canvas;
    protected Graphics2D gfx;
    private int[] canvasSize;
    private int canvasType;
    private Color bgColor;
    private RenderingHints hints;

    public BufferedImageWrapper(int[] canvasSize, int canvasType, Color bgColor, RenderingHints hints) {
        this.canvasSize = canvasSize;
        this.canvasType = canvasType;
        this.bgColor = bgColor;
        this.hints = hints;
    }

    public void drawImage(BufferedImage tileImg, int canvasx, int canvasy) {
        this.getGraphics().drawImage((Image)tileImg, canvasx, canvasy, null);
    }

    public void disposeGraphics() {
        if (this.gfx != null) {
            this.gfx.dispose();
        }
    }

    public BufferedImage getCanvas() {
        if (this.canvas == null) {
            this.canvas = new BufferedImage(this.canvasSize[0], this.canvasSize[1], this.canvasType);
            this.gfx = (Graphics2D)this.canvas.getGraphics();
            if (this.bgColor != null) {
                this.gfx.setColor(this.bgColor);
                this.gfx.fillRect(0, 0, this.canvasSize[0], this.canvasSize[1]);
            }
            RenderingHints hintsTemp = WMSTileFuser.HintsLevel.DEFAULT.getRenderingHints();
            if (this.hints != null) {
                hintsTemp = this.hints;
            }
            this.gfx.addRenderingHints(hintsTemp);
        }
        return this.canvas;
    }

    public void updateCanvas(BufferedImage canvas) {
        this.canvas = canvas;
    }

    public Graphics2D getGraphics() {
        if (this.gfx == null) {
            this.gfx = (Graphics2D)this.getCanvas().getGraphics();
        }
        if (this.bgColor != null) {
            this.gfx.setColor(this.bgColor);
            this.gfx.fillRect(0, 0, this.canvasSize[0], this.canvasSize[1]);
        }
        return this.gfx;
    }
}

