/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.kml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.request.GreenTileException;
import org.geowebcache.filter.request.RequestFilterException;
import org.geowebcache.filter.security.SecurityDispatcher;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.MimeType;
import org.geowebcache.mime.XMLMime;
import org.geowebcache.service.ServiceException;
import org.geowebcache.storage.StorageBroker;

public class KMZHelper {
    private static Logger log = Logging.getLogger((String)KMZHelper.class.getName());

    public static long[][] filterGridLocs(StorageBroker sb, SecurityDispatcher secDisp, TileLayer tileLayer, String gridSetId, MimeType mime, long[][] linkGridLocs) throws GeoWebCacheException {
        for (long[] linkGridLock : linkGridLocs) {
            if (linkGridLock[2] <= 0L) continue;
            ConveyorTile tile = new ConveyorTile(sb, tileLayer.getName(), gridSetId, linkGridLock, mime, null, null, null);
            tile.setTileLayer(tileLayer);
            try {
                secDisp.checkSecurity(tile);
                tileLayer.applyRequestFilters(tile);
            }
            catch (SecurityException ex) {
                linkGridLock[2] = -1L;
            }
            catch (GreenTileException ex) {
            }
            catch (RequestFilterException e) {
                linkGridLock[2] = -1L;
                continue;
            }
            if (!mime.equals((Object)XMLMime.kml)) continue;
            try {
                tileLayer.getTile(tile);
            }
            catch (IOException ioe) {
                log.log(Level.SEVERE, ioe.getMessage());
                linkGridLock[2] = -1L;
            }
            catch (GeoWebCacheException gwce) {
                linkGridLock[2] = -1L;
            }
            if (tile.getStatus() == 204) {
                linkGridLock[2] = -1L;
                continue;
            }
            if (tile.getStatus() == 200) continue;
            throw new GeoWebCacheException("Unexpected response code from server " + tile.getStatus());
        }
        return linkGridLocs;
    }

    protected static byte[] createZippedKML(String namePfx, String formatExtension, byte[] overlayXml, Resource dataXml) throws ServiceException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            KMZHelper.writeZippedKML(namePfx, formatExtension, overlayXml, dataXml, out);
        }
        catch (IOException ioe) {
            throw new ServiceException("Encountered problem writing zip: " + ioe.getMessage());
        }
        return out.toByteArray();
    }

    private static void writeZippedKML(String namePfx, String formatExtension, byte[] overlay, Resource data, OutputStream out) throws IOException {
        ZipOutputStream zipos = new ZipOutputStream(out);
        ZipEntry zeOl = new ZipEntry("netlinks_" + namePfx + ".kml");
        zipos.putNextEntry(zeOl);
        zipos.write(overlay);
        if (data != null) {
            ZipEntry zeData = new ZipEntry("data_" + namePfx + "." + formatExtension);
            zipos.putNextEntry(zeData);
            WritableByteChannel outch = Channels.newChannel(zipos);
            data.transferTo(outch);
        }
        zipos.finish();
    }
}

