/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.responses;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.geoserver.config.GeoServer;
import org.geoserver.wcs.responses.CoverageResponseDelegate;
import org.geotools.util.Utilities;

public abstract class BaseCoverageResponseDelegate
implements CoverageResponseDelegate {
    private final List<String> outputFormats;
    private final CaseInsensitiveMap fileExtensions;
    private final CaseInsensitiveMap mimeTypes;
    protected final GeoServer geoserver;

    public BaseCoverageResponseDelegate(GeoServer geoserver, List<String> outputFormats, Map<String, String> fileExtensions, Map<String, String> mimeTypes) {
        Utilities.ensureNonNull((String)"outputFormats", outputFormats);
        Utilities.ensureNonNull((String)"GeoServer", (Object)geoserver);
        Utilities.ensureNonNull((String)"fileExtensions", fileExtensions);
        Utilities.ensureNonNull((String)"mimeTypes", mimeTypes);
        if (outputFormats.isEmpty()) {
            throw new IllegalArgumentException("Empty list of outputFormats provided");
        }
        if (fileExtensions.isEmpty()) {
            throw new IllegalArgumentException("Empty list of fileExtensions provided");
        }
        if (mimeTypes.isEmpty()) {
            throw new IllegalArgumentException("Empty list of mimeTypes provided");
        }
        this.mimeTypes = new CaseInsensitiveMap(new HashMap<String, String>(mimeTypes));
        this.outputFormats = new ArrayList<String>(outputFormats);
        this.fileExtensions = new CaseInsensitiveMap(fileExtensions);
        this.geoserver = geoserver;
    }

    @Override
    public boolean canProduce(String outputFormat) {
        Utilities.ensureNonNull((String)"outputFormat", (Object)outputFormat);
        return this.outputFormats.contains(outputFormat) || this.mimeTypes.values().contains(outputFormat);
    }

    @Override
    public String getMimeType(String outputFormat) {
        Utilities.ensureNonNull((String)"outputFormat", (Object)outputFormat);
        if (this.mimeTypes.containsKey((Object)outputFormat)) {
            return (String)this.mimeTypes.get((Object)outputFormat);
        }
        if (this.mimeTypes.values().contains(outputFormat)) {
            return outputFormat;
        }
        return null;
    }

    @Override
    public String getFileExtension(String outputFormat) {
        if (this.fileExtensions.containsKey((Object)outputFormat)) {
            return (String)this.fileExtensions.get((Object)outputFormat);
        }
        if (this.mimeTypes.values().contains(outputFormat)) {
            return (String)this.fileExtensions.values().iterator().next();
        }
        return null;
    }

    @Override
    public List<String> getOutputFormats() {
        return new ArrayList<String>(this.outputFormats);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public String getConformanceClass(String format) {
        return "http://www.opengis.net/spec/WCS_coverage-encoding-x" + this.getMimeType(format);
    }
}

