/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.responses;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.ServiceException;
import org.geoserver.util.IOUtils;
import org.geoserver.wcs.responses.BaseCoverageResponseDelegate;
import org.geoserver.wcs.responses.CoverageResponseDelegate;
import org.geotools.api.coverage.grid.Format;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.image.WorldImageWriter;

public class IMGCoverageResponseDelegate
extends BaseCoverageResponseDelegate
implements CoverageResponseDelegate {
    public IMGCoverageResponseDelegate(GeoServer geoserver) {
        super(geoserver, List.of("png", "jpeg", "JPEG", "PNG", "image/png", "image/jpeg"), Map.ofEntries(Map.entry("png", "png"), Map.entry("jpeg", "jpeg"), Map.entry("JPEG", "jpeg"), Map.entry("PNG", "png"), Map.entry("image/png", "png"), Map.entry("image/jpeg", "jpeg")), Map.ofEntries(Map.entry("png", "image/png"), Map.entry("jpeg", "image/jpeg"), Map.entry("PNG", "image/png"), Map.entry("JPEG", "image/jpeg"), Map.entry("image/png", "image/png"), Map.entry("image/jpeg", "image/jpeg")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(GridCoverage2D sourceCoverage, String outputFormat, Map<String, String> econdingParameters, OutputStream output) throws ServiceException, IOException {
        if (sourceCoverage == null) {
            throw new IllegalStateException("It seems prepare() has not been called or has not succeed");
        }
        WorldImageWriter writer = new WorldImageWriter((Object)output);
        Format writerParams = writer.getFormat();
        ParameterValueGroup writeParameters = writerParams.getWriteParameters();
        ParameterValue format = writeParameters.parameter("Format");
        format.setValue((Object)this.getFileExtension(outputFormat));
        try {
            writer.write((GridCoverage)sourceCoverage, new GeneralParameterValue[]{format});
            output.flush();
        }
        finally {
            IOUtils.closeQuietly((Closeable)output);
            try {
                writer.dispose();
            }
            catch (Throwable throwable) {}
            sourceCoverage.dispose(true);
        }
    }
}

