/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.utils.DateUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.impl.ProxyUtils;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.gwc.ConfigurableLockProvider;
import org.geoserver.gwc.ConfigurableQuotaStoreProvider;
import org.geoserver.gwc.FakeHttpServletRequest;
import org.geoserver.gwc.FakeHttpServletResponse;
import org.geoserver.gwc.GWCSynchEnv;
import org.geoserver.gwc.JDBCConfigurationStorage;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.config.GWCConfigPersister;
import org.geoserver.gwc.layer.CatalogConfiguration;
import org.geoserver.gwc.layer.CatalogLayerEventListener;
import org.geoserver.gwc.layer.CatalogStyleChangeListener;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.HttpErrorCodeException;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.platform.GeoServerEnvironment;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CoverageAccessLimits;
import org.geoserver.security.DataAccessLimits;
import org.geoserver.security.WMSAccessLimits;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.SecuredLayerInfo;
import org.geoserver.threadlocals.ThreadLocalsTransfer;
import org.geoserver.util.HTTPWarningAppender;
import org.geoserver.wfs.kvp.BBoxKvpParser;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.map.RenderedImageMap;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.MultiValuedFilter;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.metadata.extent.GeographicBoundingBox;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.ows.ServiceException;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheEnvironment;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.config.ConfigurationPersistenceException;
import org.geowebcache.config.TileLayerConfiguration;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.DiskQuotaMonitor;
import org.geowebcache.diskquota.jdbc.JDBCConfiguration;
import org.geowebcache.diskquota.storage.LayerQuota;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.diskquota.storage.TileSetVisitor;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.grid.GridUtil;
import org.geowebcache.grid.SRS;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.locks.MemoryLockProvider;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.seed.GWCTask;
import org.geowebcache.seed.SeedRequest;
import org.geowebcache.seed.TileBreeder;
import org.geowebcache.seed.TruncateAllRequest;
import org.geowebcache.seed.TruncateBboxRequest;
import org.geowebcache.storage.BlobStoreAggregator;
import org.geowebcache.storage.CompositeBlobStore;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileRange;
import org.geowebcache.util.ServletUtils;
import org.locationtech.jts.densify.Densifier;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class GWC
implements DisposableBean,
InitializingBean,
ApplicationContextAware {
    private static final String GLOBAL_LOCK_KEY = "global";
    public static final String WORKSPACE_PARAM = "WORKSPACE";
    private static volatile GWC INSTANCE;
    static final Logger log;
    private Map<String, Response> cachedTileEncoders = new HashMap<String, Response>();
    private final TileLayerDispatcher tld;
    private final StorageBroker storageBroker;
    private final TileBreeder tileBreeder;
    private final GWCConfigPersister gwcConfigPersister;
    private final Dispatcher owsDispatcher;
    private final GridSetBroker gridSetBroker;
    private GWCSynchEnv gwcSynchEnv;
    private DiskQuotaMonitor monitor;
    private CatalogLayerEventListener catalogLayerEventListener;
    private CatalogStyleChangeListener catalogStyleChangeListener;
    private final Catalog catalog;
    private Catalog rawCatalog;
    private ConfigurableLockProvider lockProvider;
    private JDBCConfigurationStorage jdbcConfigurationStorage;
    private FilterFactory ff = CommonFactoryFinder.getFilterFactory();
    private GeoWebCacheEnvironment gwcEnvironment;
    final GeoServerEnvironment gsEnvironment = (GeoServerEnvironment)GeoServerExtensions.bean(GeoServerEnvironment.class);
    private final Set<String> geoserverEmbeddedGridSets = new HashSet<String>();
    private BlobStoreAggregator blobStoreAggregator;
    private ExecutorService metaTilingExecutor;

    public GWC(GWCConfigPersister gwcConfigPersister, StorageBroker sb, TileLayerDispatcher tld, GridSetBroker gridSetBroker, TileBreeder tileBreeder, DiskQuotaMonitor monitor, Dispatcher owsDispatcher, Catalog catalog, Catalog rawCatalog, DefaultStorageFinder storageFinder, JDBCConfigurationStorage jdbcConfigurationStorage, BlobStoreAggregator blobStoreAggregator, GWCSynchEnv gwcSynchEnv) {
        this.gwcConfigPersister = gwcConfigPersister;
        this.tld = tld;
        this.storageBroker = sb;
        this.gridSetBroker = gridSetBroker;
        this.tileBreeder = tileBreeder;
        this.monitor = monitor;
        this.owsDispatcher = owsDispatcher;
        this.catalog = catalog;
        this.rawCatalog = rawCatalog;
        this.catalogLayerEventListener = new CatalogLayerEventListener(this, catalog);
        this.catalogStyleChangeListener = new CatalogStyleChangeListener(this, catalog);
        this.catalog.addListener((CatalogListener)this.catalogLayerEventListener);
        this.catalog.addListener((CatalogListener)this.catalogStyleChangeListener);
        this.lockProvider = new ConfigurableLockProvider();
        this.updateLockProvider(this.getConfig().getLockProviderName());
        this.jdbcConfigurationStorage = jdbcConfigurationStorage;
        this.blobStoreAggregator = blobStoreAggregator;
        this.gwcSynchEnv = gwcSynchEnv;
        this.metaTilingExecutor = this.buildMetaTilingExecutor(this.getConfig().getMetaTilingThreads());
    }

    private void updateLockProvider(String lockProviderName) {
        MemoryLockProvider delegate = null;
        if (lockProviderName == null) {
            delegate = new MemoryLockProvider();
        } else {
            Object provider = GeoWebCacheExtensions.bean((String)lockProviderName);
            if (provider == null) {
                throw new RuntimeException("Could not find lock provider " + String.valueOf(this.lockProvider) + " in the spring application context");
            }
            if (!(provider instanceof LockProvider)) {
                throw new RuntimeException("Found bean " + String.valueOf(this.lockProvider) + " in the spring application context, but it was not a LockProvider");
            }
            delegate = (LockProvider)provider;
        }
        this.lockProvider.setDelegate((LockProvider)delegate);
    }

    private ExecutorService buildMetaTilingExecutor(Integer metaTilingThreads) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("GWC MetaTiling Thread-%d").build();
        if (metaTilingThreads == null) {
            metaTilingThreads = Runtime.getRuntime().availableProcessors() * 2;
        }
        if (metaTilingThreads == 0) {
            return null;
        }
        return Executors.newFixedThreadPool(metaTilingThreads, threadFactory);
    }

    public GWCSynchEnv getGwcSynchEnv() {
        return this.gwcSynchEnv;
    }

    public static GWC get() {
        GWC.INSTANCE.gwcSynchEnv.syncEnv();
        return INSTANCE;
    }

    public static void set(GWC instance, GWCSynchEnv gwcSynchEnv) {
        if (instance != null) {
            instance.gwcSynchEnv = gwcSynchEnv;
        }
        INSTANCE = instance;
    }

    public void afterPropertiesSet() throws Exception {
        GWC.set(this, this.gwcSynchEnv);
    }

    public void destroy() throws Exception {
        Catalog catalog = this.getCatalog();
        if (this.catalogLayerEventListener != null) {
            catalog.removeListener((CatalogListener)this.catalogLayerEventListener);
        }
        if (this.catalogStyleChangeListener != null) {
            catalog.removeListener((CatalogListener)this.catalogStyleChangeListener);
        }
        if (this.metaTilingExecutor != null) {
            this.metaTilingExecutor.shutdownNow();
        }
        GWC.set(null, null);
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public GWCConfig getConfig() {
        return this.gwcConfigPersister.getConfig();
    }

    public void truncate(String layerName) {
        TileLayer layer;
        Preconditions.checkNotNull((Object)layerName, (Object)"layerName is null");
        try {
            layer = this.tld.getTileLayer(layerName);
        }
        catch (GeoWebCacheException e) {
            log.log(Level.INFO, e.getMessage(), e);
            return;
        }
        Set gridSubsets = layer.getGridSubsets();
        for (String gridSetId : gridSubsets) {
            this.deleteCacheByGridSetId(layerName, gridSetId);
        }
    }

    public void truncateByLayerAndStyle(String layerName, String styleName) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Truncate for layer/style called. Checking if style '" + styleName + "' is cached for layer '" + layerName + "'");
        }
        if (!this.isStyleCached(layerName, styleName)) {
            log.fine("Style '" + styleName + "' is not cached for layer " + layerName + "'. No need to truncate.");
            return;
        }
        log.fine("truncating '" + layerName + "' for style '" + styleName + "'");
        String gridSetId = null;
        BoundingBox bounds = null;
        String format = null;
        this.truncate(layerName, styleName, gridSetId, bounds, format);
    }

    public void truncateByLayerDefaultStyle(String layerName) {
        Preconditions.checkNotNull((Object)layerName, (Object)"layerName can't be null");
        log.fine("truncating '" + layerName + "' for default style");
        TileLayer layer = this.getTileLayerByName(layerName);
        Set gridSetIds = layer.getGridSubsets();
        List mimeTypes = layer.getMimeTypes();
        BoundingBox bounds = null;
        Map<String, String> parameters = null;
        for (String gridSetId : gridSetIds) {
            GridSubset gridSubset = layer.getGridSubset(gridSetId);
            if (gridSubset == null) {
                GridSet gridSet = this.gridSetBroker.get(gridSetId);
                gridSubset = GridSubsetFactory.createGridSubSet((GridSet)gridSet);
            }
            for (MimeType mime : mimeTypes) {
                String formatName = mime.getFormat();
                this.truncate(layer, bounds, gridSubset, formatName, parameters);
            }
        }
    }

    public void truncate(String layerName, ReferencedEnvelope bounds) throws GeoWebCacheException {
        TileLayer tileLayer = this.tld.getTileLayer(layerName);
        Set gridSubSets = tileLayer.getGridSubsets();
        for (String gridSetId : gridSubSets) {
            GridSubset layerGrid = tileLayer.getGridSubset(gridSetId);
            BoundingBox intersectingBounds = this.getIntersectingBounds(layerName, layerGrid, bounds);
            if (intersectingBounds == null) continue;
            try {
                new TruncateBboxRequest(layerName, intersectingBounds, gridSetId).doTruncate(this.storageBroker, this.tileBreeder);
            }
            catch (GeoWebCacheException | StorageException e) {
                log.log(Level.WARNING, e, () -> "Error while truncating modified bounds for layer %s gridset %s".formatted(layerName, gridSetId));
            }
        }
    }

    public TruncateAllRequest truncateAll() throws GeoWebCacheException, StorageException {
        TruncateAllRequest truncateAll = new TruncateAllRequest();
        truncateAll.doTruncate(this.storageBroker, this.tileBreeder);
        log.info("Mass Truncate Completed");
        log.info("Truncated Layers : " + truncateAll.getTrucatedLayersList());
        return truncateAll;
    }

    private BoundingBox getIntersectingBounds(String layerName, GridSubset layerGrid, ReferencedEnvelope bounds) {
        ReferencedEnvelope truncateBoundsInGridsetCrs;
        CoordinateReferenceSystem gridSetCrs;
        GridSet gridSet = layerGrid.getGridSet();
        String gridSetId = gridSet.getName();
        SRS srs = gridSet.getSrs();
        try {
            gridSetCrs = CRS.decode((String)("EPSG:" + srs.getNumber()), (boolean)true);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't decode SRS for layer '" + layerName + "': ESPG:" + srs.getNumber());
        }
        try {
            truncateBoundsInGridsetCrs = bounds.transform(gridSetCrs, true);
        }
        catch (Exception e) {
            log.warning("Can't truncate layer " + layerName + ": error transforming requested bounds to layer gridset " + gridSetId + ": " + e.getMessage());
            return null;
        }
        double minx = truncateBoundsInGridsetCrs.getMinX();
        double miny = truncateBoundsInGridsetCrs.getMinY();
        double maxx = truncateBoundsInGridsetCrs.getMaxX();
        double maxy = truncateBoundsInGridsetCrs.getMaxY();
        BoundingBox reqBounds = new BoundingBox(minx, miny, maxx, maxy);
        BoundingBox layerBounds = layerGrid.getOriginalExtent();
        if (!layerBounds.intersects(reqBounds)) {
            log.fine("Requested truncation bounds do not intersect cached layer bounds, ignoring truncate request");
            return null;
        }
        BoundingBox intersectingBounds = BoundingBox.intersection((BoundingBox)layerBounds, (BoundingBox)reqBounds);
        return intersectingBounds;
    }

    public void truncate(String layerName, String styleName, String gridSetName, BoundingBox bounds, String format) {
        List<MimeType> mimeTypes;
        Set<String> styleNames;
        Preconditions.checkNotNull((Object)layerName, (Object)"layerName can't be null");
        TileLayer layer = this.getTileLayerByName(layerName);
        if (styleName == null) {
            styleNames = this.getCachedStyles(layerName);
            if (styleNames.isEmpty()) {
                styleNames.add("");
            }
        } else {
            styleNames = Collections.singleton(styleName);
        }
        Set<String> gridSetIds = gridSetName == null ? layer.getGridSubsets() : Collections.singleton(gridSetName);
        if (format == null) {
            mimeTypes = layer.getMimeTypes();
        } else {
            try {
                mimeTypes = Collections.singletonList(MimeType.createFromFormat((String)format));
            }
            catch (MimeException e) {
                throw new RuntimeException();
            }
        }
        String defaultStyle = layer.getStyles();
        for (String gridSetId : gridSetIds) {
            GridSubset gridSubset = layer.getGridSubset(gridSetId);
            if (gridSubset == null) {
                GridSet gridSet = this.gridSetBroker.get(gridSetId);
                gridSubset = GridSubsetFactory.createGridSubSet((GridSet)gridSet);
            }
            for (String style : styleNames) {
                Map<String, String> parameters;
                if (style.isEmpty() || style.equals(defaultStyle)) {
                    log.finer("'" + style + "' is the layer's default style, not adding a parameter filter");
                    parameters = null;
                } else {
                    parameters = Collections.singletonMap("STYLES", style);
                }
                for (MimeType mime : mimeTypes) {
                    String formatName = mime.getFormat();
                    this.truncate(layer, bounds, gridSubset, formatName, parameters);
                }
            }
        }
    }

    private void truncate(TileLayer layer, BoundingBox bounds, GridSubset gridSubset, String formatName, Map<String, String> parameters) {
        GWCTask[] tasks;
        boolean threadCount = true;
        int zoomStart = gridSubset.getZoomStart();
        int zoomStop = gridSubset.getZoomStop();
        GWCTask.TYPE taskType = GWCTask.TYPE.TRUNCATE;
        SeedRequest req = new SeedRequest(layer.getName(), bounds, gridSubset.getName(), 1, zoomStart, zoomStop, formatName, taskType, parameters);
        try {
            TileRange tr = TileBreeder.createTileRange((SeedRequest)req, (TileLayer)layer);
            boolean filterUpdate = false;
            tasks = this.tileBreeder.createTasks(tr, taskType, 1, filterUpdate);
        }
        catch (GeoWebCacheException e) {
            throw new RuntimeException(e);
        }
        this.tileBreeder.dispatchTasks(tasks);
    }

    private boolean isStyleCached(String layerName, String styleName) {
        Set<String> cachedStyles = this.getCachedStyles(layerName);
        boolean styleIsCached = cachedStyles.contains(styleName);
        return styleIsCached;
    }

    private Set<String> getCachedStyles(String layerName) {
        List parameterFilters;
        TileLayer l = this.getTileLayerByName(layerName);
        HashSet<String> cachedStyles = new HashSet<String>();
        String defaultStyle = l.getStyles();
        if (defaultStyle != null) {
            cachedStyles.add(defaultStyle);
        }
        if ((parameterFilters = l.getParameterFilters()) != null) {
            for (ParameterFilter pf : parameterFilters) {
                if (!"STYLES".equalsIgnoreCase(pf.getKey())) continue;
                cachedStyles.add(pf.getDefaultValue());
                cachedStyles.addAll(pf.getLegalValues());
                break;
            }
        }
        return cachedStyles;
    }

    public synchronized boolean layerRemoved(String prefixedName) {
        try {
            return this.storageBroker.delete(prefixedName);
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    public static void tryReload() {
        GWC instance = INSTANCE;
        if (instance != null) {
            instance.reload();
        }
    }

    void reload() {
        HashSet<String> currLayerNames = new HashSet<String>(this.getTileLayerNames());
        try {
            this.tld.reInit();
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, "Unable to reinit TileLayerDispatcher", e);
            throw e;
        }
        Set<String> newLayerNames = this.getTileLayerNames();
        Sets.SetView removedExternally = Sets.difference(currLayerNames, newLayerNames);
        for (String removedLayerName : removedExternally) {
            log.info("Notifying of TileLayer '" + removedLayerName + "' removed externally");
            this.layerRemoved(removedLayerName);
        }
        try {
            DiskQuotaMonitor monitor = this.getDiskQuotaMonitor();
            monitor.reloadConfig();
            ConfigurableQuotaStoreProvider provider = (ConfigurableQuotaStoreProvider)monitor.getQuotaStoreProvider();
            provider.reloadQuotaStore();
            monitor.shutDown(1);
            monitor.startUp();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to reload the disk quoa configuration", e);
        }
    }

    public final ConveyorTile dispatch(GetMapRequest request, StringBuilder requestMistmatchTarget) {
        ConveyorTile tileReq;
        TileLayer tileLayer;
        String getPrefixedName;
        String layerName = (String)request.getRawKvp().get("LAYERS");
        if (layerName.indexOf(44) != -1) {
            requestMistmatchTarget.append("more than one layer requested");
            return null;
        }
        String string = getPrefixedName = !layerName.contains(":") ? this.getPrefixedName(layerName) : layerName;
        if (!this.tld.layerExists(getPrefixedName)) {
            requestMistmatchTarget.append("not a tile layer");
            return null;
        }
        try {
            tileLayer = this.tld.getTileLayer(getPrefixedName);
        }
        catch (GeoWebCacheException e) {
            throw new RuntimeException(e);
        }
        if (!tileLayer.isEnabled()) {
            requestMistmatchTarget.append("tile layer disabled");
            return null;
        }
        if (this.getConfig().isSecurityEnabled()) {
            String bboxstr = (String)request.getRawKvp().get("BBOX");
            String srs = (String)request.getRawKvp().get("SRS");
            ReferencedEnvelope bbox = null;
            try {
                bbox = (ReferencedEnvelope)new BBoxKvpParser().parse(bboxstr);
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid bbox for layer '" + layerName + "': " + bboxstr);
            }
            if (srs != null) {
                try {
                    bbox = new ReferencedEnvelope((Envelope)bbox, CRS.decode((String)srs));
                }
                catch (Exception e) {
                    throw new RuntimeException("Can't decode SRS for layer '" + layerName + "': " + srs);
                }
            }
            try {
                this.verifyAccessLayer(layerName, bbox);
            }
            catch (SecurityException | ServiceException e) {
                return null;
            }
        }
        if (null == (tileReq = this.prepareRequest(tileLayer, request, requestMistmatchTarget))) {
            return null;
        }
        ConveyorTile tileResp = null;
        try {
            tileResp = tileLayer.getTile(tileReq);
        }
        catch (Exception e) {
            log.log(Level.INFO, "Error dispatching tile request to GeoServer", e);
        }
        return tileResp;
    }

    private String getPrefixedName(String layerName) {
        LayerInfo info = this.catalog.getLayerByName(layerName);
        if (info == null) {
            info = this.catalog.getLayerGroupByName(layerName);
        }
        if (info != null) {
            return info.prefixedName();
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Unable to find a prefix for : " + layerName);
        }
        return layerName;
    }

    ConveyorTile prepareRequest(TileLayer tileLayer, GetMapRequest request, StringBuilder requestMistmatchTarget) {
        Map fullParameters;
        long[] tileIndex;
        GridSubset gridSubset;
        MimeType mimeType;
        if (!this.isCachingPossible(tileLayer, request, requestMistmatchTarget)) {
            return null;
        }
        try {
            mimeType = MimeType.createFromFormat((String)request.getFormat());
            List tileLayerFormats = tileLayer.getMimeTypes();
            if (!tileLayerFormats.contains(mimeType)) {
                requestMistmatchTarget.append("no tile cache for requested format");
                return null;
            }
        }
        catch (MimeException me) {
            requestMistmatchTarget.append("not a GWC supported format: ").append(me.getMessage());
            return null;
        }
        try {
            boolean axisFlip = false;
            CoordinateReferenceSystem crs = request.getCrs();
            if (CRS.getAxisOrder((CoordinateReferenceSystem)crs) == CRS.AxisOrder.NORTH_EAST) {
                axisFlip = true;
            }
            String srs = request.getSRS();
            int epsgId = Integer.parseInt(srs.substring(srs.lastIndexOf(58) + 1));
            SRS srs2 = SRS.getSRS((int)epsgId);
            List crsMatchingGridSubsets = tileLayer.getGridSubsetsForSRS(srs2);
            Envelope bbox = request.getBbox();
            BoundingBox tileBounds = axisFlip ? new BoundingBox(bbox.getMinY(), bbox.getMinX(), bbox.getMaxY(), bbox.getMaxX()) : new BoundingBox(bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY());
            if (crsMatchingGridSubsets.isEmpty()) {
                requestMistmatchTarget.append("no cache exists for requested CRS");
                return null;
            }
            long[] matchingTileIndex = new long[3];
            int reqW = request.getWidth();
            int reqH = request.getHeight();
            gridSubset = GridUtil.findBestMatchingGrid((BoundingBox)tileBounds, (List)crsMatchingGridSubsets, (Integer)reqW, (Integer)reqH, (long[])matchingTileIndex);
            if (gridSubset == null) {
                requestMistmatchTarget.append("request does not align to grid(s) ");
                for (GridSubset gs : crsMatchingGridSubsets) {
                    requestMistmatchTarget.append('\'').append(gs.getName()).append("' ");
                }
                return null;
            }
            tileIndex = matchingTileIndex;
            Map requestParameterMap = request.getRawKvp();
            fullParameters = tileLayer.getModifiableParameters(requestParameterMap, "UTF-8");
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Exception caught checking gwc dispatch preconditions", e);
            }
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            requestMistmatchTarget.append("exception occurred: ").append(rootCause.getClass().getSimpleName()).append(": ").append(e.getMessage());
            return null;
        }
        String gridSetId = gridSubset.getName();
        HttpServletRequest servletReq = null;
        HttpServletResponse servletResp = null;
        String layerName = tileLayer.getName();
        ConveyorTile tileReq = new ConveyorTile(this.storageBroker, layerName, gridSetId, tileIndex, mimeType, fullParameters, servletReq, servletResp);
        return tileReq;
    }

    boolean isCachingPossible(TileLayer layer, GetMapRequest request, StringBuilder requestMistmatchTarget) {
        boolean sameFilters;
        Map<String, ParameterFilter> filters;
        if (null != request.getRemoteOwsType() || null != request.getRemoteOwsURL()) {
            requestMistmatchTarget.append("request uses remote OWS");
            return false;
        }
        List parameterFilters = layer.getParameterFilters();
        if (null == parameterFilters || parameterFilters.isEmpty()) {
            filters = Collections.emptyMap();
        } else {
            filters = new HashMap();
            for (ParameterFilter pf : parameterFilters) {
                filters.put(pf.getKey().toUpperCase(), pf);
            }
        }
        if (request.getEnv() != null && !request.getEnv().isEmpty() && !this.filterApplies(filters, request, "ENV", requestMistmatchTarget)) {
            return false;
        }
        if (request.getFormatOptions() != null && !request.getFormatOptions().isEmpty() && !this.filterApplies(filters, request, "FORMAT_OPTIONS", requestMistmatchTarget)) {
            return false;
        }
        if (0.0 != request.getAngle() && !this.filterApplies(filters, request, "ANGLE", requestMistmatchTarget)) {
            return false;
        }
        if (null != request.getRawKvp().get("BGCOLOR") && !this.filterApplies(filters, request, "BGCOLOR", requestMistmatchTarget)) {
            return false;
        }
        if (0 != request.getBuffer() && !this.filterApplies(filters, request, "BUFFER", requestMistmatchTarget)) {
            return false;
        }
        if (null != request.getCQLFilter() && !request.getCQLFilter().isEmpty() && !this.filterApplies(filters, request, "CQL_FILTER", requestMistmatchTarget)) {
            return false;
        }
        if (request.getElevation() != null && !request.getElevation().isEmpty() && null != request.getElevation().get(0) && !this.filterApplies(filters, request, "ELEVATION", requestMistmatchTarget)) {
            return false;
        }
        if (null != request.getFeatureId() && !request.getFeatureId().isEmpty() && !this.filterApplies(filters, request, "FEATUREID", requestMistmatchTarget)) {
            return false;
        }
        if (!(null == request.getFilter() || request.getFilter().isEmpty() || (sameFilters = this.checkFilter(request.getFilter(), request.getCQLFilter(), filters)) || this.filterApplies(filters, request, "FILTER", requestMistmatchTarget))) {
            return false;
        }
        if (null != request.getSortBy() && !request.getSortBy().isEmpty() && !this.filterApplies(filters, request, "SORTBY", requestMistmatchTarget)) {
            return false;
        }
        if (null != request.getPalette() && !this.filterApplies(filters, request, "PALETTE", requestMistmatchTarget)) {
            return false;
        }
        if (null != request.getStartIndex() && !this.filterApplies(filters, request, "STARTINDEX", requestMistmatchTarget)) {
            return false;
        }
        if (null != request.getMaxFeatures() && !this.filterApplies(filters, request, "MAXFEATURES", requestMistmatchTarget)) {
            return false;
        }
        if (null != request.getTime() && !request.getTime().isEmpty() && null != request.getTime().get(0) && !this.filterApplies(filters, request, "TIME", requestMistmatchTarget)) {
            return false;
        }
        if (null != request.getViewParams() && !request.getViewParams().isEmpty() && !this.filterApplies(filters, request, "VIEWPARAMS", requestMistmatchTarget)) {
            return false;
        }
        return null == request.getFeatureVersion() || this.filterApplies(filters, request, "FEATUREVERSION", requestMistmatchTarget);
    }

    private boolean checkFilter(List filter, List cqlFilter, Map<String, ParameterFilter> filters) {
        if (!filters.containsKey("FILTER")) {
            int size;
            boolean hasCQLFilter;
            boolean hasFilter = filter != null && !filter.isEmpty();
            boolean bl = hasCQLFilter = cqlFilter != null && !cqlFilter.isEmpty();
            if (hasCQLFilter && hasFilter && (size = filter.size()) == cqlFilter.size()) {
                boolean equals = true;
                for (int i = 0; i < size; ++i) {
                    equals &= filter.get(i).equals(cqlFilter.get(i));
                }
                return equals;
            }
        }
        return false;
    }

    private boolean filterApplies(Map<String, ParameterFilter> filters, GetMapRequest request, String key, StringBuilder requestMistmatchTarget) {
        ParameterFilter parameterFilter = filters.get(key);
        if (parameterFilter == null) {
            requestMistmatchTarget.append("no parameter filter exists for ").append(key);
            return false;
        }
        String parameter = (String)request.getRawKvp().get(key);
        boolean applies = parameterFilter.applies(parameter);
        if (!applies) {
            requestMistmatchTarget.append(key).append(" does not apply to parameter filter of the same name");
        }
        return applies;
    }

    public TileLayer getTileLayerByName(String layerName) throws IllegalArgumentException {
        TileLayer tileLayer;
        try {
            tileLayer = this.tld.getTileLayer(layerName);
        }
        catch (GeoWebCacheException e) {
            throw new IllegalArgumentException(e.getMessage(), Throwables.getRootCause((Throwable)e));
        }
        return tileLayer;
    }

    public Set<String> getTileLayerNames() {
        return this.tld.getLayerNames();
    }

    public Iterable<TileLayer> getTileLayers() {
        return this.tld.getLayerList();
    }

    public Iterable<? extends TileLayer> getTileLayersByNamespacePrefix(String nsPrefix) {
        if (nsPrefix == null) {
            return this.getTileLayers();
        }
        Catalog catalog = this.getCatalog();
        NamespaceInfo namespaceFilter = catalog.getNamespaceByPrefix(nsPrefix);
        if (namespaceFilter == null) {
            Iterable<TileLayer> tileLayers = this.getTileLayers();
            return tileLayers;
        }
        Iterable<GeoServerTileLayer> geoServerTileLayers = this.getGeoServerTileLayers();
        return Iterables.filter(geoServerTileLayers, tileLayer -> {
            NamespaceInfo layerNamespace;
            String layerName = tileLayer.getName();
            if (-1 == layerName.indexOf(58)) {
                return false;
            }
            LayerInfo layerInfo = catalog.getLayerByName(layerName);
            return layerInfo != null && namespaceFilter.equals((Object)(layerNamespace = layerInfo.getResource().getNamespace()));
        });
    }

    public Set<String> getLayerNamesForGridSets(Set<String> gridSetIds) {
        TreeSet<String> layerNames = new TreeSet<String>();
        for (TileLayer layer : this.getTileLayers()) {
            Set layerGrids = layer.getGridSubsets();
            if (Sets.intersection(gridSetIds, (Set)layerGrids).isEmpty()) continue;
            layerNames.add(layer.getName());
        }
        return layerNames;
    }

    public boolean isDiskQuotaAvailable() {
        DiskQuotaMonitor diskQuotaMonitor = this.getDiskQuotaMonitor();
        return diskQuotaMonitor.isEnabled();
    }

    public boolean isDiskQuotaEnabled() {
        DiskQuotaMonitor diskQuotaMonitor = this.getDiskQuotaMonitor();
        return diskQuotaMonitor.isEnabled() && diskQuotaMonitor.getConfig().isEnabled() != false;
    }

    public DiskQuotaConfig getDiskQuotaConfig() {
        if (!this.isDiskQuotaAvailable()) {
            return null;
        }
        DiskQuotaMonitor monitor = this.getDiskQuotaMonitor();
        return monitor.getConfig();
    }

    private DiskQuotaMonitor getDiskQuotaMonitor() {
        return this.monitor;
    }

    public void saveConfig(GWCConfig gwcConfig) throws IOException {
        this.gwcConfigPersister.save(gwcConfig);
        this.updateLockProvider(gwcConfig.getLockProviderName());
        ExecutorService current = this.metaTilingExecutor;
        this.metaTilingExecutor = this.buildMetaTilingExecutor(gwcConfig.getMetaTilingThreads());
        if (current != null) {
            current.shutdown();
        }
    }

    public void saveDiskQuotaConfig(DiskQuotaConfig config, JDBCConfiguration jdbcConfig) throws ConfigurationException, IOException, InterruptedException {
        Preconditions.checkArgument((boolean)this.isDiskQuotaAvailable(), (Object)"DiskQuota is not enabled");
        DiskQuotaMonitor monitor = this.getDiskQuotaMonitor();
        monitor.saveConfig(config);
        this.jdbcConfigurationStorage.saveDiskQuotaConfig(config, jdbcConfig);
        ConfigurableQuotaStoreProvider provider = (ConfigurableQuotaStoreProvider)monitor.getQuotaStoreProvider();
        provider.reloadQuotaStore();
        monitor.shutDown(1);
        monitor.startUp();
    }

    public Quota getGlobalQuota() {
        if (!this.isDiskQuotaAvailable()) {
            return null;
        }
        return this.getDiskQuotaConfig().getGlobalQuota();
    }

    public Quota getGlobalUsedQuota() {
        if (!this.isDiskQuotaAvailable()) {
            return null;
        }
        try {
            return this.monitor.getGloballyUsedQuota();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Quota getUsedQuotaByGridSet(String gridSetName) {
        Preconditions.checkNotNull((Object)gridSetName, (Object)"GridSet name is null");
        if (!this.isDiskQuotaAvailable()) {
            return null;
        }
        Quota quota = new Quota();
        TileSetVisitor visitor = (tileSet, store) -> {
            if (!gridSetName.equals(tileSet.getGridsetId())) {
                return;
            }
            String tileSetId = tileSet.getId();
            try {
                Quota used = store.getUsedQuotaByTileSetId(tileSetId);
                quota.add(used);
            }
            catch (InterruptedException e) {
                log.fine(e.getMessage());
            }
        };
        this.monitor.getQuotaStore().accept(visitor);
        return quota;
    }

    public Quota getQuotaLimit(String layerName) {
        if (!this.isDiskQuotaAvailable()) {
            return null;
        }
        DiskQuotaConfig disQuotaConfig = this.getDiskQuotaConfig();
        List layerQuotas = disQuotaConfig.getLayerQuotas();
        if (layerQuotas == null) {
            return null;
        }
        for (LayerQuota lq : layerQuotas) {
            if (!layerName.equals(lq.getLayer())) continue;
            return new Quota(lq.getQuota());
        }
        return null;
    }

    public Quota getUsedQuota(String layerName) {
        if (!this.isDiskQuotaAvailable()) {
            return null;
        }
        try {
            Quota usedQuotaByLayerName = this.monitor.getUsedQuotaByLayerName(layerName);
            return usedQuotaByLayerName;
        }
        catch (InterruptedException e) {
            log.log(Level.WARNING, "", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource dispatchOwsRequest(Map<String, String> params, Cookie[] cookies) throws Exception {
        String workspace = params.remove(WORKSPACE_PARAM);
        FakeHttpServletRequest req = new FakeHttpServletRequest(params, cookies, workspace);
        FakeHttpServletResponse resp = new FakeHttpServletResponse();
        Request request = (Request)Dispatcher.REQUEST.get();
        Dispatcher.REQUEST.remove();
        ThreadLocalsTransfer tx = new ThreadLocalsTransfer();
        try {
            this.owsDispatcher.handleRequest((HttpServletRequest)req, (HttpServletResponse)resp);
        }
        finally {
            tx.apply();
            if (request != null) {
                Dispatcher.REQUEST.set(request);
            } else {
                Dispatcher.REQUEST.remove();
            }
        }
        return new ByteArrayResource(resp.getBytes());
    }

    public void proxyOwsRequest(ConveyorTile tile) throws Exception {
        HttpServletRequest actualRequest = tile.servletReq;
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        Map params = actualRequest.getParameterMap();
        boolean hasService = false;
        for (Map.Entry param : params.entrySet()) {
            String key = (String)param.getKey();
            String value = ((String[])param.getValue())[0];
            parameterMap.put(key, value);
            if (!"service".equalsIgnoreCase(key) || value != null && !value.isEmpty() && "WMS".equalsIgnoreCase(value)) continue;
            throw new GeoWebCacheException("Failed to cascade request, service should be WMS but it was: '" + value + "'");
        }
        if (!hasService) {
            parameterMap.put("service", "WMS");
        }
        Cookie[] cookies = actualRequest.getCookies();
        FakeHttpServletRequest request = new FakeHttpServletRequest(parameterMap, cookies);
        this.owsDispatcher.handleRequest((HttpServletRequest)request, tile.servletResp);
    }

    public GridSetBroker getGridSetBroker() {
        return this.gridSetBroker;
    }

    public LayerInfo getLayerInfoById(String layerId) {
        return this.getCatalog().getLayer(layerId);
    }

    public LayerInfo getLayerInfoByName(String layerName) {
        return this.getCatalog().getLayerByName(layerName);
    }

    public LayerGroupInfo getLayerGroupByName(String layerName) {
        return this.getCatalog().getLayerGroupByName(layerName);
    }

    public LayerGroupInfo getLayerGroupById(String id) {
        return this.getCatalog().getLayerGroup(id);
    }

    public void add(GeoServerTileLayer tileLayer) {
        this.tld.addLayer((TileLayer)tileLayer);
    }

    public void layerAdded(String layerName) {
        if (this.isDiskQuotaAvailable()) {
            try {
                this.monitor.getQuotaStore().createLayer(layerName);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void layerRenamed(String oldLayerName, String newLayerName) {
        try {
            log.info("Renaming GWC TileLayer '" + oldLayerName + "' as '" + newLayerName + "'");
            this.storageBroker.rename(oldLayerName, newLayerName);
        }
        catch (StorageException e) {
            log.log(Level.WARNING, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public boolean isServiceEnabled(org.geowebcache.service.Service service) {
        return this.getConfig().isEnabled(service.getPathName());
    }

    public boolean tileLayerExists(String layerName) {
        return this.tld.layerExists(layerName);
    }

    public Set<String> getTileLayersByFeatureType(String namespaceURI, String typeName) {
        NamespaceInfo namespace = namespaceURI == null || "".equals(namespaceURI) ? this.getCatalog().getDefaultNamespace() : this.getCatalog().getNamespaceByURI(namespaceURI);
        FeatureTypeInfo typeInfo = this.getCatalog().getFeatureTypeByName(namespace, typeName);
        List layers = this.getCatalog().getLayers((ResourceInfo)typeInfo);
        HashSet<String> affectedLayers = new HashSet<String>();
        for (Object layer : layers) {
            String tileLayerName = GWC.tileLayerName((LayerInfo)layer);
            if (!this.tileLayerExists(tileLayerName)) continue;
            affectedLayers.add(tileLayerName);
        }
        ArrayList<Object> filters = new ArrayList<Object>();
        for (LayerInfo layer : layers) {
            filters.add(this.ff.equal((Expression)this.ff.property("layers.id"), (Expression)this.ff.literal((Object)layer.getId()), true, MultiValuedFilter.MatchAction.ANY));
            filters.add(this.ff.equal((Expression)this.ff.property("rootLayer.id"), (Expression)this.ff.literal((Object)layer.getId())));
        }
        Or groupFilter = this.ff.or(filters);
        ArrayList<LayerGroupInfo> groups = new ArrayList<LayerGroupInfo>();
        try (CloseableIterator it = this.getCatalog().list(LayerGroupInfo.class, (Filter)groupFilter);){
            while (it.hasNext()) {
                LayerGroupInfo lg = (LayerGroupInfo)it.next();
                groups.add(lg);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to load groups associated to feature type " + typeName, e);
        }
        this.loadGroupParents(groups);
        for (LayerGroupInfo lgi : groups) {
            String tileLayerName = GWC.tileLayerName(lgi);
            if (!this.tileLayerExists(tileLayerName)) continue;
            affectedLayers.add(tileLayerName);
        }
        return affectedLayers;
    }

    public synchronized void addGridSet(GridSet gridSet) throws IllegalArgumentException, IOException {
        Preconditions.checkNotNull((Object)gridSet);
        this.tld.addGridSet(gridSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void modifyGridSet(String oldGridSetName, GridSet newGridSet) throws IllegalArgumentException, IOException, GeoWebCacheException {
        Preconditions.checkNotNull((Object)oldGridSetName);
        Preconditions.checkNotNull((Object)newGridSet);
        GridSet oldGridSet = this.gridSetBroker.get(oldGridSetName);
        if (null == oldGridSet) {
            throw new IllegalArgumentException("GridSet " + oldGridSetName + " does not exist");
        }
        boolean needsTruncate = oldGridSet.shouldTruncateIfChanged(newGridSet);
        if (needsTruncate) {
            log.warning("### Changes in gridset force truncation of affected Tile layers");
            log.info("### Old gridset: " + String.valueOf(oldGridSet));
            log.info("### New gridset: " + String.valueOf(newGridSet));
        }
        HashMap<TileLayer, GridSubset> affectedLayers = new HashMap<TileLayer, GridSubset>();
        LockProvider.Lock lock = null;
        try {
            lock = this.lockProvider.getLock(GLOBAL_LOCK_KEY);
            for (TileLayer layer : this.getTileLayers()) {
                GridSubset gridSubet = layer.getGridSubset(oldGridSetName);
                if (null == gridSubet) continue;
                affectedLayers.put(layer, gridSubet);
                layer.removeGridSubset(oldGridSetName);
                if (!needsTruncate) continue;
                this.deleteCacheByGridSetId(layer.getName(), oldGridSetName);
            }
            this.getGridSetBroker().remove(oldGridSetName);
            this.getGridSetBroker().put(newGridSet);
            boolean sameSRS = oldGridSet.getSrs().equals((Object)newGridSet.getSrs());
            int maxZoomLevel = newGridSet.getNumLevels() - 1;
            HashSet<TileLayerConfiguration> saveConfigurations = new HashSet<TileLayerConfiguration>();
            for (Map.Entry entry : affectedLayers.entrySet()) {
                TileLayer layer = (TileLayer)entry.getKey();
                GridSubset gsubset = (GridSubset)entry.getValue();
                BoundingBox gridSetExtent = gsubset.getOriginalExtent();
                if (null != gridSetExtent && sameSRS) {
                    gridSetExtent = newGridSet.getOriginalExtent().intersection(gridSetExtent);
                }
                int zoomStart = gsubset.getZoomStart();
                int zoomStop = gsubset.getZoomStop();
                if (zoomStart > maxZoomLevel) {
                    zoomStart = maxZoomLevel;
                }
                if (zoomStop > maxZoomLevel || zoomStop < zoomStart) {
                    zoomStop = maxZoomLevel;
                }
                GridSubset newGridSubset = GridSubsetFactory.createGridSubSet((GridSet)newGridSet, (BoundingBox)gridSetExtent, (Integer)zoomStart, (Integer)zoomStop);
                layer.removeGridSubset(oldGridSetName);
                layer.addGridSubset(newGridSubset);
                TileLayerConfiguration config = this.tld.getConfiguration(layer);
                config.modifyLayer(layer);
                saveConfigurations.add(config);
            }
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
    }

    private BlobStoreAggregator getBlobStoreAggregator() {
        return this.blobStoreAggregator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getResponseEncoder(MimeType responseFormat, RenderedImageMap metaTileMap) {
        String format = responseFormat.getFormat();
        String mimeType = responseFormat.getMimeType();
        Response response = this.cachedTileEncoders.get(format);
        if (response == null) {
            GetMapRequest getMap = new GetMapRequest();
            getMap.setFormat(mimeType);
            Object[] parameters = new Object[]{getMap};
            Service service = (Service)GeoServerExtensions.bean((String)"wms-1_1_1-ServiceDescriptor");
            if (service == null) {
                throw new IllegalStateException("Didn't find service descriptor 'wms-1_1_1-ServiceDescriptor'");
            }
            Operation operation = new Operation("GetMap", service, null, parameters);
            List extensions = GeoServerExtensions.extensions(Response.class);
            Class<?> webMapClass = metaTileMap.getClass();
            for (Response r : extensions) {
                if (!r.getBinding().isAssignableFrom(webMapClass) || !r.canHandle(operation)) continue;
                Map<String, Response> map = this.cachedTileEncoders;
                synchronized (map) {
                    this.cachedTileEncoders.put(mimeType, r);
                    response = r;
                    break;
                }
            }
            if (response == null) {
                throw new IllegalStateException("Didn't find a " + Response.class.getName() + " to handle " + mimeType);
            }
        }
        return response;
    }

    public boolean isQueryable(GeoServerTileLayer geoServerTileLayer) {
        WMS wmsMediator = WMS.get();
        PublishedInfo published = geoServerTileLayer.getPublishedInfo();
        if (published instanceof LayerInfo) {
            LayerInfo info = (LayerInfo)published;
            return wmsMediator.isQueryable(info);
        }
        return wmsMediator.isQueryable((LayerGroupInfo)published);
    }

    public Iterable<GeoServerTileLayer> getGeoServerTileLayers() {
        Iterable<TileLayer> tileLayers = this.getTileLayers();
        Iterable filtered = Iterables.filter(tileLayers, GeoServerTileLayer.class);
        return filtered;
    }

    public void save(TileLayer layer) {
        Preconditions.checkNotNull((Object)layer);
        log.info("Saving GeoSeverTileLayer " + layer.getName());
        this.tld.modify(layer);
    }

    public void rename(String oldTileLayerName, String newTileLayerName) {
        Preconditions.checkNotNull((Object)oldTileLayerName);
        Preconditions.checkNotNull((Object)newTileLayerName);
        log.info("Renaming GeoSeverTileLayer " + oldTileLayerName + " to " + newTileLayerName);
        this.tld.rename(oldTileLayerName, newTileLayerName);
    }

    public List<GeoServerTileLayer> getTileLayersForStyle(String styleName) {
        Iterable<GeoServerTileLayer> tileLayers = this.getGeoServerTileLayers();
        ArrayList<GeoServerTileLayer> affected = new ArrayList<GeoServerTileLayer>();
        for (GeoServerTileLayer tl : tileLayers) {
            try {
                GeoServerTileLayerInfo info = tl.getInfo();
                String defaultStyle = tl.getStyles();
                ImmutableSet<String> cachedStyles = info.cachedStyles();
                if (!styleName.equals(defaultStyle) && !cachedStyles.contains(styleName)) continue;
                affected.add(tl);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to retrieve style info for layer" + tl.getName(), e);
            }
        }
        return affected;
    }

    public Iterable<LayerInfo> getLayerInfosFor(StyleInfo style) {
        return this.getLayerInfosFor(style, true);
    }

    private Iterable<LayerInfo> getLayerInfosFor(StyleInfo style, boolean includeSecondaryStyles) {
        ArrayList<LayerInfo> result = new ArrayList<LayerInfo>();
        PropertyIsEqualTo styleFilter = this.ff.equal((Expression)this.ff.property("defaultStyle.id"), (Expression)this.ff.literal((Object)style.getId()), true);
        if (includeSecondaryStyles) {
            styleFilter = this.ff.or((Filter)styleFilter, (Filter)this.ff.equal((Expression)this.ff.property("styles.id"), (Expression)this.ff.literal((Object)style.getId()), true, MultiValuedFilter.MatchAction.ANY));
        }
        try (CloseableIterator it = this.getCatalog().list(LayerInfo.class, (Filter)styleFilter);){
            while (it.hasNext()) {
                result.add((LayerInfo)it.next());
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to layers associated to style " + style.prefixedName(), e);
        }
        return result;
    }

    public Iterable<LayerGroupInfo> getLayerGroupsFor(StyleInfo style) {
        ArrayList<LayerGroupInfo> layerGroups = new ArrayList<LayerGroupInfo>();
        Iterable<LayerInfo> layers = this.getLayerInfosFor(style);
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(this.ff.equal((Expression)this.ff.property("styles.id"), (Expression)this.ff.literal((Object)style.getId()), true, MultiValuedFilter.MatchAction.ANY));
        filters.add(this.ff.equal((Expression)this.ff.property("rootLayerStyle.id"), (Expression)this.ff.literal((Object)style.getId())));
        for (LayerInfo layer : layers) {
            filters.add(this.ff.equal((Expression)this.ff.property("layers.id"), (Expression)this.ff.literal((Object)layer.getId()), true, MultiValuedFilter.MatchAction.ANY));
            filters.add(this.ff.equal((Expression)this.ff.property("rootLayer.id"), (Expression)this.ff.literal((Object)layer.getId())));
        }
        Or groupFilter = this.ff.or(filters);
        try (CloseableIterator it = this.getCatalog().list(LayerGroupInfo.class, (Filter)groupFilter);){
            while (it.hasNext()) {
                LayerGroupInfo lg = (LayerGroupInfo)it.next();
                if (!this.isLayerGroupFor(lg, style)) continue;
                layerGroups.add(lg);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to load groups associated to style " + style.prefixedName(), e);
        }
        this.loadGroupParents(layerGroups);
        return layerGroups;
    }

    private void loadGroupParents(List<LayerGroupInfo> layerGroups) {
        boolean foundNewParents = true;
        ArrayList<LayerGroupInfo> newGroups = new ArrayList<LayerGroupInfo>(layerGroups);
        while (foundNewParents && !newGroups.isEmpty()) {
            ArrayList<PropertyIsEqualTo> parentFilters = new ArrayList<PropertyIsEqualTo>();
            for (LayerGroupInfo lg : newGroups) {
                parentFilters.add(this.ff.equal((Expression)this.ff.property("layers.id"), (Expression)this.ff.literal((Object)lg.getId()), true, MultiValuedFilter.MatchAction.ANY));
            }
            Or parentFilter = this.ff.or(parentFilters);
            newGroups.clear();
            foundNewParents = false;
            try {
                CloseableIterator it = this.getCatalog().list(LayerGroupInfo.class, (Filter)parentFilter);
                try {
                    while (it.hasNext()) {
                        LayerGroupInfo lg = (LayerGroupInfo)it.next();
                        if (layerGroups.contains(lg)) continue;
                        newGroups.add(lg);
                        layerGroups.add(lg);
                        foundNewParents = true;
                    }
                }
                finally {
                    if (it == null) continue;
                    it.close();
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to recursively load parents group parents ");
            }
        }
    }

    private boolean isLayerGroupFor(LayerGroupInfo lg, StyleInfo style) {
        if (style.equals(lg.getRootLayerStyle()) || lg.getRootLayerStyle() == null && lg.getRootLayer() != null && style.equals(lg.getRootLayer().getDefaultStyle())) {
            return true;
        }
        int styleCount = lg.getStyles().size();
        int layerCount = lg.getLayers().size();
        int count = Math.max(styleCount, layerCount);
        for (int i = 0; i < count; ++i) {
            PublishedInfo pi;
            StyleInfo si = i < styleCount ? (StyleInfo)lg.getStyles().get(i) : null;
            PublishedInfo publishedInfo = pi = i < layerCount ? (PublishedInfo)lg.getLayers().get(i) : null;
            if (!(pi instanceof LayerInfo)) continue;
            LayerInfo li = (LayerInfo)pi;
            if (style.equals(si)) {
                return true;
            }
            if (!style.equals(li.getDefaultStyle())) continue;
            return true;
        }
        return false;
    }

    public ReferencedEnvelope getAreaOfValidity(CoordinateReferenceSystem coordSys) {
        Geometry aovGeom = GWC.getAreaOfValidityAsGeometry(coordSys, this.gridSetBroker);
        if (aovGeom == null) {
            return null;
        }
        Envelope envelope = aovGeom.getEnvelopeInternal();
        double x1 = envelope.getMinX();
        double x2 = envelope.getMaxX();
        double y1 = envelope.getMinY();
        double y2 = envelope.getMaxY();
        ReferencedEnvelope aov = new ReferencedEnvelope(coordSys);
        aov.init(x1, x2, y1, y2);
        return aov;
    }

    public static Geometry getAreaOfValidityAsGeometry(CoordinateReferenceSystem targetCrs, GridSetBroker gridSetBroker) {
        Polygon aovGeom;
        String[] variants = new String[]{"EPSG:900913", "EPSG:3857", "EPSG:3785"};
        boolean is900913Compatible = false;
        for (String variantCode : variants) {
            CoordinateReferenceSystem variant = GWC.variant(variantCode);
            boolean bl = is900913Compatible = variant != null && CRS.equalsIgnoreMetadata((Object)targetCrs, (Object)variant);
            if (is900913Compatible) break;
        }
        if (is900913Compatible) {
            BoundingBox prescribedBounds = gridSetBroker.getWorldEpsg3857().getBounds();
            return JTS.toGeometry((Envelope)new Envelope(prescribedBounds.getMinX(), prescribedBounds.getMaxX(), prescribedBounds.getMinY(), prescribedBounds.getMaxY()));
        }
        Bounds envelope = CRS.getEnvelope((CoordinateReferenceSystem)targetCrs);
        if (envelope == null) {
            return null;
        }
        double tolerance = 1.0E-6;
        if (envelope.getSpan(0) < 1.0E-6 || envelope.getSpan(1) < 1.0E-6) {
            GeographicBoundingBox latLonBBox = CRS.getGeographicBoundingBox((CoordinateReferenceSystem)targetCrs);
            ReferencedEnvelope bbox = new ReferencedEnvelope((Bounds)new GeneralBounds(latLonBBox));
            Polygon geometry = JTS.toGeometry((ReferencedEnvelope)bbox);
            double distanceTolerance = Math.max(bbox.getSpan(0), bbox.getSpan(1)) / 200000.0;
            Geometry densifiedGeom = Densifier.densify((Geometry)geometry, (double)distanceTolerance);
            try {
                CoordinateReferenceSystem sourceCRS = bbox.getCoordinateReferenceSystem();
                MathTransform mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCrs);
                aovGeom = JTS.transform((Geometry)densifiedGeom, (MathTransform)mathTransform);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            aovGeom = JTS.toGeometry((Envelope)new Envelope(envelope.getMinimum(0), envelope.getMaximum(0), envelope.getMinimum(1), envelope.getMaximum(1)));
        }
        aovGeom.setUserData((Object)targetCrs);
        return aovGeom;
    }

    private static CoordinateReferenceSystem variant(String code) {
        CoordinateReferenceSystem variant;
        try {
            variant = CRS.decode((String)code);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.getMessage(), e);
            return null;
        }
        return variant;
    }

    public void addEmbeddedGridSet(String gridSetId) {
        this.geoserverEmbeddedGridSets.add(gridSetId);
    }

    public boolean isInternalGridSet(String gridSetId) {
        return this.gridSetBroker.getEmbeddedNames().contains(gridSetId) || this.geoserverEmbeddedGridSets.contains(gridSetId);
    }

    public void deleteCacheByGridSetId(String layerName, String gridSetId) {
        try {
            this.storageBroker.deleteByGridSetId(layerName, gridSetId);
        }
        catch (StorageException e) {
            Throwable throwable = Throwables.getRootCause((Throwable)e);
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    public void removeTileLayers(List<String> tileLayerNames) {
        Preconditions.checkNotNull(tileLayerNames);
        for (String tileLayerName : tileLayerNames) {
            try {
                this.tld.removeLayer(tileLayerName);
            }
            catch (IllegalArgumentException e) {
                log.log(Level.WARNING, "Error saving GWC Configuration " + this.tld.getConfiguration(tileLayerName).getIdentifier(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeGridSets(Set<String> gridsetIds) throws IOException, GeoWebCacheException {
        Preconditions.checkNotNull(gridsetIds);
        Set<String> affectedLayers = this.getLayerNamesForGridSets(gridsetIds);
        for (String layerName : affectedLayers) {
            TileLayer tileLayer = this.getTileLayerByName(layerName);
            LockProvider.Lock lock = null;
            try {
                lock = this.lockProvider.getLock("gwc_lock_layer_" + layerName);
                for (String gridSetId : gridsetIds) {
                    if (!tileLayer.getGridSubsets().contains(gridSetId)) continue;
                    tileLayer.removeGridSubset(gridSetId);
                    this.deleteCacheByGridSetId(layerName, gridSetId);
                }
                if (tileLayer.getGridSubsets().isEmpty()) {
                    tileLayer.setEnabled(false);
                }
                try {
                    this.tld.modify(tileLayer);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            finally {
                if (lock == null) continue;
                lock.release();
            }
        }
        for (String gridSetId : gridsetIds) {
            this.gridSetBroker.remove(gridSetId);
        }
    }

    public void autoConfigureLayers(List<String> catalogLayerNames, GWCConfig saneConfig) {
        Preconditions.checkArgument((boolean)saneConfig.isSane());
        Catalog catalog = this.getCatalog();
        for (String name : catalogLayerNames) {
            Preconditions.checkArgument((!this.tileLayerExists(name) ? 1 : 0) != 0, (String)"Can't auto configure Layer, a tile layer named '%s' already exists.", (Object)name);
            GeoServerTileLayer tileLayer = null;
            LayerInfo layer = catalog.getLayerByName(name);
            if (layer != null) {
                tileLayer = new GeoServerTileLayer((PublishedInfo)layer, saneConfig, this.gridSetBroker);
            } else {
                LayerGroupInfo layerGroup = catalog.getLayerGroupByName(name);
                if (layerGroup != null) {
                    tileLayer = new GeoServerTileLayer((PublishedInfo)layerGroup, saneConfig, this.gridSetBroker);
                }
            }
            if (tileLayer != null) {
                this.add(tileLayer);
                continue;
            }
            log.warning("Requested layer " + name + " does not exist. Won't create TileLayer");
        }
    }

    public boolean hasTileLayer(CatalogInfo source) {
        String tileLayerName;
        if (source instanceof ResourceInfo) {
            ResourceInfo info2 = (ResourceInfo)source;
            LayerInfo layerInfo = this.getCatalog().getLayerByName(info2.prefixedName());
            if (layerInfo == null) {
                return false;
            }
            tileLayerName = GWC.tileLayerName(layerInfo);
        } else if (source instanceof LayerInfo) {
            LayerInfo info1 = (LayerInfo)source;
            tileLayerName = GWC.tileLayerName(info1);
        } else if (source instanceof LayerGroupInfo) {
            LayerGroupInfo info = (LayerGroupInfo)source;
            tileLayerName = GWC.tileLayerName(info);
        } else {
            return false;
        }
        return this.tld.layerExists(tileLayerName);
    }

    public GeoServerTileLayer getTileLayer(CatalogInfo source) {
        TileLayer tileLayer;
        String name;
        if (source instanceof ResourceInfo) {
            ResourceInfo info2 = (ResourceInfo)source;
            name = info2.prefixedName();
        } else if (source instanceof LayerInfo) {
            LayerInfo info1 = (LayerInfo)source;
            name = GWC.tileLayerName(info1);
        } else if (source instanceof LayerGroupInfo) {
            LayerGroupInfo info = (LayerGroupInfo)source;
            name = GWC.tileLayerName(info);
        } else {
            return null;
        }
        try {
            tileLayer = this.tld.getTileLayer(name);
        }
        catch (GeoWebCacheException notFound) {
            return null;
        }
        if (tileLayer instanceof GeoServerTileLayer) {
            GeoServerTileLayer layer = (GeoServerTileLayer)tileLayer;
            return layer;
        }
        return null;
    }

    public void verifyAccessLayer(String layerName, ReferencedEnvelope boundingBox) throws ServiceException, SecurityException {
        List layerInfos = null;
        LayerInfo li = this.getCatalog().getLayerByName(layerName);
        if (li != null) {
            layerInfos = Arrays.asList(li);
        } else {
            LayerGroupInfo rawGroup;
            LayerGroupInfo group = this.getCatalog().getLayerGroupByName(layerName);
            if (group != null && (rawGroup = group.getWorkspace() != null ? this.rawCatalog.getLayerGroupByName(group.getWorkspace(), group.getName()) : this.rawCatalog.getLayerGroupByName(group.getName())).layers().size() == group.layers().size()) {
                layerInfos = group.layers();
            }
        }
        if (layerInfos == null || layerInfos.isEmpty()) {
            throw new ServiceException("Could not find layer " + layerName, "LayerNotDefined");
        }
        if (boundingBox != null) {
            for (LayerInfo layerInfo : layerInfos) {
                Envelope box;
                CoverageAccessLimits accessLimits;
                Envelope box2;
                SecuredLayerInfo securedLayerInfo;
                WrapperPolicy policy;
                AccessLimits limits;
                if (layerInfo instanceof Proxy) {
                    layerInfo = (LayerInfo)ProxyUtils.unwrap((Object)layerInfo, Proxy.getInvocationHandler(layerInfo).getClass());
                }
                if (!(layerInfo instanceof SecuredLayerInfo) || !((limits = (policy = (securedLayerInfo = (SecuredLayerInfo)layerInfo).getWrapperPolicy()).getLimits()) instanceof DataAccessLimits)) continue;
                DataAccessLimits accessLimits1 = (DataAccessLimits)limits;
                CoordinateReferenceSystem dataCrs = layerInfo.getResource().getCRS();
                if (boundingBox.getCoordinateReferenceSystem() != null && !CRS.equalsIgnoreMetadata((Object)dataCrs, (Object)boundingBox.getCoordinateReferenceSystem())) {
                    try {
                        boundingBox = boundingBox.transform(dataCrs, true);
                    }
                    catch (Exception e) {
                        boundingBox = null;
                    }
                }
                ReferencedEnvelope limitBox = new ReferencedEnvelope((Envelope)ReferencedEnvelope.EVERYTHING, dataCrs);
                Filter filter = accessLimits1.getReadFilter();
                if (filter != null && (box2 = (Envelope)filter.accept((FilterVisitor)ExtractBoundsFilterVisitor.BOUNDS_VISITOR, null)) != null) {
                    limitBox = new ReferencedEnvelope(limitBox.intersection(box2), dataCrs);
                }
                if (limits instanceof CoverageAccessLimits && (accessLimits = (CoverageAccessLimits)limits).getRasterFilter() != null && (box = accessLimits.getRasterFilter().getEnvelopeInternal()) != null) {
                    limitBox = new ReferencedEnvelope(limitBox.intersection(box), dataCrs);
                }
                if (limits instanceof WMSAccessLimits && (accessLimits = (WMSAccessLimits)limits).getRasterFilter() != null && (box = accessLimits.getRasterFilter().getEnvelopeInternal()) != null) {
                    limitBox = new ReferencedEnvelope(limitBox.intersection(box), dataCrs);
                }
                if (limitBox.covers((Envelope)ReferencedEnvelope.EVERYTHING) || boundingBox != null && limitBox.contains((Envelope)boundingBox)) continue;
                throw new SecurityException("Access denied to bounding box on layer " + layerName);
            }
        }
    }

    CoordinateReferenceSystem getCRSForGridset(GridSubset gridSubset) throws NoSuchAuthorityCodeException, FactoryException {
        return CRS.decode((String)gridSubset.getSRS().toString());
    }

    public CoordinateReferenceSystem getDeclaredCrs(String geoServerTileLayerName) {
        GeoServerTileLayer layer = (GeoServerTileLayer)this.getTileLayerByName(geoServerTileLayerName);
        PublishedInfo published = layer.getPublishedInfo();
        if (published instanceof LayerInfo) {
            LayerInfo info = (LayerInfo)published;
            return info.getResource().getCRS();
        }
        LayerGroupInfo layerGroupInfo = (LayerGroupInfo)published;
        ReferencedEnvelope bounds = layerGroupInfo.getBounds();
        return bounds.getCoordinateReferenceSystem();
    }

    public static String tileLayerName(LayerInfo li) {
        return li.getResource().prefixedName();
    }

    public static String tileLayerName(LayerGroupInfo lgi) {
        return lgi.prefixedName();
    }

    public static void tryReset() {
        GWC instance = INSTANCE;
        if (instance != null) {
            INSTANCE.reset();
        }
    }

    void reset() {
        CatalogConfiguration c = (CatalogConfiguration)GeoServerExtensions.bean(CatalogConfiguration.class);
        if (c != null) {
            c.reset();
        }
    }

    public LockProvider getLockProvider() {
        return this.lockProvider;
    }

    public Executor getMetaTilingExecutor() {
        return this.metaTilingExecutor;
    }

    public JDBCConfiguration getJDBCDiskQuotaConfig() throws IOException, ConfigurationException {
        return this.jdbcConfigurationStorage.getJDBCDiskQuotaConfig();
    }

    public void testQuotaConfiguration(JDBCConfiguration jdbcConfiguration) throws ConfigurationException, IOException {
        this.jdbcConfigurationStorage.testQuotaConfiguration(jdbcConfiguration);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.gwcEnvironment = (GeoWebCacheEnvironment)GeoServerExtensions.bean(GeoWebCacheEnvironment.class);
        INSTANCE = (GWC)GeoServerExtensions.bean(GWC.class);
        GWC.INSTANCE.gwcSynchEnv.syncEnv();
    }

    public static Set<String> getAdvertisedCachedFormats(PublishedType type) {
        String resourceName = "org/geoserver/gwc/advertised_formats.properties";
        try {
            ClassLoader classLoader = GWC.class.getClassLoader();
            ArrayList urls = Lists.newArrayList((Iterator)Iterators.forEnumeration(classLoader.getResources("org/geoserver/gwc/advertised_formats.properties")));
            return GWC.getAdvertisedCachedFormats(type, urls);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static Set<String> getAdvertisedCachedFormats(PublishedType type, Iterable<URL> urls) throws IOException {
        String formatsKey = switch (type) {
            case PublishedType.VECTOR, PublishedType.REMOTE -> "formats.vector";
            case PublishedType.RASTER, PublishedType.WMS, PublishedType.WMTS -> "formats.raster";
            case PublishedType.GROUP -> "formats.layergroup";
            default -> throw new IllegalArgumentException("Unknown published type: " + String.valueOf(type));
        };
        TreeSet<String> formats = new TreeSet<String>();
        for (URL url : urls) {
            Properties props = new Properties();
            props.load(url.openStream());
            String commaSeparatedFormats = props.getProperty(formatsKey);
            if (commaSeparatedFormats == null) continue;
            List splitToList = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)commaSeparatedFormats);
            formats.addAll(splitToList);
        }
        return formats;
    }

    public List<BlobStoreInfo> getBlobStores() {
        BlobStoreAggregator agg = this.getBlobStoreAggregator();
        Iterable blobStores = agg.getBlobStores();
        if (blobStores instanceof List) {
            return (List)blobStores;
        }
        ArrayList<BlobStoreInfo> storeInfos = new ArrayList<BlobStoreInfo>(agg.getBlobStoreCount());
        blobStores.forEach(storeInfos::add);
        return storeInfos;
    }

    public BlobStoreInfo getDefaultBlobStore() {
        BlobStoreAggregator agg = this.getBlobStoreAggregator();
        for (BlobStoreInfo config : agg.getBlobStores()) {
            if (!config.isDefault()) continue;
            return config;
        }
        return null;
    }

    public void addBlobStore(BlobStoreInfo info) throws ConfigurationException {
        Preconditions.checkNotNull((Object)info);
        this.getBlobStoreAggregator().addBlobStore(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyBlobStore(String oldId, BlobStoreInfo config) throws ConfigurationException {
        Preconditions.checkNotNull((Object)oldId);
        Preconditions.checkNotNull((Object)config);
        BlobStoreAggregator agg = this.getBlobStoreAggregator();
        if (config.getName().equals(oldId)) {
            agg.modifyBlobStore(config);
        } else {
            BlobStoreAggregator blobStoreAggregator = agg;
            synchronized (blobStoreAggregator) {
                agg.renameBlobStore(oldId, config.getName());
                agg.modifyBlobStore(config);
            }
        }
    }

    public void removeBlobStores(Iterable<String> blobStoreIds) throws ConfigurationException {
        Preconditions.checkNotNull(blobStoreIds);
        BlobStoreAggregator agg = this.getBlobStoreAggregator();
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (String bsName : blobStoreIds) {
            try {
                agg.removeBlobStore(bsName);
            }
            catch (Exception ex) {
                exceptions.add(ex);
            }
        }
        if (!exceptions.isEmpty()) {
            Exception ex = (Exception)exceptions.pop();
            exceptions.forEach(ex::addSuppressed);
        }
    }

    void setBlobStores(List<BlobStoreInfo> stores) throws ConfigurationException {
        Preconditions.checkNotNull(stores, (Object)"stores is null");
        BlobStoreAggregator agg = this.getBlobStoreAggregator();
        List existingStoreNames = agg.getBlobStoreNames();
        TreeSet toDelete = new TreeSet(existingStoreNames);
        try {
            for (BlobStoreInfo info : stores) {
                toDelete.remove(info.getName());
                if (existingStoreNames.contains(info.getName())) {
                    agg.modifyBlobStore(info);
                    continue;
                }
                agg.addBlobStore(info);
            }
            for (String name : toDelete) {
                agg.removeBlobStore(name);
            }
        }
        catch (ConfigurationPersistenceException ex) {
            throw new ConfigurationException("Error saving config", (Throwable)ex);
        }
    }

    CompositeBlobStore getCompositeBlobStore() {
        CompositeBlobStore compositeBlobStore = (CompositeBlobStore)GeoWebCacheExtensions.bean(CompositeBlobStore.class);
        Preconditions.checkNotNull((Object)compositeBlobStore);
        return compositeBlobStore;
    }

    public GeoWebCacheEnvironment getGwcEnvironment() {
        return this.gwcEnvironment;
    }

    public Iterator<GWCTask> getPendingTasks() {
        return this.tileBreeder.getPendingTasks();
    }

    public Iterator<GWCTask> getRunningAndPendingTasks() {
        return this.tileBreeder.getRunningAndPendingTasks();
    }

    public static void setCacheControlHeaders(Map<String, String> map, TileLayer layer, int zoomLevel) {
        if (GWC.skipCaching(layer)) {
            GWC.setupNoCacheHeaders(map);
        } else {
            Integer cacheAgeMax = GWC.getCacheAge(layer, zoomLevel);
            log.log(Level.FINE, "Using cacheAgeMax {0}", cacheAgeMax);
            if (cacheAgeMax != null) {
                map.put("Cache-Control", "max-age=" + cacheAgeMax + ", must-revalidate");
                map.put("Expires", ServletUtils.makeExpiresHeader((int)cacheAgeMax));
            } else {
                GWC.setupNoCacheHeaders(map);
            }
        }
    }

    private static boolean skipCaching(TileLayer layer) {
        if (!(layer instanceof GeoServerTileLayer) || HTTPWarningAppender.getWarnings().isEmpty()) {
            return false;
        }
        GeoServerTileLayer gtl = (GeoServerTileLayer)layer;
        return HTTPWarningAppender.anyMatch(gtl.getInfo().getCacheWarningSkips());
    }

    private static void setupNoCacheHeaders(Map<String, String> map) {
        map.put("Cache-Control", "no-cache, no-store, must-revalidate");
        map.put("Pragma", "no-cache");
        map.put("Expires", "0");
    }

    public static void setConditionalGetHeaders(Map<String, String> map, ConveyorTile cachedTile, String etag, String ifModSinceHeader) {
        map.put("ETag", etag);
        long tileTimeStamp = cachedTile.getTSCreated();
        String lastModified = DateUtils.formatDate((Date)new Date(tileTimeStamp));
        map.put("Last-Modified", lastModified);
        if (ifModSinceHeader != null && !ifModSinceHeader.isEmpty()) {
            Date ifModifiedSince = DateUtils.parseDate((String)ifModSinceHeader);
            if (ifModifiedSince != null) {
                long tileTimeStampSeconds;
                long ifModSinceSeconds = 1000L * (ifModifiedSince.getTime() / 1000L);
                if (ifModSinceSeconds >= (tileTimeStampSeconds = 1000L * (tileTimeStamp / 1000L))) {
                    throw new HttpErrorCodeException(304);
                }
            } else if (log.isLoggable(Level.FINER)) {
                log.finer("Can't parse client's If-Modified-Since header: '" + ifModSinceHeader + "'");
            }
        }
    }

    public static void setCacheMetadataHeaders(Map<String, String> map, ConveyorTile cachedTile, TileLayer layer) {
        long[] tileIndex = cachedTile.getTileIndex();
        Conveyor.CacheResult cacheResult = cachedTile.getCacheResult();
        GridSubset gridSubset = layer.getGridSubset(cachedTile.getGridSetId());
        BoundingBox tileBounds = gridSubset.boundsFromIndex(tileIndex);
        String cacheResultHeader = cacheResult == null ? "UNKNOWN" : cacheResult.toString();
        map.put("geowebcache-layer", layer.getName());
        map.put("geowebcache-cache-result", cacheResultHeader);
        map.put("geowebcache-tile-index", Arrays.toString(tileIndex));
        map.put("geowebcache-tile-bounds", tileBounds.toString());
        map.put("geowebcache-gridset", gridSubset.getName());
        map.put("geowebcache-crs", gridSubset.getSRS().toString());
    }

    private static Integer getCacheAge(TileLayer layer, int zoomLevel) {
        int value = layer.getExpireClients(zoomLevel);
        if (value == 0) {
            return null;
        }
        return value;
    }

    public static String getETag(byte[] tileBytes) throws NoSuchAlgorithmException {
        byte[] hash = MessageDigest.getInstance("MD5").digest(tileBytes);
        String etag = GWC.toHexString(hash);
        return etag;
    }

    private static String toHexString(byte[] hash) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < hash.length; i += 4) {
            int c1 = 0xFF & hash[i];
            int c2 = 0xFF & hash[i + 1];
            int c3 = 0xFF & hash[i + 2];
            int c4 = 0xFF & hash[i + 3];
            int integer = (c1 << 24) + (c2 << 16) + (c3 << 8) + (c4 << 0);
            sb.append(Integer.toHexString(integer));
        }
        return sb.toString();
    }

    static {
        log = Logging.getLogger(GWC.class);
    }
}

