/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs.DeleteElementType;
import net.opengis.wfs.InsertElementType;
import net.opengis.wfs.TransactionType;
import net.opengis.wfs.UpdateElementType;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.gwc.GWC;
import org.geoserver.wfs.TransactionCallback;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionEventType;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.request.TransactionRequest;
import org.geoserver.wfs.request.TransactionResponse;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.SingleCRS;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.locationtech.jts.geom.Envelope;

public class GWCTransactionListener
implements TransactionCallback {
    private static Logger log = Logging.getLogger(GWCTransactionListener.class);
    private final GWC gwc;
    static final String GWC_TRANSACTION_INFO_PLACEHOLDER = "GWC_TRANSACTION_INFO_PLACEHOLDER";

    public GWCTransactionListener(GWC gwc) {
        this.gwc = gwc;
    }

    public TransactionRequest beforeTransaction(TransactionRequest request) throws WFSException {
        return request;
    }

    public void beforeCommit(TransactionRequest request) throws WFSException {
    }

    public void afterTransaction(TransactionRequest request, TransactionResponse result, boolean committed) {
        if (!committed) {
            return;
        }
        try {
            this.afterTransactionInternal(request, committed);
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, "Error trying to truncate the transaction affected area", e);
        }
    }

    private void afterTransactionInternal(TransactionRequest transaction, boolean committed) {
        Map<String, List<ReferencedEnvelope>> byLayerDirtyRegions = this.getByLayerDirtyRegions(transaction);
        if (byLayerDirtyRegions.isEmpty()) {
            return;
        }
        for (String tileLayerName : byLayerDirtyRegions.keySet()) {
            ReferencedEnvelope dirtyRegion;
            List<ReferencedEnvelope> dirtyList = byLayerDirtyRegions.get(tileLayerName);
            try {
                dirtyRegion = this.merge(tileLayerName, dirtyList);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getMessage(), e);
                continue;
            }
            if (dirtyRegion == null) continue;
            try {
                this.gwc.truncate(tileLayerName, dirtyRegion);
            }
            catch (GeoWebCacheException e) {
                log.warning("Error truncating tile layer " + tileLayerName + " for transaction affected bounds " + String.valueOf(dirtyRegion));
            }
        }
    }

    private ReferencedEnvelope merge(String tileLayerName, List<ReferencedEnvelope> dirtyList) throws TransformException, FactoryException {
        if (dirtyList.isEmpty()) {
            return null;
        }
        SingleCRS declaredCrs = CRS.getHorizontalCRS((CoordinateReferenceSystem)this.gwc.getDeclaredCrs(tileLayerName));
        ReferencedEnvelope merged = new ReferencedEnvelope((CoordinateReferenceSystem)declaredCrs);
        for (ReferencedEnvelope env : dirtyList) {
            if (env instanceof ReferencedEnvelope3D) {
                env = new ReferencedEnvelope((Envelope)env, (CoordinateReferenceSystem)CRS.getHorizontalCRS((CoordinateReferenceSystem)env.getCoordinateReferenceSystem()));
            }
            ReferencedEnvelope transformedDirtyRegion = env.transform((CoordinateReferenceSystem)declaredCrs, true, 1000);
            merged.expandToInclude((Envelope)transformedDirtyRegion);
        }
        return merged;
    }

    public int getPriority() {
        return 0;
    }

    public void dataStoreChange(TransactionEvent event) throws WFSException {
        log.info("DataStoreChange: " + String.valueOf(event.getLayerName()) + " " + String.valueOf(event.getType()));
        try {
            this.dataStoreChangeInternal(event);
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, "Error pre computing the transaction's affected area", e);
        }
    }

    private void dataStoreChangeInternal(TransactionEvent event) {
        Object source = event.getSource();
        if (!(source instanceof InsertElementType || source instanceof UpdateElementType || source instanceof DeleteElementType)) {
            return;
        }
        EObject originatingTransactionRequest = (EObject)source;
        Preconditions.checkNotNull((Object)originatingTransactionRequest, (Object)"No original transaction request exists");
        TransactionEventType type = event.getType();
        if (TransactionEventType.POST_INSERT.equals((Object)type)) {
            return;
        }
        QName featureTypeName = event.getLayerName();
        Set<String> affectedTileLayers = this.gwc.getTileLayersByFeatureType(featureTypeName.getNamespaceURI(), featureTypeName.getLocalPart());
        if (affectedTileLayers.isEmpty()) {
            return;
        }
        SimpleFeatureCollection affectedFeatures = event.getAffectedFeatures();
        ReferencedEnvelope affectedBounds = affectedFeatures.getBounds();
        TransactionType transaction = event.getRequest();
        TransactionRequest request = TransactionRequest.adapt((Object)transaction);
        for (String tileLayerName : affectedTileLayers) {
            this.addLayerDirtyRegion(request, tileLayerName, affectedBounds);
        }
    }

    private Map<String, List<ReferencedEnvelope>> getByLayerDirtyRegions(TransactionRequest transaction) {
        Map extendedProperties = transaction.getExtendedProperties();
        HashMap byLayerDirtyRegions = (HashMap)extendedProperties.get(GWC_TRANSACTION_INFO_PLACEHOLDER);
        if (byLayerDirtyRegions == null) {
            byLayerDirtyRegions = new HashMap();
            extendedProperties.put(GWC_TRANSACTION_INFO_PLACEHOLDER, byLayerDirtyRegions);
        }
        return byLayerDirtyRegions;
    }

    private void addLayerDirtyRegion(TransactionRequest transaction, String tileLayerName, ReferencedEnvelope affectedBounds) {
        Map<String, List<ReferencedEnvelope>> byLayerDirtyRegions = this.getByLayerDirtyRegions(transaction);
        List<ReferencedEnvelope> layerDirtyRegion = byLayerDirtyRegions.get(tileLayerName);
        if (layerDirtyRegion == null) {
            layerDirtyRegion = new ArrayList<ReferencedEnvelope>(2);
            byLayerDirtyRegions.put(tileLayerName, layerDirtyRegion);
        }
        layerDirtyRegion.add(affectedBounds);
    }
}

