/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.util.Set;
import javax.annotation.Nullable;
import org.geotools.styling.zoom.MedialZoomContext;
import org.geotools.styling.zoom.ZoomContext;
import org.geotools.styling.zoom.ZoomContextFinder;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;

public class GWCZoomContextFinder
implements ZoomContextFinder {
    GridSetBroker broker;

    public GWCZoomContextFinder(GridSetBroker broker) {
        this.broker = broker;
    }

    @Nullable
    public ZoomContext get(String name) {
        GridSet set = this.broker.get(name);
        if (set != null) {
            return new GWCZoomContext(set);
        }
        return null;
    }

    public Set<String> getNames() {
        return this.broker.getNames();
    }

    public Set<String> getCanonicalNames() {
        return this.broker.getNames();
    }

    static class GWCZoomContext
    extends MedialZoomContext {
        final GridSet gridset;

        public GWCZoomContext(GridSet gridset) {
            assert (gridset != null);
            this.gridset = gridset;
        }

        public double getScaleDenominator(int level) {
            if (level < 0) {
                return Double.POSITIVE_INFINITY;
            }
            if (level >= this.gridset.getNumLevels()) {
                return 0.0;
            }
            return this.gridset.getGrid(level).getScaleDenominator();
        }

        protected double getMedialScale(int level) {
            if (level >= this.gridset.getNumLevels() - 1) {
                return 0.0;
            }
            return this.getScaleDenominator(level) / 1.005;
        }

        public boolean isInRange(int level) {
            return level >= 0 && level < this.gridset.getNumLevels();
        }
    }
}

