/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.dispatch;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.gwc.layer.CatalogConfiguration;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.DispatcherCallback;
import org.geoserver.ows.LocalPublished;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.ows.Request;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.ServiceException;

public class GwcServiceDispatcherCallback
extends AbstractDispatcherCallback
implements DispatcherCallback {
    public static final ThreadLocal<String> GWC_OPERATION = new ThreadLocal();
    public static final ThreadLocal<String> GWC_ORIGINAL_BASEURL = new ThreadLocal();
    private static final Pattern GWC_WS_VIRTUAL_SERVICE_PATTERN = Pattern.compile("([^/]+)/gwc/service.*");
    private static final Pattern GWC_LAYER_VIRTUAL_SERVICE_PATTERN = Pattern.compile("([^/]+)/([^/]+)/gwc/service.*");
    private static final Pattern TILE_1 = Pattern.compile(GwcServiceDispatcherCallback.buildRestPattern(5));
    private static final Pattern TILE_2 = Pattern.compile(GwcServiceDispatcherCallback.buildRestPattern(6));
    private static final Pattern FEATUREINFO_1 = Pattern.compile(GwcServiceDispatcherCallback.buildRestPattern(7));
    private static final Pattern FEATUREINFO_2 = Pattern.compile(GwcServiceDispatcherCallback.buildRestPattern(8));
    private final Catalog catalog;

    static final String buildRestPattern(int numPathElements) {
        return ".*/service/wmts/rest" + "/([^/]+)".repeat(numPathElements);
    }

    public GwcServiceDispatcherCallback(Catalog catalog) {
        this.catalog = catalog;
    }

    public void finished(Request request) {
        GWC_OPERATION.remove();
        GWC_ORIGINAL_BASEURL.remove();
    }

    public Request init(Request request) {
        String context = request.getContext();
        if (context == null || !this.isGwcServiceTargeted(context)) {
            return null;
        }
        String requestName = (String)request.getKvp().get("REQUEST");
        String pathInfo = request.getHttpRequest().getPathInfo();
        if (requestName == null && pathInfo != null && pathInfo.contains("gwc/service/wmts/rest/")) {
            if (pathInfo.endsWith("WMTSCapabilities.xml")) {
                requestName = "GetCapabilities";
            } else if (TILE_1.matcher(pathInfo).matches() || TILE_2.matcher(pathInfo).matches()) {
                requestName = "GetTile";
            } else if (FEATUREINFO_1.matcher(pathInfo).matches() || FEATUREINFO_2.matcher(pathInfo).matches()) {
                requestName = "GetFeatureInfo";
            }
        }
        GWC_OPERATION.set(requestName);
        GWC_ORIGINAL_BASEURL.set(ResponseUtils.baseURL((HttpServletRequest)request.getHttpRequest()));
        HashMap<String, Object> kvp = new HashMap<String, Object>();
        kvp.put("service", "gwc");
        kvp.put("version", "1.0.0");
        kvp.put("request", "dispatch");
        WorkspaceInfo localWorkspace = LocalWorkspace.get();
        PublishedInfo localPublished = LocalPublished.get();
        if (localWorkspace != null) {
            Object layerName = (String)request.getKvp().get("LAYER");
            if (layerName == null) {
                layerName = (String)request.getKvp().get("layer");
            }
            if (layerName != null) {
                layerName = CatalogConfiguration.removeWorkspacePrefix((String)layerName, this.catalog);
                layerName = localWorkspace.getName() + ":" + (String)layerName;
                kvp.put("LAYER", layerName);
            }
            String localPublishedName = localPublished != null ? localPublished.getName() : null;
            request.setHttpRequest((HttpServletRequest)new VirtualServiceRequest(request.getHttpRequest(), localWorkspace.getName(), localPublishedName, (String)layerName));
        } else if (localPublished != null) {
            request.setHttpRequest((HttpServletRequest)new VirtualServiceRequest(request.getHttpRequest(), localPublished.getName(), null, null));
        }
        request.setKvp(kvp);
        request.setRawKvp(kvp);
        return request;
    }

    private boolean isGwcServiceTargeted(String context) {
        if (context.startsWith("gwc/service")) {
            return true;
        }
        Matcher matcher = GWC_WS_VIRTUAL_SERVICE_PATTERN.matcher(context);
        if (matcher.matches()) {
            if (LocalWorkspace.get() == null && !(LocalPublished.get() instanceof LayerGroupInfo)) {
                throw new ServiceException("No such workspace '" + matcher.group(1) + "'");
            }
            return true;
        }
        matcher = GWC_LAYER_VIRTUAL_SERVICE_PATTERN.matcher(context);
        if (matcher.matches()) {
            if (LocalPublished.get() == null) {
                throw new ServiceException("No such layer or layer group '" + matcher.group(2) + "'");
            }
            return true;
        }
        return false;
    }

    private static final class VirtualServiceRequest
    extends HttpServletRequestWrapper {
        private final String localWorkspaceName;
        private String localPublishedName;
        private final String layerName;
        private final Map<String, String[]> parameters;

        public VirtualServiceRequest(HttpServletRequest request, String localWorkspaceName, String localPublishedName, String layerName) {
            super(request);
            this.localWorkspaceName = localWorkspaceName;
            this.localPublishedName = localPublishedName;
            this.layerName = layerName;
            this.parameters = new HashMap<String, String[]>(request.getParameterMap());
            if (layerName != null) {
                this.parameters.put("layer", new String[]{layerName});
            }
        }

        public String getContextPath() {
            if (this.localPublishedName == null) {
                return super.getContextPath() + "/" + this.localWorkspaceName;
            }
            return super.getContextPath() + "/" + this.localWorkspaceName + "/" + this.localPublishedName;
        }

        public String getParameter(String name) {
            if (this.layerName != null && name.equalsIgnoreCase("layer")) {
                return this.layerName;
            }
            return super.getParameter(name);
        }

        public Map<String, String[]> getParameterMap() {
            return this.parameters;
        }

        public String[] getParameterValues(String name) {
            if (this.layerName != null && name.equalsIgnoreCase("layer")) {
                return new String[]{this.layerName};
            }
            return super.getParameterValues(name);
        }
    }
}

