/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupHelper;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geotools.util.logging.Logging;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;

public class CatalogLayerEventListener
implements CatalogListener {
    private static Logger log = Logging.getLogger(CatalogLayerEventListener.class);
    private final GWC mediator;
    private final Catalog catalog;
    private static ThreadLocal<CatalogModifyEvent> PRE_MODIFY_EVENT = new ThreadLocal();
    private static ThreadLocal<GeoServerTileLayerInfo> PRE_MODIFY_TILELAYER = new ThreadLocal();

    public CatalogLayerEventListener(GWC mediator, Catalog catalog) {
        this.mediator = mediator;
        this.catalog = catalog;
    }

    public void handleAddEvent(CatalogAddEvent event) throws CatalogException {
        CatalogInfo obj;
        GWCConfig config = this.mediator.getConfig();
        boolean sane = config.isSane();
        boolean cacheLayersByDefault = config.isCacheLayersByDefault();
        if (!cacheLayersByDefault) {
            return;
        }
        if (!sane) {
            log.info("Ignoring auto-creation of tile layer for " + String.valueOf(event.getSource()) + ": global gwc settings are not sane");
        }
        if ((obj = event.getSource()) instanceof LayerInfo) {
            LayerInfo layerInfo = (LayerInfo)obj;
            log.finer("Handling add event: " + String.valueOf(obj));
            this.createTileLayer(layerInfo);
        } else if (obj instanceof LayerGroupInfo) {
            LayerGroupInfo lgi = (LayerGroupInfo)obj;
            this.createTileLayer(lgi);
        }
    }

    void createTileLayer(LayerInfo layerInfo) {
        GWCConfig defaults = this.mediator.getConfig();
        if (defaults.isSane() && defaults.isCacheLayersByDefault()) {
            GridSetBroker gridSetBroker = this.mediator.getGridSetBroker();
            GeoServerTileLayer tileLayer = new GeoServerTileLayer((PublishedInfo)layerInfo, defaults, gridSetBroker);
            this.mediator.add(tileLayer);
        }
    }

    public void createTileLayer(LayerGroupInfo lgi) {
        GWCConfig defaults = this.mediator.getConfig();
        GridSetBroker gridSetBroker = this.mediator.getGridSetBroker();
        GeoServerTileLayer tileLayer = new GeoServerTileLayer((PublishedInfo)lgi, defaults, gridSetBroker);
        this.mediator.add(tileLayer);
    }

    public void handleModifyEvent(CatalogModifyEvent event) throws CatalogException {
        CatalogInfo source = event.getSource();
        if (source instanceof LayerInfo || source instanceof LayerGroupInfo || source instanceof FeatureTypeInfo || source instanceof CoverageInfo || source instanceof WMSLayerInfo || source instanceof WorkspaceInfo) {
            PRE_MODIFY_EVENT.set(event);
            if (this.mediator.hasTileLayer(source)) {
                try {
                    GeoServerTileLayer tileLayer = this.mediator.getTileLayer(source);
                    GeoServerTileLayerInfo tileLayerInfo = tileLayer.getInfo();
                    PRE_MODIFY_TILELAYER.set(tileLayerInfo);
                }
                catch (RuntimeException e) {
                    log.info("Ignoring misconfigured tile layer info for " + String.valueOf(source));
                }
            }
        }
    }

    public void handlePostModifyEvent(CatalogPostModifyEvent event) throws CatalogException {
        CatalogInfo source = event.getSource();
        if (!(source instanceof LayerInfo || source instanceof LayerGroupInfo || source instanceof FeatureTypeInfo || source instanceof CoverageInfo || source instanceof WMSLayerInfo || source instanceof WorkspaceInfo)) {
            return;
        }
        GeoServerTileLayerInfo tileLayerInfo = PRE_MODIFY_TILELAYER.get();
        PRE_MODIFY_TILELAYER.remove();
        CatalogModifyEvent preModifyEvent = PRE_MODIFY_EVENT.get();
        PRE_MODIFY_EVENT.remove();
        if (tileLayerInfo == null && !(source instanceof WorkspaceInfo)) {
            return;
        }
        if (preModifyEvent == null) {
            throw new IllegalStateException("PostModifyEvent called without having called handlePreModify first?");
        }
        List changedProperties = preModifyEvent.getPropertyNames();
        List oldValues = preModifyEvent.getOldValues();
        List newValues = preModifyEvent.getNewValues();
        log.finer("Handling modify event for " + String.valueOf(source));
        if (source instanceof ResourceInfo || source instanceof LayerGroupInfo) {
            GeoServerTileLayer tileLayer;
            if (changedProperties.contains("cqlFilter") && source instanceof FeatureTypeInfo) {
                FeatureTypeInfo info = (FeatureTypeInfo)source;
                this.mediator.truncate(info.prefixedName());
            }
            if (changedProperties.contains("name") || changedProperties.contains("namespace") || changedProperties.contains("workspace")) {
                this.handleRename(tileLayerInfo, source, changedProperties, oldValues, newValues);
            }
            if ((tileLayer = this.mediator.getTileLayer(source)) != null && (changedProperties.contains("nativeBoundingBox") || changedProperties.contains("bounds"))) {
                tileLayer.boundsChanged();
            }
        } else if (source instanceof WorkspaceInfo && changedProperties.contains("name")) {
            this.handleWorkspaceRename(source, changedProperties, oldValues, newValues);
        }
        if (source instanceof LayerInfo) {
            LayerInfo li = (LayerInfo)source;
            this.handleLayerInfoChange(changedProperties, oldValues, newValues, li, tileLayerInfo);
        } else if (source instanceof LayerGroupInfo) {
            LayerGroupInfo lgInfo = (LayerGroupInfo)source;
            this.handleLayerGroupInfoChange(changedProperties, oldValues, newValues, lgInfo, tileLayerInfo);
        }
    }

    private void handleLayerGroupInfoChange(List<String> changedProperties, List<Object> oldValues, List<Object> newValues, LayerGroupInfo lgInfo, GeoServerTileLayerInfo tileLayerInfo) {
        Preconditions.checkNotNull((Object)lgInfo);
        Preconditions.checkNotNull((Object)tileLayerInfo);
        String layerName = GWC.tileLayerName(lgInfo);
        boolean truncate = false;
        if (changedProperties.contains("layers")) {
            Object newLayers;
            int layersIndex = changedProperties.indexOf("layers");
            Object oldLayers = oldValues.get(layersIndex);
            boolean bl = truncate = !oldLayers.equals(newLayers = newValues.get(layersIndex));
        }
        if (!truncate && changedProperties.contains("styles")) {
            Object newStyles;
            int stylesIndex = changedProperties.indexOf("styles");
            Object oldStyles = oldValues.get(stylesIndex);
            boolean bl = truncate = !oldStyles.equals(newStyles = newValues.get(stylesIndex));
        }
        if (truncate) {
            log.info("Truncating TileLayer for layer group '" + layerName + "' due to a change in its layers or styles");
            this.mediator.truncate(layerName);
        }
    }

    private void handleLayerInfoChange(List<String> changedProperties, List<Object> oldValues, List<Object> newValues, LayerInfo li, GeoServerTileLayerInfo tileLayerInfo) {
        String defaultStyle;
        Preconditions.checkNotNull((Object)tileLayerInfo);
        String layerName = GWC.tileLayerName(li);
        boolean save = false;
        boolean defaultStyleChanged = false;
        if (changedProperties.contains("defaultStyle")) {
            int propIndex = changedProperties.indexOf("defaultStyle");
            StyleInfo oldStyle = (StyleInfo)oldValues.get(propIndex);
            StyleInfo newStyle = (StyleInfo)newValues.get(propIndex);
            String oldStyleName = oldStyle.prefixedName();
            if (!Objects.equals(oldStyleName, defaultStyle = newStyle.prefixedName())) {
                save = true;
                defaultStyleChanged = true;
                log.info("Truncating default style for layer " + layerName + ", as it changed from " + (String)oldStyleName + " to " + defaultStyle);
                this.mediator.truncateByLayerDefaultStyle(layerName);
            }
        } else {
            StyleInfo styleInfo = li.getDefaultStyle();
            String string = defaultStyle = styleInfo == null ? null : styleInfo.prefixedName();
        }
        if (tileLayerInfo.isAutoCacheStyles()) {
            HashSet<String> styles = new HashSet<String>();
            for (StyleInfo s : li.getStyles()) {
                styles.add(s.prefixedName());
            }
            styles.add(defaultStyle);
            ImmutableSet<String> cachedStyles = tileLayerInfo.cachedStyles();
            if (!styles.equals(cachedStyles)) {
                Sets.SetView notCachedAnyMore = Sets.difference(cachedStyles, styles);
                for (String oldCachedStyle : notCachedAnyMore) {
                    log.info("Truncating cached style " + oldCachedStyle + " of layer " + layerName + " as it's no longer one of the layer's styles");
                    this.mediator.truncateByLayerAndStyle(layerName, oldCachedStyle);
                }
                TileLayerInfoUtil.checkAutomaticStyles(li, tileLayerInfo);
                save = true;
            }
        }
        boolean cachingInfoChanged = false;
        int metadataIdx = changedProperties.indexOf("metadata");
        if (metadataIdx >= 0) {
            MetadataMap oldMetadata = (MetadataMap)oldValues.get(metadataIdx);
            MetadataMap newMetadata = (MetadataMap)newValues.get(metadataIdx);
            boolean cachingEnabledChanged = Objects.equals(oldMetadata.get("cachingEnabled", Boolean.class), newMetadata.get("cachingEnabled", Boolean.class));
            boolean cachingMaxAgeChanged = Objects.equals(oldMetadata.get("cacheAgeMax", Boolean.class), newMetadata.get("cacheAgeMax", Boolean.class));
            if (cachingEnabledChanged || cachingMaxAgeChanged) {
                cachingInfoChanged = true;
                save = true;
            }
        }
        if (save) {
            GridSetBroker gridSetBroker = this.mediator.getGridSetBroker();
            GeoServerTileLayer tileLayer = new GeoServerTileLayer((PublishedInfo)li, gridSetBroker, tileLayerInfo);
            this.mediator.save(tileLayer);
        }
        if (cachingInfoChanged || defaultStyleChanged) {
            List groups = this.catalog.getLayerGroups();
            for (LayerGroupInfo lg : groups) {
                LayerGroupHelper helper;
                int idx;
                GeoServerTileLayer tileLayer = this.mediator.getTileLayer((CatalogInfo)lg);
                if (tileLayer == null || (idx = (helper = new LayerGroupHelper(lg)).allLayers().indexOf(li)) < 0) continue;
                GridSetBroker gridSetBroker = this.mediator.getGridSetBroker();
                GeoServerTileLayerInfo groupTileLayerInfo = tileLayer.getInfo();
                GeoServerTileLayer newTileLayer = new GeoServerTileLayer((PublishedInfo)lg, gridSetBroker, groupTileLayerInfo);
                this.mediator.save(newTileLayer);
                if (!defaultStyleChanged || lg.getStyles().get(idx) != null) continue;
                this.mediator.truncate(groupTileLayerInfo.getName());
            }
        }
    }

    private void handleWorkspaceRename(CatalogInfo source, List<String> changedProperties, List<Object> oldValues, List<Object> newValues) {
        block30: {
            GeoServerTileLayer gstl;
            TileLayer tl;
            String newName;
            String oldName;
            String newWorkspaceName;
            String oldWorkspaceName;
            block29: {
                int nameIndex = changedProperties.indexOf("name");
                oldWorkspaceName = (String)oldValues.get(nameIndex);
                newWorkspaceName = (String)newValues.get(nameIndex);
                CloseableIterator layers = this.catalog.list(LayerInfo.class, Predicates.equal((String)"resource.store.workspace.name", (Object)newWorkspaceName));
                block20: while (true) {
                    while (layers.hasNext()) {
                        LayerInfo layer = (LayerInfo)layers.next();
                        oldName = oldWorkspaceName + ":" + layer.getName();
                        newName = newWorkspaceName + ":" + layer.getName();
                        try {
                            tl = this.mediator.getTileLayerByName(oldName);
                            if (!(tl instanceof GeoServerTileLayer)) {
                            }
                        }
                        catch (IllegalArgumentException e) {}
                        continue;
                        try {
                            if (layer.getType() == PublishedType.VECTOR && ((FeatureTypeInfo)layer.getResource()).getFeatureType().getGeometryDescriptor() == null) {
                                continue;
                            }
                        }
                        catch (IOException e) {
                            log.log(Level.FINE, "Failed to determine if layer" + String.valueOf(layer) + " is geometryless while renaming tile layers for workspace name change " + oldName + " -> " + newName, e);
                        }
                        try {
                            if (!(tl instanceof GeoServerTileLayer)) continue block20;
                            gstl = (GeoServerTileLayer)tl;
                            this.renameTileLayer(gstl.getInfo(), oldName, newName);
                            continue block20;
                        }
                        catch (Exception e) {
                            log.log(Level.WARNING, "Failed to rename tile layer for geoserver layer " + String.valueOf(layer) + " while renaming tile layers for workspace name change " + oldName + " -> " + newName, e);
                        }
                    }
                    break block29;
                    {
                        continue block20;
                        break;
                    }
                    break;
                }
                finally {
                    if (layers != null) {
                        layers.close();
                    }
                }
            }
            CloseableIterator groups = this.catalog.list(LayerGroupInfo.class, Predicates.equal((String)"workspace.name", (Object)newWorkspaceName));
            block22: while (true) {
                while (groups.hasNext()) {
                    LayerGroupInfo group = (LayerGroupInfo)groups.next();
                    oldName = oldWorkspaceName + ":" + group.getName();
                    newName = newWorkspaceName + ":" + group.getName();
                    try {
                        tl = this.mediator.getTileLayerByName(oldName);
                        if (!(tl instanceof GeoServerTileLayer)) {
                        }
                    }
                    catch (IllegalArgumentException e) {}
                    continue;
                    try {
                        if (!(tl instanceof GeoServerTileLayer)) continue block22;
                        gstl = (GeoServerTileLayer)tl;
                        this.renameTileLayer(gstl.getInfo(), oldName, newName);
                        continue block22;
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Failed to rename tile layer for geoserver group " + String.valueOf(group) + " while renaming tile layers for workspace name change " + oldName + " -> " + newName, e);
                    }
                }
                break block30;
                {
                    continue block22;
                    break;
                }
                break;
            }
            finally {
                if (groups != null) {
                    groups.close();
                }
            }
        }
    }

    private void handleRename(GeoServerTileLayerInfo tileLayerInfo, CatalogInfo source, List<String> changedProperties, List<Object> oldValues, List<Object> newValues) {
        Object oldLayerName;
        String newLayerName;
        int nameIndex = changedProperties.indexOf("name");
        int namespaceIndex = changedProperties.indexOf("namespace");
        if (source instanceof ResourceInfo) {
            ResourceInfo resourceInfo = (ResourceInfo)source;
            NamespaceInfo currNamespace = resourceInfo.getNamespace();
            NamespaceInfo oldNamespace = namespaceIndex > -1 ? (NamespaceInfo)oldValues.get(namespaceIndex) : currNamespace;
            newLayerName = resourceInfo.prefixedName();
            oldLayerName = nameIndex > -1 ? (String)oldValues.get(nameIndex) : resourceInfo.getName();
            oldLayerName = oldNamespace.getPrefix() + ":" + (String)oldLayerName;
        } else {
            oldLayerName = tileLayerInfo.getName();
            newLayerName = GWC.tileLayerName((LayerGroupInfo)source);
        }
        if (!((String)oldLayerName).equals(newLayerName)) {
            this.renameTileLayer(tileLayerInfo, (String)oldLayerName, newLayerName);
        }
    }

    private void renameTileLayer(GeoServerTileLayerInfo tileLayerInfo, String oldLayerName, String newLayerName) {
        tileLayerInfo.setName(newLayerName);
        GeoServerTileLayer oldTileLayer = (GeoServerTileLayer)this.mediator.getTileLayerByName(oldLayerName);
        Preconditions.checkState((null != oldTileLayer ? 1 : 0) != 0, (Object)("handleRename: old tile layer not found: '" + oldLayerName + "'. New name: '" + newLayerName + "'"));
        this.mediator.rename(oldLayerName, newLayerName);
    }

    public void handleRemoveEvent(CatalogRemoveEvent event) throws CatalogException {
        CatalogInfo obj = event.getSource();
        if (!(obj instanceof LayerInfo) && !(obj instanceof LayerGroupInfo)) {
            return;
        }
        if (!this.mediator.hasTileLayer(obj)) {
            return;
        }
        String prefixedName = null;
        if (obj instanceof LayerGroupInfo) {
            LayerGroupInfo lgInfo = (LayerGroupInfo)obj;
            prefixedName = GWC.tileLayerName(lgInfo);
        } else if (obj instanceof LayerInfo) {
            LayerInfo layerInfo = (LayerInfo)obj;
            prefixedName = GWC.tileLayerName(layerInfo);
        }
        if (null != prefixedName) {
            this.mediator.removeTileLayers(Arrays.asList(prefixedName));
        }
    }

    public void reloaded() {
    }
}

