/*
 * Decompiled with CFR 0.152.
 */
package geodb;

import geodb.GeoDB;
import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.h2.api.Trigger;

public class GeoHashTrigger
implements Trigger {
    int type;
    List<Integer[]> gindex;

    public void fire(Connection cx, Object[] oldRow, Object[] newRow) throws SQLException {
        for (Integer[] entry : this.gindex) {
            byte[] buffer;
            String hash = null;
            ByteArrayInputStream input = null;
            if (this.type == 1) {
                input = (ByteArrayInputStream)newRow[entry[0]];
            }
            if (this.type == 2) {
                input = (ByteArrayInputStream)oldRow[entry[0]];
            }
            if (input != null && (buffer = new byte[input.available()]).length > 0) {
                input.read(buffer, 0, buffer.length);
                hash = GeoDB.ST_GeoHash(buffer);
                input.reset();
            }
            if (this.type == 1) {
                newRow[entry[1].intValue()] = hash;
            }
            if (this.type != 2) continue;
            oldRow[entry[1].intValue()] = hash;
        }
    }

    public void init(Connection cx, String schemaName, String triggerName, String tableName, boolean before, int type) throws SQLException {
        String name;
        this.type = type;
        this.gindex = new ArrayList<Integer[]>();
        DatabaseMetaData md = cx.getMetaData();
        ResultSet columns = md.getColumns(null, schemaName, tableName, "%");
        ArrayList<String> gColNames = new ArrayList<String>();
        int i = 0;
        while (columns.next()) {
            name = columns.getString("COLUMN_NAME");
            if (name.startsWith("_") && name.endsWith("_geohash")) {
                String gColName = name.substring(1, name.length() - 8);
                gColNames.add(gColName);
                this.gindex.add(new Integer[]{null, i});
            }
            ++i;
        }
        columns.close();
        columns = md.getColumns(null, schemaName, tableName, "%");
        i = 0;
        while (columns.next()) {
            name = columns.getString("COLUMN_NAME");
            int j = gColNames.indexOf(name);
            if (j != -1) {
                this.gindex.get((int)j)[0] = i;
            }
            ++i;
        }
    }

    public void close() throws SQLException {
    }

    public void remove() throws SQLException {
    }
}

