/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.transform;

import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.Divide;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.Multiply;
import org.geotools.api.filter.expression.NilExpression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.expression.Subtract;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.JTS;
import org.locationtech.jts.geom.Geometry;

class CRSEvaluator
implements ExpressionVisitor {
    private SimpleFeatureType schema;

    public CRSEvaluator(SimpleFeatureType schema) {
        this.schema = schema;
    }

    public Object visit(Literal expression, Object extraData) {
        Object value = expression.getValue();
        if (value instanceof Geometry) {
            Geometry g = (Geometry)value;
            CoordinateReferenceSystem crs = JTS.getCRS(g);
            return crs;
        }
        return null;
    }

    public Object visit(Function expression, Object extraData) {
        for (Expression param : expression.getParameters()) {
            Object result = param.accept((ExpressionVisitor)this, extraData);
            if (!(result instanceof CoordinateReferenceSystem)) continue;
            return result;
        }
        return null;
    }

    public Object visit(PropertyName expression, Object extraData) {
        AttributeDescriptor ad = (AttributeDescriptor)expression.evaluate((Object)this.schema, AttributeDescriptor.class);
        if (ad == null) {
            throw new IllegalArgumentException("Original feature type does not have a property named " + expression.getPropertyName());
        }
        if (ad instanceof GeometryDescriptor) {
            GeometryDescriptor descriptor = (GeometryDescriptor)ad;
            return descriptor.getCoordinateReferenceSystem();
        }
        return null;
    }

    public Object visit(NilExpression expression, Object extraData) {
        return null;
    }

    public Object visit(Add expression, Object extraData) {
        return null;
    }

    public Object visit(Divide expression, Object extraData) {
        return null;
    }

    public Object visit(Multiply expression, Object extraData) {
        return null;
    }

    public Object visit(Subtract expression, Object extraData) {
        return null;
    }
}

