/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.transform;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.SimpleFeatureLocking;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.data.transform.Definition;
import org.geotools.data.transform.TransformFeatureLocking;
import org.geotools.data.transform.TransformFeatureSource;
import org.geotools.data.transform.TransformFeatureStore;
import org.geotools.feature.NameImpl;
import org.geotools.util.logging.Logging;

public class TransformFactory {
    static final Logger LOGGER = Logging.getLogger(TransformFactory.class);

    public static SimpleFeatureSource transform(SimpleFeatureSource source, String name, List<Definition> definitions) throws IOException {
        return TransformFactory.transform(source, new NameImpl(((SimpleFeatureType)source.getSchema()).getName().getNamespaceURI(), name), definitions);
    }

    public static SimpleFeatureSource transform(SimpleFeatureSource source, Name name, List<Definition> definitions) throws IOException {
        if (source instanceof SimpleFeatureLocking) {
            SimpleFeatureLocking locking = (SimpleFeatureLocking)source;
            try {
                return new TransformFeatureLocking(locking, name, definitions);
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.FINEST, "Could not transform the provided locking, will turn it into a read only SimpleFeatureSource instead (this is not a problem unless you actually needed to write on the store)", e);
            }
        }
        if (source instanceof SimpleFeatureStore) {
            SimpleFeatureStore store = (SimpleFeatureStore)source;
            try {
                return new TransformFeatureStore(store, name, definitions);
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.FINEST, "Could not transform the provided store, will turn it into a read only SimpleFeatureSource instead (this is not a problem unless you actually needed to write on the store)", e);
            }
        }
        return new TransformFeatureSource(source, name, definitions);
    }
}

