/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.transform;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.sort.SortedFeatureIterator;
import org.geotools.data.store.EmptyFeatureCollection;
import org.geotools.data.transform.Definition;
import org.geotools.data.transform.MaxFeaturesIterator;
import org.geotools.data.transform.SimpleFeatureIteratorIterator;
import org.geotools.data.transform.TransformFeatureIteratorWrapper;
import org.geotools.data.transform.Transformer;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.AbstractFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.FeatureAttributeVisitor;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;

class TransformFeatureCollection
extends AbstractFeatureCollection {
    static final Logger LOGGER = Logging.getLogger(TransformFeatureCollection.class);
    SimpleFeatureSource source;
    Transformer transformer;
    Query query;

    public TransformFeatureCollection(SimpleFeatureSource source, Transformer transformer, Query query) {
        super(TransformFeatureCollection.retypeSchema((SimpleFeatureType)source.getSchema(), query));
        this.source = source;
        this.transformer = transformer;
        this.query = query;
    }

    static SimpleFeatureType retypeSchema(SimpleFeatureType schema, Query query) {
        if (query.getPropertyNames() == Query.ALL_NAMES && CRS.equalsIgnoreMetadata(schema.getCoordinateReferenceSystem(), query.getCoordinateSystemReproject())) {
            return schema;
        }
        return SimpleFeatureTypeBuilder.retype(schema, query);
    }

    @Override
    protected Iterator<SimpleFeature> openIterator() {
        FeatureIterator fi = null;
        SimpleFeatureIteratorIterator result = null;
        try {
            Query txQuery = this.transformer.transformQuery(this.query);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "The original query for feature extraction {0} has been transformed to {1}", new Object[]{this.query, txQuery});
            }
            fi = this.transformer.getSource().getFeatures(txQuery).features();
            Transformer iteratorTransformer = this.transformer;
            if (this.query.getPropertyNames() != Query.ALL_NAMES) {
                ArrayList<Definition> definitions = new ArrayList<Definition>();
                for (String name : this.query.getPropertyNames()) {
                    this.transformer.getDefinitions().stream().filter(d -> d.name.equals(name)).findFirst().ifPresent(definitions::add);
                }
                iteratorTransformer = new Transformer(this.transformer.getSource(), this.transformer.getName(), definitions, this.getSchema());
            }
            SimpleFeatureIterator transformed = new TransformFeatureIteratorWrapper(fi, iteratorTransformer);
            if (this.query.getSortBy() != null && txQuery.getSortBy() == null) {
                transformed = new SortedFeatureIterator(transformed, this.getSchema(), this.query.getSortBy(), -1);
            }
            if (this.query.getStartIndex() != null && txQuery.getStartIndex() == null) {
                for (int i = 0; i < this.query.getStartIndex() && transformed.hasNext(); ++i) {
                    transformed.next();
                }
            }
            if (txQuery.getMaxFeatures() > this.query.getMaxFeatures()) {
                transformed = new MaxFeaturesIterator(transformed, this.query.getMaxFeatures());
            }
            result = new SimpleFeatureIteratorIterator(transformed);
        }
        catch (IOException e) {
            throw new RuntimeException("Transform failure: " + e.getMessage(), e);
        }
        finally {
            if (result == null && fi != null) {
                fi.close();
            }
        }
        return result;
    }

    @Override
    public int size() {
        int n;
        block11: {
            Query txQuery = this.transformer.transformQuery(this.query);
            int size = this.source.getCount(this.query);
            if (size >= 0) {
                if (this.query.getStartIndex() != null && txQuery.getStartIndex() == null) {
                    size -= this.query.getStartIndex().intValue();
                }
                return Math.min(size, this.query.getMaxFeatures());
            }
            SimpleFeatureIterator fi = this.source.getFeatures(this.query).features();
            try {
                size = 0;
                while (fi.hasNext()) {
                    fi.next();
                    ++size;
                }
                n = size;
                if (fi == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (fi != null) {
                        try {
                            fi.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            fi.close();
        }
        return n;
    }

    @Override
    public ReferencedEnvelope getBounds() {
        ReferencedEnvelope referencedEnvelope;
        block11: {
            ReferencedEnvelope re = this.source.getBounds(this.query);
            if (re != null) {
                return re;
            }
            SimpleFeatureIterator fi = this.source.getFeatures(this.query).features();
            try {
                while (fi.hasNext()) {
                    SimpleFeature f = (SimpleFeature)fi.next();
                    BoundingBox bb = f.getBounds();
                    if (bb == null) continue;
                    ReferencedEnvelope ref = ReferencedEnvelope.reference((Bounds)bb);
                    if (re == null) {
                        re = ref;
                        continue;
                    }
                    re.expandToInclude(ref);
                }
                referencedEnvelope = re;
                if (fi == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (fi != null) {
                        try {
                            fi.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            fi.close();
        }
        return referencedEnvelope;
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        if (filter == Filter.INCLUDE) {
            return this;
        }
        if (filter == Filter.EXCLUDE || this.query.getFilter() == Filter.EXCLUDE) {
            return new EmptyFeatureCollection(this.getSchema());
        }
        Query q = new Query(this.query);
        if (this.query.getFilter() == Filter.INCLUDE) {
            q.setFilter(filter);
        } else {
            FilterFactory ff = CommonFactoryFinder.getFilterFactory();
            And combined = ff.and(filter, q.getFilter());
            q.setFilter((Filter)combined);
        }
        return new TransformFeatureCollection(this.source, this.transformer, q);
    }

    protected boolean isTypeCompatible(FeatureVisitor visitor, SimpleFeatureType featureType) {
        if (visitor instanceof CountVisitor) {
            return true;
        }
        if (visitor instanceof FeatureAttributeVisitor) {
            FeatureAttributeVisitor attributeVisitor = (FeatureAttributeVisitor)visitor;
            for (Expression e : attributeVisitor.getExpressions()) {
                if (!(e instanceof PropertyName)) {
                    return false;
                }
                PropertyName externalName = (PropertyName)e;
                Expression attributeExpression = this.transformer.getExpression(externalName.getPropertyName());
                if (!(attributeExpression instanceof PropertyName)) {
                    return false;
                }
                if (((PropertyName)attributeExpression).getPropertyName().equals(externalName.getPropertyName())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        if (this.isTypeCompatible(visitor, this.transformer.getSchema())) {
            this.delegateVisitor(visitor, progress);
        } else if (visitor instanceof MinVisitor) {
            MinVisitor original = (MinVisitor)visitor;
            Expression transformedExpression = this.transformer.transformExpression(original.getExpression());
            MinVisitor transformedVisitor = new MinVisitor(transformedExpression);
            this.delegateVisitor(transformedVisitor, progress);
            original.setValue(transformedVisitor.getResult().getValue());
        } else if (visitor instanceof MaxVisitor) {
            MaxVisitor original = (MaxVisitor)visitor;
            Expression transformedExpression = this.transformer.transformExpression(original.getExpression());
            MaxVisitor transformedVisitor = new MaxVisitor(transformedExpression);
            this.delegateVisitor(transformedVisitor, progress);
            original.setValue(transformedVisitor.getResult().getValue());
        } else if (visitor instanceof UniqueVisitor) {
            UniqueVisitor original = (UniqueVisitor)visitor;
            Expression transformedExpression = this.transformer.transformExpression(original.getExpression());
            UniqueVisitor transformedVisitor = new UniqueVisitor(transformedExpression);
            transformedVisitor.setMaxFeatures(original.getMaxFeatures());
            transformedVisitor.setStartIndex(original.getStartIndex());
            transformedVisitor.setPreserveOrder(original.isPreserveOrder());
            this.delegateVisitor(transformedVisitor, progress);
            original.setValue(transformedVisitor.getResult().getValue());
        } else {
            super.accepts(visitor, progress);
        }
    }

    protected void delegateVisitor(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        Query txQuery = this.transformer.transformQuery(this.query);
        this.transformer.getSource().getFeatures(txQuery).accepts(visitor, progress);
    }
}

