/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style.svg;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class RenderableSVG {
    Rectangle2D bounds;
    GraphicsNode node;

    public RenderableSVG(Document doc) {
        this.node = this.getGraphicNode(doc);
        this.bounds = this.getSvgDocBounds(doc);
        if (this.bounds == null) {
            this.bounds = this.node.getBounds();
        }
    }

    private Rectangle2D getSvgDocBounds(Document doc) {
        NodeList list = doc.getElementsByTagName("svg");
        Node svgNode = list.item(0);
        NamedNodeMap attributes = svgNode.getAttributes();
        Node widthNode = attributes.getNamedItem("width");
        Node heightNode = attributes.getNamedItem("height");
        if (widthNode != null && heightNode != null) {
            double width = this.parseDouble(widthNode.getNodeValue());
            double height = this.parseDouble(heightNode.getNodeValue());
            return new Rectangle2D.Double(0.0, 0.0, width, height);
        }
        return null;
    }

    private double parseDouble(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return Double.parseDouble(value.replaceAll("\\D*$", ""));
        }
    }

    GraphicsNode getGraphicNode(Document doc) {
        UserAgentAdapter userAgent = new UserAgentAdapter();
        DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
        BridgeContext ctx = new BridgeContext((UserAgent)userAgent, loader);
        ctx.setDynamic(true);
        GVTBuilder builder = new GVTBuilder();
        return builder.build(ctx, doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g, int width, int height, int x, int y) {
        AffineTransform oldTransform = g.getTransform();
        try {
            if (oldTransform == null) {
                oldTransform = new AffineTransform();
            }
            AffineTransform transform = new AffineTransform(oldTransform);
            transform.translate(x, y);
            transform.scale((double)width / this.bounds.getWidth(), (double)height / this.bounds.getHeight());
            g.setTransform(transform);
            this.node.paint(g);
        }
        finally {
            g.setTransform(oldTransform);
        }
    }
}

