/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.ModuleStatus;
import org.geotools.util.logging.Logging;

public class SystemEnvironmentStatus
implements ModuleStatus {
    private static final Logger LOGGER = Logging.getLogger(SystemEnvironmentStatus.class);
    public static final String SystemEnvironmentStatusEnabledEnvironmentVar = "GEOSERVER_MODULE_SYSTEM_ENVIRONMENT_STATUS_ENABLED";

    @Override
    public String getModule() {
        return "system-environment";
    }

    @Override
    public Optional<String> getComponent() {
        return Optional.ofNullable(System.getProperty("os.name"));
    }

    @Override
    public String getName() {
        return "System Environment";
    }

    @Override
    public Optional<String> getVersion() {
        return Optional.ofNullable(System.getProperty("os.version"));
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    String getEnvironmentVariable(String envVar) {
        return System.getenv(envVar);
    }

    public boolean isShow() {
        String val = this.getEnvironmentVariable(SystemEnvironmentStatusEnabledEnvironmentVar);
        if (val == null) {
            return false;
        }
        if (val.equalsIgnoreCase("true") || val.equalsIgnoreCase("false")) {
            return val.equalsIgnoreCase("true");
        }
        LOGGER.log(Level.WARNING, "environment variable '%s' should be 'true' or 'false', but was '%s'".formatted(SystemEnvironmentStatusEnabledEnvironmentVar, val));
        return false;
    }

    @Override
    public Optional<String> getMessage() {
        if (!this.isShow()) {
            String message = "Environment variables hidden for security reasons.  Set the environment variable '%s' to 'true' to see them.".formatted(SystemEnvironmentStatusEnabledEnvironmentVar);
            return Optional.of(message);
        }
        StringBuffer result = new StringBuffer();
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            result.append(entry.getKey().toString() + "=" + entry.getValue().toString() + "\n");
        }
        return Optional.ofNullable(result.toString());
    }

    @Override
    public Optional<String> getDocumentation() {
        return Optional.empty();
    }
}

