/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.ModuleStatus;
import org.geotools.util.logging.Logging;

public class SystemPropertyStatus
implements ModuleStatus {
    private static final Logger LOGGER = Logging.getLogger(SystemPropertyStatus.class);
    public static final String SystemPropertyStatusEnabledEnvironmentVar = "GEOSERVER_MODULE_SYSTEM_PROPERTY_STATUS_ENABLED";

    @Override
    public String getModule() {
        return "system-properties";
    }

    @Override
    public Optional<String> getComponent() {
        return Optional.ofNullable(System.getProperty("java.runtime.name"));
    }

    @Override
    public String getName() {
        return "System Properties";
    }

    @Override
    public Optional<String> getVersion() {
        return Optional.ofNullable(System.getProperty("java.runtime.version"));
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    String getEnvironmentVariable(String envVar) {
        return System.getenv(envVar);
    }

    public boolean isShow() {
        String val = this.getEnvironmentVariable(SystemPropertyStatusEnabledEnvironmentVar);
        if (val == null) {
            return false;
        }
        if (val.equalsIgnoreCase("true") || val.equalsIgnoreCase("false")) {
            return val.equalsIgnoreCase("true");
        }
        LOGGER.log(Level.WARNING, "environment variable '%s' should be 'true' or 'false', but was '%s'".formatted(SystemPropertyStatusEnabledEnvironmentVar, val));
        return false;
    }

    @Override
    public Optional<String> getMessage() {
        if (!this.isShow()) {
            String message = "Java system properties hidden for security reasons.  Set the environment variable '%s' to 'true' to see them.".formatted(SystemPropertyStatusEnabledEnvironmentVar);
            return Optional.of(message);
        }
        StringBuffer result = new StringBuffer();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            result.append(entry.getKey().toString() + "=" + entry.getValue().toString() + "\n");
        }
        return Optional.ofNullable(result.toString());
    }

    @Override
    public Optional<String> getDocumentation() {
        return Optional.empty();
    }
}

