/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.SystemUtils;

public class FilePaths {
    static final Pattern WINDOWS_DRIVE_LETTER = Pattern.compile("^\\w\\:/.*$");

    public static List<String> names(String path) {
        String item;
        if (path == null || path.isEmpty()) {
            return Collections.emptyList();
        }
        int index = 0;
        int split = path.indexOf(47);
        if (split == -1) {
            return Collections.singletonList(path);
        }
        ArrayList<String> names = new ArrayList<String>(3);
        do {
            if ((item = index == 0 && FilePaths.isAbsolute(path) ? path.substring(0, split + 1) : path.substring(index, split)).isEmpty()) continue;
            names.add(item);
        } while ((split = path.indexOf(47, index = split + 1)) != -1);
        item = path.substring(index);
        if (item != null && !item.isEmpty() && !item.equals("/")) {
            names.add(item);
        }
        return names;
    }

    public static boolean isAbsolute(String path) {
        return FilePaths.isAbsolute(path, SystemUtils.IS_OS_WINDOWS);
    }

    static boolean isAbsolute(String path, boolean isWindows) {
        if (isWindows) {
            return WINDOWS_DRIVE_LETTER.matcher(path).matches();
        }
        return path != null && path.startsWith("/");
    }

    private static File root(String name) {
        for (File root : File.listRoots()) {
            if (!root.getPath().equalsIgnoreCase(name)) continue;
            return root;
        }
        return null;
    }

    public static File toFile(File base, String path) {
        if (FilePaths.isAbsolute(path) && base != null) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            } else {
                base = null;
            }
        }
        for (String item : FilePaths.names(path)) {
            if (base == null && FilePaths.isAbsolute(item)) {
                base = FilePaths.root(item.replace('/', File.separatorChar));
                continue;
            }
            base = new File(base, item);
        }
        return base;
    }
}

