/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.resource.FileSystemWatcher;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.LockProvider;
import org.geoserver.platform.resource.NullLockProvider;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceListener;
import org.geoserver.platform.resource.ResourceNotificationDispatcher;
import org.geoserver.platform.resource.ResourceStore;
import org.geoserver.platform.resource.Resources;
import org.geoserver.util.IOUtils;
import org.geotools.util.logging.Logging;

public class FileSystemResourceStore
implements ResourceStore {
    static final Logger LOGGER = Logging.getLogger(FileSystemResource.class);
    public static final String GS_LOCK_TRACE = "gs.lock.trace";
    protected static final Boolean TRACE_ENABLED = "true".equalsIgnoreCase(System.getProperty("gs.lock.trace"));
    protected LockProvider lockProvider = new NullLockProvider();
    protected File baseDirectory = null;
    final AtomicReference<FileSystemWatcher> watcher = new AtomicReference<Object>(null);

    protected FileSystemResourceStore() {
    }

    public LockProvider getLockProvider() {
        return this.lockProvider;
    }

    public void setLockProvider(LockProvider lockProvider) {
        this.lockProvider = lockProvider;
    }

    public FileSystemResourceStore(File resourceDirectory) {
        boolean create;
        if (resourceDirectory == null) {
            throw new NullPointerException("root resource directory required");
        }
        if (resourceDirectory.isFile()) {
            throw new IllegalArgumentException("Directory required, file present at this location " + String.valueOf(resourceDirectory));
        }
        if (!resourceDirectory.isAbsolute()) {
            try {
                resourceDirectory = resourceDirectory.getCanonicalFile();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to resolve " + String.valueOf(resourceDirectory) + " to an absolute location");
            }
        }
        if (!resourceDirectory.exists() && !(create = resourceDirectory.mkdirs())) {
            throw new IllegalArgumentException("Unable to create directory " + String.valueOf(resourceDirectory));
        }
        if (!resourceDirectory.exists() || !resourceDirectory.isDirectory()) {
            throw new IllegalArgumentException("Unable to acess directory " + String.valueOf(resourceDirectory));
        }
        this.baseDirectory = resourceDirectory;
    }

    @Override
    public Resource get(String path) {
        path = Paths.valid(path);
        return new FileSystemResource(path);
    }

    @Override
    public boolean remove(String path) {
        path = Paths.valid(path);
        File file = new File(this.baseDirectory, path);
        return Files.delete(file);
    }

    @Override
    public boolean move(String path, String target) {
        path = Paths.valid(path);
        target = Paths.valid(target);
        File file = new File(this.baseDirectory, path);
        File dest = new File(this.baseDirectory, target);
        if (!file.exists() && !dest.exists()) {
            return true;
        }
        try {
            dest.getParentFile().mkdirs();
            java.nio.file.Files.move(Path.of(file.getAbsolutePath(), new String[0]), Path.of(dest.getAbsolutePath(), new String[0]), StandardCopyOption.ATOMIC_MOVE);
            return true;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to move " + path + " to " + target, e);
        }
    }

    public String toString() {
        return "ResourceStore " + String.valueOf(this.baseDirectory);
    }

    @Override
    public ResourceNotificationDispatcher getResourceNotificationDispatcher() {
        FileSystemWatcher instance = this.watcher.get();
        if (instance == null) {
            instance = this.watcher.updateAndGet(v -> v == null ? new FileSystemWatcher(path -> new File(this.baseDirectory, (String)path)) : v);
        }
        return instance;
    }

    class FileSystemResource
    implements Resource {
        String path;
        File file;

        public FileSystemResource(String path) {
            this.file = new File(FileSystemResourceStore.this.baseDirectory, path);
            this.path = Paths.convert(FileSystemResourceStore.this.baseDirectory, this.file);
        }

        @Override
        public String path() {
            return this.path;
        }

        @Override
        public String name() {
            return Paths.name(this.path);
        }

        @Override
        public Resource.Lock lock() {
            return FileSystemResourceStore.this.lockProvider.acquire(this.path());
        }

        @Override
        public void addListener(ResourceListener listener) {
            FileSystemResourceStore.this.getResourceNotificationDispatcher().addListener(this.path, listener);
        }

        @Override
        public void removeListener(ResourceListener listener) {
            FileSystemResourceStore.this.getResourceNotificationDispatcher().removeListener(this.path, listener);
        }

        @Override
        public InputStream in() {
            File actualFile = this.file;
            if (!actualFile.exists()) {
                throw new IllegalStateException("File not found " + String.valueOf(actualFile));
            }
            final Resource.Lock lock = this.lock();
            if (TRACE_ENABLED.booleanValue()) {
                Exception tracer = new Exception();
                tracer.fillInStackTrace();
            } else {
                Object tracer = null;
            }
            try {
                return new FileInputStream(this.file){
                    boolean closed;
                    {
                        super(file);
                        this.closed = false;
                    }

                    @Override
                    public void close() throws IOException {
                        this.closed = true;
                        super.close();
                        lock.release();
                    }
                };
            }
            catch (FileNotFoundException e) {
                lock.release();
                throw new IllegalStateException("File not found " + String.valueOf(actualFile), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OutputStream out() {
            final File actualFile = this.file();
            if (!actualFile.exists()) {
                throw new IllegalStateException("Cannot access " + String.valueOf(actualFile));
            }
            try {
                File temp;
                FileSystemResource fileSystemResource = this;
                synchronized (fileSystemResource) {
                    UUID uuid;
                    File tryTemp;
                    do {
                        uuid = UUID.randomUUID();
                    } while ((tryTemp = new File(actualFile.getParentFile(), "%s.%s.tmp".formatted(actualFile.getName(), uuid))).exists());
                    temp = tryTemp;
                }
                return new OutputStream(){
                    FileOutputStream delegate;
                    {
                        this.delegate = new FileOutputStream(temp);
                    }

                    @Override
                    public void close() throws IOException {
                        this.delegate.close();
                        if (temp.exists()) {
                            Resource.Lock lock = FileSystemResource.this.lock();
                            try {
                                Files.move(temp, actualFile);
                            }
                            finally {
                                lock.release();
                            }
                        }
                    }

                    @Override
                    public void write(byte[] b, int off, int len) throws IOException {
                        this.delegate.write(b, off, len);
                    }

                    @Override
                    public void flush() throws IOException {
                        this.delegate.flush();
                    }

                    @Override
                    public void write(byte[] b) throws IOException {
                        this.delegate.write(b);
                    }

                    @Override
                    public void write(int b) throws IOException {
                        this.delegate.write(b);
                    }
                };
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Cannot access " + String.valueOf(actualFile), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public File file() {
            block11: {
                if (!this.file.exists()) {
                    try {
                        boolean created;
                        File parent = this.file.getParentFile();
                        if (!parent.exists() && !(created = parent.mkdirs())) {
                            throw new IllegalStateException("Unable to create " + parent.getAbsolutePath());
                        }
                        if (parent.isDirectory()) {
                            boolean created2;
                            Resource.Lock lock = this.lock();
                            try {
                                created2 = this.file.createNewFile();
                            }
                            finally {
                                lock.release();
                            }
                            if (!created2) {
                                throw new FileNotFoundException("Unable to create " + this.file.getAbsolutePath());
                            }
                            break block11;
                        }
                        throw new FileNotFoundException("Unable to create" + this.file.getName() + " - not a directory " + parent.getAbsolutePath());
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot create " + this.path, e);
                    }
                }
            }
            if (this.file.isDirectory()) {
                throw new IllegalStateException("Directory (not a file) at " + this.path);
            }
            return this.file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public File dir() {
            block11: {
                if (!this.file.exists()) {
                    try {
                        boolean created;
                        File parent = this.file.getParentFile();
                        if (!parent.exists() && !(created = parent.mkdirs())) {
                            throw new IllegalStateException("Unable to create " + parent.getAbsolutePath());
                        }
                        if (parent.isDirectory()) {
                            boolean created2;
                            Resource.Lock lock = this.lock();
                            try {
                                created2 = this.file.mkdir();
                            }
                            finally {
                                lock.release();
                            }
                            if (!created2) {
                                throw new FileNotFoundException("Unable to create " + this.file.getAbsolutePath());
                            }
                            break block11;
                        }
                        throw new FileNotFoundException("Unable to create" + this.file.getName() + " - not a directory " + parent.getAbsolutePath());
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot create " + this.path, e);
                    }
                }
            }
            if (this.file.isFile()) {
                throw new IllegalStateException("File (not a directory) at " + this.path);
            }
            return this.file;
        }

        @Override
        public long lastmodified() {
            return this.file.lastModified();
        }

        @Override
        public List<Resource> list() {
            if (!this.file.exists()) {
                return Collections.emptyList();
            }
            if (this.file.isFile()) {
                return Collections.emptyList();
            }
            String[] array = this.file.list();
            if (array == null) {
                return Collections.emptyList();
            }
            ArrayList<Resource> list = new ArrayList<Resource>(array.length);
            for (String filename : array) {
                Resource resource = FileSystemResourceStore.this.get(Paths.path(this.path, filename));
                list.add(resource);
            }
            return list;
        }

        @Override
        public Resource parent() {
            int split = this.path.lastIndexOf(47);
            if (split == -1) {
                return FileSystemResourceStore.this.get("");
            }
            return FileSystemResourceStore.this.get(this.path.substring(0, split));
        }

        @Override
        public Resource get(String resourcePath) {
            if (resourcePath == null) {
                throw new NullPointerException("Resource path required");
            }
            if ("".equals(resourcePath)) {
                return this;
            }
            return FileSystemResourceStore.this.get(Paths.path(this.path, resourcePath));
        }

        @Override
        public Resource.Type getType() {
            try {
                BasicFileAttributes attributes = java.nio.file.Files.readAttributes(this.file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                if (attributes.isDirectory()) {
                    return Resource.Type.DIRECTORY;
                }
                if (attributes.isRegularFile()) {
                    return Resource.Type.RESOURCE;
                }
                throw new IllegalStateException("Path does not represent a configuration resource: " + this.path);
            }
            catch (NoSuchFileException e) {
                return Resource.Type.UNDEFINED;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.path.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileSystemResource other = (FileSystemResource)obj;
            return this.file.equals(other.file);
        }

        public String toString() {
            return this.file.getAbsolutePath();
        }

        @Override
        public boolean delete() {
            Resource.Lock lock = this.lock();
            try {
                boolean bl = Files.delete(this.file);
                return bl;
            }
            finally {
                lock.release();
            }
        }

        @Override
        public boolean renameTo(Resource dest) {
            block5: {
                if (dest.parent().path().contains(this.path)) {
                    LOGGER.log(Level.FINE, "Cannot rename a resource to a descendant of itself");
                    return false;
                }
                try {
                    if (dest instanceof FileSystemResource) {
                        FileSystemResource resource = (FileSystemResource)dest;
                        IOUtils.rename(this.file, resource.file);
                        break block5;
                    }
                    if (dest instanceof Files.ResourceAdaptor) {
                        Files.ResourceAdaptor adaptor = (Files.ResourceAdaptor)dest;
                        IOUtils.rename(this.file, adaptor.file);
                        break block5;
                    }
                    return Resources.renameByCopy(this, dest);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to rename file resource " + this.path + " to " + dest.path(), e);
                    return false;
                }
            }
            return true;
        }

        @Override
        public byte[] getContents() throws IOException {
            return java.nio.file.Files.readAllBytes(this.file.toPath());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setContents(byte[] byteArray) throws IOException {
            File actualFile = this.file();
            if (!actualFile.exists()) {
                throw new IllegalStateException("Cannot access " + String.valueOf(actualFile));
            }
            try {
                File temp;
                FileSystemResource fileSystemResource = this;
                synchronized (fileSystemResource) {
                    UUID uuid;
                    File tryTemp;
                    do {
                        uuid = UUID.randomUUID();
                    } while ((tryTemp = new File(actualFile.getParentFile(), "%s.%s.tmp".formatted(actualFile.getName(), uuid))).exists());
                    temp = tryTemp;
                }
                java.nio.file.Files.write(temp.toPath(), byteArray, new OpenOption[0]);
                Resource.Lock lock = this.lock();
                try {
                    Files.move(temp, actualFile);
                }
                finally {
                    lock.release();
                }
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Cannot access " + String.valueOf(actualFile), e);
            }
        }
    }
}

