/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.geoserver.platform.resource.FilePaths;

public class Paths {
    public static final String BASE = "";
    static final Pattern VALID = Pattern.compile("^[^\\\\]*$");
    static final Pattern WARN = Pattern.compile("^[^:*,'&?\"<>|]*$");
    static final Set<String> INVALID = new HashSet<String>(Arrays.asList("..", "."));

    public static String parent(String path) {
        if (path == null) {
            return null;
        }
        int last = path.lastIndexOf(47);
        if (last == -1) {
            if (BASE.equals(path)) {
                return null;
            }
            return BASE;
        }
        return path.substring(0, last);
    }

    public static String name(String path) {
        if (path == null) {
            return null;
        }
        int last = path.lastIndexOf(47);
        if (last == -1) {
            return path;
        }
        String item = path.substring(last + 1);
        return item;
    }

    public static String extension(String path) {
        String name = Paths.name(path);
        if (name == null) {
            return null;
        }
        int last = name.lastIndexOf(46);
        if (last == -1) {
            return null;
        }
        return name.substring(last + 1).toLowerCase();
    }

    public static String sidecar(String path, String sidecarExtension) {
        int last = path.lastIndexOf(46);
        if (sidecarExtension == null) {
            if (last == -1) {
                return path;
            }
            return path.substring(0, last);
        }
        if (last == -1) {
            return path + "." + sidecarExtension;
        }
        return path.substring(0, last) + "." + sidecarExtension;
    }

    public static String path(String ... path) {
        if (path == null || path.length == 1 && path[0] == null) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (String item : path) {
            names.addAll(Paths.names(item));
        }
        return Paths.toPath(names);
    }

    @Deprecated
    public static String path(boolean strictPath, String ... path) {
        return Paths.path(path);
    }

    static String toPath(List<String> names) {
        StringBuilder buf = new StringBuilder();
        int LIMIT = names.size();
        for (int i = 0; i < LIMIT; ++i) {
            String item = names.get(i);
            if (item == null) continue;
            if (INVALID.contains(item)) {
                return Paths.reportInvalidPath(names, item);
            }
            if (!VALID.matcher(item).matches()) {
                return Paths.reportInvalidPath(names, item);
            }
            buf.append(item);
            if (i >= LIMIT - 1) continue;
            buf.append("/");
        }
        return buf.toString();
    }

    private static String reportInvalidPath(List<String> names, String item) {
        throw new IllegalArgumentException("Contains invalid '" + item + "' path: " + names.stream().collect(Collectors.joining("/")));
    }

    public static boolean isValid(String path) {
        if (path == null) {
            return false;
        }
        if (path.isEmpty()) {
            return true;
        }
        for (String component : Paths.names(path)) {
            if (INVALID.contains(component)) {
                return false;
            }
            if (VALID.matcher(component).matches()) continue;
            return false;
        }
        return true;
    }

    public static String valid(String path) {
        if (path == null) {
            throw new NullPointerException("Resource path required");
        }
        if (path.isEmpty()) {
            return BASE;
        }
        for (String component : Paths.names(path)) {
            if (INVALID.contains(component)) {
                throw new IllegalArgumentException("Relative paths not supported " + path);
            }
            if (VALID.matcher(component).matches()) continue;
            throw new IllegalArgumentException("Path contains invalid characters " + path);
        }
        return path;
    }

    public static List<String> names(String path) {
        String item;
        if (path == null || path.isEmpty()) {
            return Collections.emptyList();
        }
        int index = 0;
        int split = path.indexOf(47);
        if (split == -1) {
            return Collections.singletonList(path);
        }
        ArrayList<String> names = new ArrayList<String>(3);
        do {
            if ((item = path.substring(index, split)).isEmpty()) continue;
            names.add(item);
        } while ((split = path.indexOf(47, index = split + 1)) != -1);
        item = path.substring(index);
        if (item != null && !item.isEmpty() && !item.equals("/")) {
            names.add(item);
        }
        return names;
    }

    public static String convert(File base, File file) {
        if (base == null) {
            if (file.isAbsolute()) {
                throw new IllegalArgumentException("Unable to determine relative path as file was absolute");
            }
            return Paths.convert(file.getPath());
        }
        if (file == null) {
            return BASE;
        }
        URI baseURI = base.toURI();
        URI fileURI = file.toURI();
        if (fileURI.toString().startsWith(baseURI.toString())) {
            URI relativize = baseURI.relativize(fileURI);
            String path = relativize.getPath();
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            return path;
        }
        return Paths.convert(file.getPath());
    }

    public static String convert(File base, File folder, String fileLocation) {
        if (base == null) {
            throw new NullPointerException("Base directory required for relative path");
        }
        List<String> folderPath = Paths.names(Paths.convert(base, folder));
        List<String> filePath = Paths.names(Paths.convert(fileLocation));
        ArrayList<String> resolvedPath = new ArrayList<String>(folderPath.size() + filePath.size());
        resolvedPath.addAll(folderPath);
        for (String item : filePath) {
            if (item == null || item.equals(".")) continue;
            if (item.equals("..")) {
                if (!resolvedPath.isEmpty()) {
                    resolvedPath.remove(resolvedPath.size() - 1);
                    continue;
                }
                throw new IllegalStateException("File location " + fileLocation + " outside of " + base.getPath());
            }
            resolvedPath.add(item);
        }
        return Paths.toPath(resolvedPath);
    }

    public static String convert(File base, File folder, String ... location) {
        if (base == null) {
            throw new NullPointerException("Base directory required for relative path");
        }
        List<String> folderPath = Paths.names(Paths.convert(base, folder));
        List<String> filePath = Arrays.asList(location);
        ArrayList<String> resolvedPath = new ArrayList<String>(folderPath.size() + filePath.size());
        resolvedPath.addAll(folderPath);
        for (String item : filePath) {
            if (item == null || item.equals(".")) continue;
            if (item.equals("..")) {
                if (!resolvedPath.isEmpty()) {
                    resolvedPath.remove(resolvedPath.size() - 1);
                    continue;
                }
                throw new IllegalStateException("File location " + String.valueOf(filePath) + " outside of " + base.getPath());
            }
            resolvedPath.add(item);
        }
        return Paths.toPath(resolvedPath);
    }

    public static String convert(String filePath) {
        if (filePath == null) {
            return null;
        }
        if (filePath.isEmpty()) {
            return filePath;
        }
        if (File.separatorChar == '/') {
            return filePath;
        }
        return filePath.replace(File.separatorChar, '/');
    }

    public static String convert(String path, String filename) {
        if (path == null) {
            throw new NullPointerException("Initial path required to handle relative filenames");
        }
        String filePath = Paths.convert(filename);
        if (FilePaths.isAbsolute(filePath)) {
            throw new IllegalArgumentException("File location " + filename + " absolute, must be relative to " + path);
        }
        List<String> folderPathNames = Paths.names(path);
        List<String> filePathNames = Paths.names(filePath);
        ArrayList<String> resolvedPath = new ArrayList<String>(folderPathNames.size() + filePathNames.size());
        resolvedPath.addAll(folderPathNames);
        for (String item : filePathNames) {
            if (item == null || item.equals(".")) continue;
            if (item.equals("..")) {
                if (!resolvedPath.isEmpty()) {
                    resolvedPath.remove(resolvedPath.size() - 1);
                    continue;
                }
                throw new IllegalStateException("File location " + filename + " outside of " + path);
            }
            resolvedPath.add(item);
        }
        return Paths.toPath(resolvedPath);
    }
}

