/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Strings;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.FilePaths;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceListener;
import org.geoserver.platform.resource.URIs;
import org.geoserver.util.Filter;
import org.geotools.util.URLs;

public class Resources {
    private static final int MAX_RENAME_ATTEMPTS = 100;

    public static boolean exists(Resource resource) {
        return resource != null && resource.getType() != Resource.Type.UNDEFINED;
    }

    public static boolean canRead(Resource resource) {
        boolean bl;
        block8: {
            InputStream is = resource.in();
            try {
                is.read();
                bl = true;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | IllegalStateException e) {
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    public static boolean isHidden(Resource resource) {
        if (resource instanceof SerializableResourceWrapper) {
            SerializableResourceWrapper wrapper = (SerializableResourceWrapper)resource;
            resource = wrapper.delegate;
        }
        if (resource instanceof FileSystemResourceStore.FileSystemResource || resource instanceof Files.ResourceAdaptor) {
            return Resources.find(resource).isHidden();
        }
        return resource.name().startsWith(".");
    }

    public static File find(Resource resource) {
        if (resource == null) {
            return null;
        }
        switch (resource.getType()) {
            case DIRECTORY: {
                return resource.dir();
            }
            case RESOURCE: {
                return resource.file();
            }
        }
        return null;
    }

    public static File find(Resource resource, boolean force) {
        if (resource == null) {
            return null;
        }
        switch (resource.getType()) {
            case DIRECTORY: {
                return resource.dir();
            }
            case RESOURCE: {
                return resource.file();
            }
        }
        if (force) {
            return new File(resource.path());
        }
        return null;
    }

    public static File directory(Resource resource) {
        return Resources.directory(resource, false);
    }

    public static File directory(Resource resource, boolean create) {
        File f = resource == null ? null : (create ? resource.dir() : (resource.getType() == Resource.Type.DIRECTORY ? resource.dir() : null));
        return f;
    }

    public static File file(Resource resource) {
        return Resources.file(resource, false);
    }

    public static File file(Resource resource, boolean create) {
        File f = resource == null ? null : (create ? resource.file() : (resource.getType() == Resource.Type.RESOURCE ? resource.file() : null));
        return f;
    }

    public static File createNewDirectory(Resource resource) throws IOException {
        switch (resource.getType()) {
            case DIRECTORY: {
                throw new IOException("New directory " + resource.path() + " already exists as DIRECTORY");
            }
            case RESOURCE: {
                throw new IOException("New directory " + resource.path() + " already exists as RESOURCE");
            }
            case UNDEFINED: {
                return resource.dir();
            }
        }
        return null;
    }

    public static File createNewFile(Resource resource) throws IOException {
        switch (resource.getType()) {
            case DIRECTORY: {
                throw new IOException("New file " + resource.path() + " already exists as DIRECTORY");
            }
            case RESOURCE: {
                throw new IOException("New file " + resource.path() + " already exists as RESOURCE");
            }
            case UNDEFINED: {
                return resource.file();
            }
        }
        return null;
    }

    public static List<Resource> search(Resource resource, long lastModified) {
        if (resource.getType() == Resource.Type.DIRECTORY) {
            ArrayList<Resource> results = new ArrayList<Resource>();
            for (Resource child : resource.list()) {
                switch (child.getType()) {
                    case RESOURCE: {
                        if (child.lastmodified() <= lastModified) break;
                        results.add(child);
                        break;
                    }
                }
            }
            return results;
        }
        return Collections.emptyList();
    }

    public static void copy(InputStream data, Resource destination) throws IOException {
        try (OutputStream out = destination.out();){
            IOUtils.copy((InputStream)data, (OutputStream)out);
        }
    }

    public static void copy(Resource data, Resource destination) throws IOException {
        if (data.getType() == Resource.Type.DIRECTORY) {
            for (Resource child : data.list()) {
                Resources.copy(child, destination.get(child.name()));
            }
        } else {
            try (InputStream in = data.in();){
                Resources.copy(in, destination);
            }
        }
    }

    public static void copy(InputStream data, Resource directory, String filename) throws IOException {
        Resources.copy(data, directory.get(filename));
    }

    public static void copy(File data, Resource directory) throws IOException {
        String filename = data.getName();
        try (FileInputStream in = new FileInputStream(data);){
            Resources.copy(in, directory.get(filename));
        }
    }

    public static boolean renameByCopy(Resource source, Resource destination) {
        try {
            Resources.copy(source, destination);
            return source.delete();
        }
        catch (IOException e) {
            return false;
        }
    }

    public static List<Resource> list(Resource dir, Filter<Resource> filter, boolean recursive) {
        ArrayList<Resource> res = new ArrayList<Resource>();
        for (Resource child : dir.list()) {
            if (filter.accept(child)) {
                res.add(child);
            }
            if (!recursive || child.getType() != Resource.Type.DIRECTORY) continue;
            res.addAll(Resources.list(child, filter, true));
        }
        return res;
    }

    public static List<Resource> list(Resource dir, Filter<Resource> filter) {
        return Resources.list(dir, filter, false);
    }

    public static List<Resource> listRecursively(Resource dir) {
        return Resources.list(dir, AnyFilter.INSTANCE, true);
    }

    public static Resource fromPath(String path) {
        return ((GeoServerResourceLoader)GeoServerExtensions.bean("resourceLoader")).fromPath(path);
    }

    public static Resource fromPath(String path, Resource relativeDir) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return Files.asResource(file);
        }
        return relativeDir.get(path.replace(File.separatorChar, '/'));
    }

    public static Resource createRandom(String prefix, String suffix, Resource dir) throws IOException {
        UUID uuid;
        String name;
        Resource res;
        prefix = new File(prefix).getName();
        while (Resources.exists(res = dir.get(name = prefix + String.valueOf(uuid = UUID.randomUUID()) + suffix))) {
        }
        return res;
    }

    public static Resource fromURL(String path) {
        return ((GeoServerResourceLoader)GeoServerExtensions.bean("resourceLoader")).fromURL(path);
    }

    public static Resource fromURL(Resource baseDirectory, String url) {
        Resource res;
        String ss = Strings.CS.removeStart(url, (CharSequence)"resource:");
        if (!Objects.equals(url, ss)) {
            return baseDirectory.get(ss);
        }
        if (url.startsWith("file:/")) {
            try {
                return Resources.fromFile(baseDirectory, URLs.urlToFile((URL)new URL(url)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (url.startsWith("file:")) {
            url = url.substring(5);
            try {
                url = URLDecoder.decode(url, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            File f = new File(url);
            if (f.isAbsolute() || f.exists()) {
                return Files.asResource(f);
            }
            if (baseDirectory != null) {
                return baseDirectory.get(url);
            }
            return Files.asResource(f);
        }
        File file = new File(url);
        if (file.isAbsolute() || file.exists()) {
            return Files.asResource(file);
        }
        if (baseDirectory != null && Resources.exists(res = baseDirectory.get(url))) {
            return res;
        }
        return null;
    }

    public static Resource fromURL(URL url) {
        return ((GeoServerResourceLoader)GeoServerExtensions.bean("resourceLoader")).fromURL(url);
    }

    public static Resource fromURL(Resource baseDirectory, URL url) {
        if (url.getProtocol().equalsIgnoreCase("resource")) {
            return baseDirectory.get(Paths.convert(url.getPath()));
        }
        if (url.getProtocol().equalsIgnoreCase("file")) {
            return Resources.fromFile(baseDirectory, URLs.urlToFile((URL)url));
        }
        return null;
    }

    public static Resource fromFile(Resource baseDirectory, File file) {
        String path;
        try {
            path = Paths.convert(baseDirectory.dir(), file.getCanonicalFile());
        }
        catch (IOException e) {
            path = Paths.convert(baseDirectory.dir(), file);
        }
        if (FilePaths.isAbsolute(path)) {
            return Files.asResource(file);
        }
        return baseDirectory.get(path);
    }

    public static URL toURL(final Resource res) {
        try {
            if (res instanceof Files.ResourceAdaptor) {
                return res.file().toURI().toURL();
            }
            if (res instanceof URIs.ResourceAdaptor) {
                URIs.ResourceAdaptor adaptor = (URIs.ResourceAdaptor)res;
                return adaptor.getURL();
            }
            return new URL("resource", null, -1, String.format(res.getType() == Resource.Type.DIRECTORY ? "%s/" : "%s", res.path()), new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    return new URLConnection(u){

                        @Override
                        public void connect() throws IOException {
                        }

                        @Override
                        public long getLastModified() {
                            return res.lastmodified();
                        }

                        @Override
                        public InputStream getInputStream() throws IOException {
                            return res.in();
                        }

                        @Override
                        public OutputStream getOutputStream() throws IOException {
                            return res.out();
                        }
                    };
                }
            });
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Should not happen", e);
        }
    }

    public static Resource serializable(Resource resource) {
        if (resource instanceof Serializable) {
            return resource;
        }
        if (resource == null) {
            return null;
        }
        return new SerializableResourceWrapper(resource);
    }

    public static Resource uniqueResource(Resource resource, String newName, String extension) throws IOException {
        Resource target = resource.parent().get(newName + "." + extension);
        int i = 0;
        while (target.getType() != Resource.Type.UNDEFINED && ++i <= 100) {
            target = resource.parent().get(newName + i + "." + extension);
        }
        if (i > 100) {
            throw new IOException("All target files between " + newName + "1." + extension + " and " + newName + "100." + extension + " are in use already, giving up");
        }
        return target;
    }

    private static class SerializableResourceWrapper
    implements Serializable,
    Resource {
        private static final long serialVersionUID = 1758097257412707071L;
        private transient Resource delegate;
        private String path;

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.delegate = Resources.fromPath(this.path);
        }

        public SerializableResourceWrapper(Resource delegate) {
            this.delegate = delegate;
            this.path = delegate.path();
        }

        @Override
        public String path() {
            return this.path;
        }

        @Override
        public String name() {
            return this.delegate.name();
        }

        @Override
        public Resource.Lock lock() {
            return this.delegate.lock();
        }

        @Override
        public void addListener(ResourceListener listener) {
            this.delegate.addListener(listener);
        }

        @Override
        public void removeListener(ResourceListener listener) {
            this.delegate.removeListener(listener);
        }

        @Override
        public InputStream in() {
            return this.delegate.in();
        }

        @Override
        public OutputStream out() {
            return this.delegate.out();
        }

        @Override
        public File file() {
            return this.delegate.file();
        }

        @Override
        public File dir() {
            return this.delegate.dir();
        }

        @Override
        public long lastmodified() {
            return this.delegate.lastmodified();
        }

        @Override
        public Resource parent() {
            return this.delegate.parent() == null ? null : new SerializableResourceWrapper(this.delegate.parent());
        }

        @Override
        public Resource get(String resourcePath) {
            return this.delegate.get(resourcePath);
        }

        @Override
        public List<Resource> list() {
            ArrayList<Resource> children = new ArrayList<Resource>();
            for (Resource child : this.delegate.list()) {
                children.add(new SerializableResourceWrapper(child));
            }
            return children;
        }

        @Override
        public Resource.Type getType() {
            return this.delegate.getType();
        }

        @Override
        public boolean delete() {
            return this.delegate.delete();
        }

        @Override
        public boolean renameTo(Resource dest) {
            return this.delegate.renameTo(dest);
        }

        public boolean equals(Object o) {
            if (!(o instanceof SerializableResourceWrapper)) {
                return false;
            }
            return this.delegate.equals(((SerializableResourceWrapper)o).delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }
    }

    public static class AnyFilter
    implements Filter<Resource> {
        public static final AnyFilter INSTANCE = new AnyFilter();

        private AnyFilter() {
        }

        @Override
        public boolean accept(Resource obj) {
            return true;
        }
    }

    public static class DirectoryFilter
    implements Filter<Resource> {
        public static final DirectoryFilter INSTANCE = new DirectoryFilter();

        private DirectoryFilter() {
        }

        @Override
        public boolean accept(Resource obj) {
            return obj.getType() == Resource.Type.DIRECTORY;
        }
    }

    public static class ExtensionFilter
    implements Filter<Resource> {
        private Set<String> extensions;

        public ExtensionFilter(String ... extensions) {
            this.extensions = new HashSet<String>(Arrays.asList(extensions));
        }

        @Override
        public boolean accept(Resource obj) {
            return this.extensions.contains(obj.name().substring(obj.name().lastIndexOf(".") + 1).toUpperCase());
        }
    }
}

