/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.warp;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.Interpolation;
import org.eclipse.imagen.OperationDescriptorImpl;
import org.eclipse.imagen.OperationRegistry;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.PropertyGenerator;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.RegistryElementDescriptor;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.Warp;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.warp.JaiI18N;
import org.eclipse.imagen.media.warp.WarpPropertyGenerator;
import org.eclipse.imagen.media.warp.WarpRIF;

public class WarpDescriptor
extends OperationDescriptorImpl {
    private static final Logger LOGGER = Logger.getLogger(WarpDescriptor.class.toString());
    private static final String[][] resources = new String[][]{{"GlobalName", "Warp"}, {"LocalName", "Warp"}, {"Vendor", "org.eclipse.imagen.media"}, {"Description", "Warps an image according to a specified Warp object."}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/ROIAwareWarpDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("WarpDescriptor1")}, {"arg1Desc", JaiI18N.getString("WarpDescriptor2")}, {"arg2Desc", JaiI18N.getString("WarpDescriptor3")}, {"arg3Desc", JaiI18N.getString("WarpDescriptor4")}, {"arg4Desc", JaiI18N.getString("WarpDescriptor5")}};
    private static final String[] paramNames = new String[]{"warp", "interpolation", "backgroundValues", "roi", "nodata"};
    private static final Class[] paramClasses = new Class[]{Warp.class, Interpolation.class, double[].class, ROI.class, Range.class};
    private static final Object[] paramDefaults = new Object[]{NO_PARAMETER_DEFAULT, Interpolation.getInstance((int)0), null, null, null};

    public static final boolean register() {
        OperationRegistry registry = ImageN.getDefaultInstance().getOperationRegistry();
        try {
            WarpDescriptor op = new WarpDescriptor();
            String descName = op.getName();
            if (registry.getDescriptor("rendered", descName) != null) {
                return false;
            }
            registry.registerDescriptor((RegistryElementDescriptor)op);
            WarpRIF rif = new WarpRIF();
            registry.registerFactory("rendered", descName, "org.eclipse.imagen.media", (Object)rif);
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            return false;
        }
    }

    public WarpDescriptor() {
        super(resources, 1, paramClasses, paramNames, paramDefaults);
    }

    public PropertyGenerator[] getPropertyGenerators() {
        PropertyGenerator[] pg = new PropertyGenerator[]{new WarpPropertyGenerator()};
        return pg;
    }

    public static RenderedOp create(RenderedImage source0, Warp warp, Interpolation interpolation, double[] backgroundValues, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("Warp", "rendered");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("warp", (Object)warp);
        pb.setParameter("interpolation", (Object)interpolation);
        pb.setParameter("backgroundValues", (Object)backgroundValues);
        return ImageN.create((String)"Warp", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderedOp create(RenderedImage source0, Warp warp, Interpolation interpolation, double[] backgroundValues, ROI sourceROI, RenderingHints hints) {
        return WarpDescriptor.create(source0, warp, interpolation, backgroundValues, sourceROI, null, hints);
    }

    public static RenderedOp create(RenderedImage source0, Warp warp, Interpolation interpolation, double[] backgroundValues, ROI sourceROI, Range noData, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("Warp", "rendered");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("warp", (Object)warp);
        pb.setParameter("interpolation", (Object)interpolation);
        if (backgroundValues != null) {
            pb.setParameter("backgroundValues", (Object)backgroundValues);
        }
        if (sourceROI != null) {
            pb.setParameter("roi", (Object)sourceROI);
        }
        if (noData != null) {
            pb.setParameter("nodata", (Object)noData);
        }
        return ImageN.create((String)"Warp", (ParameterBlock)pb, (RenderingHints)hints);
    }
}

