/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.warp;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Collections;
import java.util.Map;
import org.eclipse.imagen.BorderExtender;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.Interpolation;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.ROIShape;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.Warp;
import org.eclipse.imagen.media.util.PropertyGeneratorImpl;
import org.eclipse.imagen.media.utilities.ImageLayout2;
import org.eclipse.imagen.operator.ConstantDescriptor;

class WarpPropertyGenerator
extends PropertyGeneratorImpl {
    public WarpPropertyGenerator() {
        super(new String[]{"ROI"}, new Class[]{ROI.class}, new Class[]{RenderedOp.class});
    }

    public Object getProperty(String name, Object opNode) {
        this.validate(name, opNode);
        if (opNode instanceof RenderedOp && name.equalsIgnoreCase("roi")) {
            ROI srcROI;
            RenderedOp op = (RenderedOp)opNode;
            ParameterBlock pb = op.getParameterBlock();
            RenderedImage src = pb.getRenderedSource(0);
            Object property = src.getProperty("ROI");
            if (property == null || property.equals(Image.UndefinedProperty) || !(property instanceof ROI)) {
                if (pb.getObjectParameter(3) != null) {
                    property = pb.getObjectParameter(3);
                } else {
                    return Image.UndefinedProperty;
                }
            }
            if ((srcROI = (ROI)property).getBounds().isEmpty()) {
                return Image.UndefinedProperty;
            }
            Interpolation interp = (Interpolation)pb.getObjectParameter(1);
            Rectangle srcBounds = new Rectangle(src.getMinX(), src.getMinY(), src.getWidth(), src.getHeight());
            if (!srcBounds.contains(srcROI.getBounds())) {
                srcROI = srcROI.intersect((ROI)new ROIShape((Shape)srcBounds));
            }
            Warp warp = (Warp)pb.getObjectParameter(0);
            Rectangle dstBounds = op.getBounds();
            ImageLayout2 layout = new ImageLayout2((RenderedImage)op);
            int minx = (int)srcBounds.getMinX();
            int miny = (int)srcBounds.getMinY();
            int w = (int)srcBounds.getWidth();
            int h = (int)srcBounds.getHeight();
            layout.setMinX(minx);
            layout.setMinY(miny);
            layout.setWidth(w);
            layout.setHeight(h);
            layout.setTileWidth(src.getTileWidth());
            layout.setTileHeight(src.getTileHeight());
            RenderingHints hints = op.getRenderingHints();
            hints.add(new RenderingHints(ImageN.KEY_IMAGE_LAYOUT, layout));
            RenderedOp constantImage = ConstantDescriptor.create((Float)new Float(w), (Float)new Float(h), (Number[])new Byte[]{(byte)-1}, (RenderingHints)hints);
            BorderExtender extender = BorderExtender.createInstance((int)1);
            RenderingHints warpingHints = new RenderingHints(Collections.emptyMap());
            warpingHints.putAll((Map<?, ?>)op.getRenderingHints());
            ImageLayout2 targetLayout = new ImageLayout2((RenderedImage)op);
            targetLayout.setColorModel(srcROI.getAsImage().getColorModel());
            targetLayout.setSampleModel(srcROI.getAsImage().getSampleModel());
            warpingHints.put(ImageN.KEY_IMAGE_LAYOUT, targetLayout);
            warpingHints.put(ImageN.KEY_BORDER_EXTENDER, extender);
            ParameterBlock paramBlock = new ParameterBlock();
            paramBlock.setSource(constantImage, 0);
            paramBlock.add(warp);
            paramBlock.add(interp);
            paramBlock.add(null);
            paramBlock.add(srcROI);
            RenderedOp roiImage = ImageN.create((String)"Warp", (ParameterBlock)paramBlock, (RenderingHints)warpingHints);
            ROI dstROI = new ROI((RenderedImage)roiImage, 1);
            if (!dstBounds.contains(dstROI.getBounds())) {
                dstROI = dstROI.intersect((ROI)new ROIShape((Shape)dstBounds));
            }
            return dstROI;
        }
        return Image.UndefinedProperty;
    }
}

