/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.ows.KvpParser;

public abstract class AbstractAxisValueKvpParser<T>
extends KvpParser {
    public AbstractAxisValueKvpParser(String key, Class<?> binding) {
        super(key, binding);
    }

    protected List<T> parseItem(String spec) throws Exception {
        spec = spec.trim();
        ArrayList<T> results = new ArrayList<T>();
        int base = 0;
        while (true) {
            int idxOpen;
            if ((idxOpen = spec.indexOf("(", base)) == -1) {
                this.throwInvalidSyntaxException(null);
            }
            int idxNextOpen = spec.indexOf("(", idxOpen + 1);
            int idxClosed = spec.indexOf(")", idxOpen);
            if (idxClosed == -1 || idxNextOpen > 0 && idxClosed > idxNextOpen) {
                this.throwInvalidSyntaxException(null);
            }
            int idxNextClosed = spec.indexOf(")", idxClosed + 1);
            String axisName = spec.substring(base, idxOpen);
            String value = spec.substring(idxOpen + 1, idxClosed);
            T result = this.buildItem(axisName, value);
            results.add(result);
            int idxSeparator = spec.indexOf(",", idxClosed);
            if (idxSeparator == -1) {
                if (idxClosed == spec.length() - 1) {
                    return results;
                }
                this.throwInvalidSyntaxException(null);
                continue;
            }
            if (idxSeparator > idxNextClosed) {
                this.throwInvalidSyntaxException(null);
            }
            base = idxSeparator + 1;
        }
    }

    protected abstract T buildItem(String var1, String var2);

    protected abstract void throwInvalidSyntaxException(Exception var1);
}

