/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.opengis.wcs20.DimensionSubsetType;
import net.opengis.wcs20.ExtensionItemType;
import net.opengis.wcs20.GetCoverageType;
import net.opengis.wcs20.ScaleAxisByFactorType;
import net.opengis.wcs20.ScaleByFactorType;
import net.opengis.wcs20.ScaleToExtentType;
import net.opengis.wcs20.ScaleToSizeType;
import net.opengis.wcs20.ScalingType;
import net.opengis.wcs20.Wcs20Factory;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.ows.kvp.EMFKvpRequestReader;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.OWS20Exception;
import org.geoserver.wcs2_0.WCS20Const;
import org.geoserver.wcs2_0.exception.WCS20Exception;

public class WCS20GetCoverageRequestReader
extends EMFKvpRequestReader {
    private static final Wcs20Factory WCS20_FACTORY = Wcs20Factory.eINSTANCE;
    private static final String GEOTIFF_NS = "http://www.opengis.net/wcs/geotiff/1.0";
    private static final String CRS_NS = "http://www.opengis.net/wcs/service-extension/crs/1.0";

    public WCS20GetCoverageRequestReader() {
        super(GetCoverageType.class, (EFactory)WCS20_FACTORY);
    }

    public Object read(Object request, Map<String, Object> kvp, Map<String, Object> rawKvp) throws Exception {
        GetCoverageType gc = (GetCoverageType)super.read(request, kvp, rawKvp);
        Object subsets = kvp.get("subset");
        if (subsets instanceof DimensionSubsetType) {
            DimensionSubsetType type = (DimensionSubsetType)subsets;
            gc.getDimensionSubset().add((Object)type);
        } else if (subsets instanceof List) {
            List list = (List)subsets;
            for (Object subset : list) {
                gc.getDimensionSubset().add((Object)((DimensionSubsetType)subset));
            }
        }
        gc.setExtension(WCS20_FACTORY.createExtensionType());
        this.parseGeoTiffExtension(gc, kvp);
        this.parseCRSExtension(gc, rawKvp);
        this.parseScalingExtension(gc, kvp);
        this.parseRangeSubsetExtension(gc, kvp);
        this.parseInterpolationExtension(gc, kvp);
        this.parseOverviewPolicyExtension(gc, kvp);
        return gc;
    }

    private void parseGeoTiffExtension(GetCoverageType gc, Map kvp) {
        List<String> geoTiffParams = Arrays.asList("compression", "jpeg_quality", "predictor", "interleave", "tiling", "tileheight", "tilewidth");
        this.parseSimpleContentList(gc, kvp, geoTiffParams, GEOTIFF_NS, null);
        this.parseSimpleContentList(gc, kvp, geoTiffParams, GEOTIFF_NS, "geotiff");
    }

    private void parseCRSExtension(GetCoverageType gc, Map kvp) {
        List<String> geoTiffParams = Arrays.asList("subsettingCrs", "outputCrs");
        this.parseSimpleContentList(gc, kvp, geoTiffParams, CRS_NS, null);
    }

    private void parseSimpleContentList(GetCoverageType gc, Map kvp, List<String> geoTiffParams, String namespace, String kvpPrefix) {
        for (String param : geoTiffParams) {
            String value;
            Object key = param;
            if (kvpPrefix != null) {
                key = kvpPrefix + ":" + param;
            }
            if ((value = KvpUtils.firstValue((Map)kvp, (String)key)) == null) continue;
            ExtensionItemType item = WCS20_FACTORY.createExtensionItemType();
            item.setNamespace(namespace);
            item.setName(param);
            item.setSimpleContent(value);
            gc.getExtension().getContents().add((Object)item);
        }
    }

    private void parseScalingExtension(GetCoverageType gc, Map kvp) {
        boolean found = false;
        ScalingType scaling = WCS20_FACTORY.createScalingType();
        if (kvp.containsKey("scalefactor")) {
            found = true;
            ScaleByFactorType sf = WCS20_FACTORY.createScaleByFactorType();
            sf.setScaleFactor(((Double)kvp.get("scalefactor")).doubleValue());
            scaling.setScaleByFactor(sf);
        }
        if (kvp.containsKey("scaleaxes")) {
            found = true;
            scaling.setScaleAxesByFactor((ScaleAxisByFactorType)kvp.get("scaleaxes"));
        }
        if (kvp.containsKey("scalesize")) {
            found = true;
            scaling.setScaleToSize((ScaleToSizeType)kvp.get("scalesize"));
        }
        if (kvp.containsKey("scaleextent")) {
            found = true;
            scaling.setScaleToExtent((ScaleToExtentType)kvp.get("scaleextent"));
        }
        if (found) {
            ExtensionItemType item = WCS20_FACTORY.createExtensionItemType();
            item.setNamespace("http://www.opengis.net/WCS_service-extension_scaling/1.0");
            item.setName("Scaling");
            item.setObjectContent((Object)scaling);
            gc.getExtension().getContents().add((Object)item);
        }
    }

    private void parseRangeSubsetExtension(GetCoverageType gc, Map kvp) {
        if (kvp.containsKey("rangesubset")) {
            ExtensionItemType item = WCS20_FACTORY.createExtensionItemType();
            item.setNamespace("http://www.opengis.net/wcs/range-subsetting/1.0");
            item.setName("RangeSubset");
            item.setObjectContent(kvp.get("rangesubset"));
            gc.getExtension().getContents().add((Object)item);
        }
    }

    private void parseInterpolationExtension(GetCoverageType gc, Map kvp) {
        if (kvp.containsKey("interpolation")) {
            ExtensionItemType item = WCS20_FACTORY.createExtensionItemType();
            item.setNamespace("http://www.opengis.net/WCS_service-extension_interpolation/1.0");
            item.setName("Interpolation");
            item.setObjectContent(kvp.get("interpolation"));
            gc.getExtension().getContents().add((Object)item);
        }
    }

    private void parseOverviewPolicyExtension(GetCoverageType gc, Map kvp) {
        Object item;
        if (kvp.containsKey(WCS20Const.OVERVIEW_POLICY_EXTENSION_LOWERCASE) && (item = kvp.get(WCS20Const.OVERVIEW_POLICY_EXTENSION_LOWERCASE)) instanceof ExtensionItemType) {
            ExtensionItemType type = (ExtensionItemType)item;
            gc.getExtension().getContents().add((Object)type);
        }
    }

    protected void setValue(EObject eObject, String property, Object value) {
        if ("sortBy".equalsIgnoreCase(property)) {
            List sorts = (List)value;
            int sortsSize = sorts.size();
            if (sortsSize != 1) {
                throw new OWS20Exception("Invalid sortBy specification, expecting sorts for just one coverage, but got " + sortsSize + " instead", WCS20Exception.WCS20ExceptionCode.InvalidParameterValue, "sortBy");
            }
            GetCoverageType getCoverage = (GetCoverageType)eObject;
            getCoverage.getSortBy().addAll((Collection)((List)sorts.get(0)));
        } else {
            super.setValue(eObject, property, value);
        }
    }
}

