/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web;

import java.io.IOException;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.link.Link;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.GeoServerDialog;

public abstract class AbstractSecurityPage
extends GeoServerSecuredPage {
    public static String ServiceNameKey = "serviceName";
    public static String TabbedPanelId = "tabbedPanel";
    boolean dirty = false;
    protected GeoServerDialog dialog;

    public AbstractSecurityPage() {
        Component[] componentArray = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray[0] = this.dialog;
        this.add(componentArray);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    protected void setReturnPageDirtyAndReturn(boolean dirty) {
        Page page = this.returnPage;
        if (page instanceof AbstractSecurityPage) {
            AbstractSecurityPage page2 = (AbstractSecurityPage)page;
            page2.setDirty(dirty);
        }
        this.doReturn();
    }

    public Link<Page> getCancelLink() {
        return new Link<Page>("cancel"){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                AbstractSecurityPage.this.setReturnPageDirtyAndReturn(false);
            }
        };
    }

    public GeoServerSecurityManager getSecurityManager() {
        return GeoServerApplication.get().getSecurityManager();
    }

    public GeoServerUserGroupService getUserGroupService(String name) {
        try {
            return this.getSecurityManager().loadUserGroupService(name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GeoServerRoleService getRoleService(String name) {
        try {
            return this.getSecurityManager().loadRoleService(name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasRoleStore(String name) {
        return this.getRoleService(name).canCreateStore();
    }

    public GeoServerRoleStore getRoleStore(String name) throws IOException {
        return this.getRoleService(name).createStore();
    }

    public boolean hasUserGroupStore(String name) {
        return this.getUserGroupService(name).canCreateStore();
    }

    public GeoServerUserGroupStore getUserGroupStore(String name) throws IOException {
        return this.getUserGroupService(name).createStore();
    }
}

