/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web;

import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.TabbedPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.GroupAdminComponentAuthorizer;
import org.geoserver.security.web.role.RoleServicesPanel;
import org.geoserver.security.web.role.RoleServicesTogglePanel;
import org.geoserver.security.web.usergroup.UserGroupServicesPanel;
import org.geoserver.security.web.usergroup.UserGroupServicesTogglePanel;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.wicket.HelpLink;

public class UserGroupRoleServicesPage
extends AbstractSecurityPage {
    public UserGroupRoleServicesPage() {
        ArrayList<AbstractTab> tabs = new ArrayList<AbstractTab>();
        tabs.add(new AbstractTab((IModel)new StringResourceModel("services", (Component)this, null)){

            public Panel getPanel(String panelId) {
                return new ServicesPanel(panelId);
            }
        });
        tabs.add(new AbstractTab((IModel)new StringResourceModel("usersgroups", (Component)this, null)){

            public Panel getPanel(String panelId) {
                return new UsersGroupsPanel(panelId);
            }
        });
        tabs.add(new AbstractTab((IModel)new StringResourceModel("roles", (Component)this, null)){

            public Panel getPanel(String panelId) {
                return new RolesPanel(panelId);
            }
        });
        this.add(new Component[]{new TabbedPanel("panel", tabs)});
    }

    protected ComponentAuthorizer getPageAuthorizer() {
        return new GroupAdminComponentAuthorizer();
    }

    static class RolesPanel
    extends Panel {
        public RolesPanel(String id) {
            super(id);
            this.add(new Component[]{new RoleServicesTogglePanel("roles")});
        }
    }

    static class UsersGroupsPanel
    extends Panel {
        public UsersGroupsPanel(String id) {
            super(id);
            this.add(new Component[]{new UserGroupServicesTogglePanel("usersgroups")});
        }
    }

    class ServicesPanel
    extends Panel {
        public ServicesPanel(String id) {
            super(id);
            this.add(new Component[]{new UserGroupServicesPanel("userGroupServices")});
            this.add(new Component[]{new HelpLink("userGroupServicesHelp").setDialog(UserGroupRoleServicesPage.this.dialog)});
            this.add(new Component[]{new RoleServicesPanel("roleServices")});
            this.add(new Component[]{new HelpLink("roleServicesHelp").setDialog(UserGroupRoleServicesPage.this.dialog)});
        }
    }
}

