/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.csp;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.security.csp.CSPConfiguration;
import org.geoserver.security.csp.CSPHeaderDAO;
import org.geoserver.security.web.csp.CSPPolicyPanel;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerSecuredPage;

public class CSPConfigurationPage
extends GeoServerSecuredPage {
    private static final long serialVersionUID = -5935887226717780789L;
    private TextArea<String> testResultField;
    private CSPConfiguration config = new CSPConfiguration(this.getCSPHeaderDAO().getConfig());
    private String testUrl = "";

    public CSPConfigurationPage() throws IOException {
        Model model = new Model((Serializable)this.config);
        Form form = new Form("form", (IModel)new CompoundPropertyModel((IModel)model));
        form.add(new Component[]{new CheckBox("enabled", (IModel)new PropertyModel((Object)model, "enabled"))});
        form.add(new Component[]{new CheckBox("reportOnly", (IModel)new PropertyModel((Object)model, "reportOnly"))});
        form.add(new Component[]{new CheckBox("allowOverride", (IModel)new PropertyModel((Object)model, "allowOverride"))});
        form.add(new Component[]{new CheckBox("injectProxyBase", (IModel)new PropertyModel((Object)model, "injectProxyBase"))});
        form.add(new Component[]{new TextArea("remoteResources", (IModel)new PropertyModel((Object)model, "remoteResources"))});
        form.add(new Component[]{new TextArea("formAction", (IModel)new PropertyModel((Object)model, "formAction"))});
        form.add(new Component[]{new TextArea("frameAncestors", (IModel)new PropertyModel((Object)model, "frameAncestors"))});
        form.add(new Component[]{new CSPPolicyPanel("policies", this.config)});
        form.add(new Component[]{new TextArea("testUrl", (IModel)new PropertyModel((Object)this, "testUrl"))});
        form.add(new Component[]{new AjaxSubmitLink("testLink"){
            private static final long serialVersionUID = 1700932575669734348L;

            protected void onSubmit(AjaxRequestTarget target) {
                CSPConfigurationPage.this.testContentSecurityPolicy(target);
            }
        }});
        this.testResultField = new TextArea("testResult", (IModel)new Model((Serializable)((Object)"")));
        form.add(new Component[]{this.testResultField.setOutputMarkupId(true).setEnabled(false)});
        form.add(new Component[]{new SubmitLink("save", form){
            private static final long serialVersionUID = -8900006356449150190L;

            public void onSubmit() {
                CSPConfigurationPage.this.saveConfiguration(true);
            }
        }});
        form.add(new Component[]{new Button("apply"){
            private static final long serialVersionUID = -3327108081898697618L;

            public void onSubmit() {
                CSPConfigurationPage.this.saveConfiguration(false);
            }
        }});
        form.add(new Component[]{new Button("cancel"){
            private static final long serialVersionUID = 7567566240358171893L;

            public void onSubmit() {
                CSPConfigurationPage.this.doReturn();
            }
        }});
        this.add(new Component[]{form});
    }

    private CSPHeaderDAO getCSPHeaderDAO() {
        return (CSPHeaderDAO)this.getGeoServerApplication().getBeanOfType(CSPHeaderDAO.class);
    }

    private void saveConfiguration(boolean doReturn) {
        try {
            Preconditions.checkArgument((!this.config.getFormAction().contains("'none'") ? 1 : 0) != 0, (Object)"form-action containing 'none' is not allowed here");
            this.getCSPHeaderDAO().setConfig(new CSPConfiguration(this.config));
            if (doReturn) {
                this.doReturn();
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    private void testContentSecurityPolicy(AjaxRequestTarget target) {
        String result = "Enter URL";
        try {
            if (StringUtils.isNotBlank((CharSequence)this.testUrl)) {
                HttpServletRequest request = CSPConfigurationPage.getHttpRequest(new URL(this.testUrl.trim()));
                this.config.parseFilters();
                result = CSPHeaderDAO.getContentSecurityPolicy((CSPConfiguration)this.config, (HttpServletRequest)request, (boolean)true);
            }
        }
        catch (Exception e) {
            result = "ERROR";
            this.error(e);
            this.addFeedbackPanels(target);
        }
        target.add(new Component[]{this.testResultField.setDefaultModelObject((Object)result)});
    }

    private static HttpServletRequest getHttpRequest(final URL url) throws IOException {
        final String host = url.getHost() + String.valueOf(url.getPort() == -1 ? "" : Integer.valueOf(58 + url.getPort()));
        String path = URLDecoder.decode(url.getPath(), "UTF-8");
        String context = GeoServerApplication.get().servletRequest().getContextPath();
        final String pathInfo = path.startsWith(context) ? path.substring(context.length()) : path;
        LinkedHashMap<String, List> listMap = new LinkedHashMap<String, List>();
        URLEncodedUtils.parse((String)url.getQuery(), (Charset)StandardCharsets.UTF_8, (char[])new char[]{'&'}).forEach(p -> listMap.computeIfAbsent(p.getName(), x -> new ArrayList()).add(p.getValue()));
        final LinkedHashMap parameterMap = new LinkedHashMap();
        listMap.forEach((k, v) -> parameterMap.put(k, v.toArray(new String[v.size()])));
        return new HttpServletRequest(){

            public String getHeader(String name) {
                return "Host".equals(name) ? host : null;
            }

            public String getMethod() {
                return "GET";
            }

            public Map<String, String[]> getParameterMap() {
                return Collections.unmodifiableMap(parameterMap);
            }

            public String getPathInfo() {
                return pathInfo;
            }

            public String getQueryString() {
                return url.getQuery();
            }

            public String getRequestURI() {
                return url.getPath();
            }

            public String getScheme() {
                return url.getProtocol();
            }

            public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
                throw new UnsupportedOperationException();
            }

            public AsyncContext startAsync() {
                throw new UnsupportedOperationException();
            }

            public void setCharacterEncoding(String env) {
                throw new UnsupportedOperationException();
            }

            public void setAttribute(String name, Object o) {
                throw new UnsupportedOperationException();
            }

            public void removeAttribute(String name) {
                throw new UnsupportedOperationException();
            }

            public boolean isSecure() {
                throw new UnsupportedOperationException();
            }

            public boolean isAsyncSupported() {
                throw new UnsupportedOperationException();
            }

            public boolean isAsyncStarted() {
                throw new UnsupportedOperationException();
            }

            public ServletContext getServletContext() {
                throw new UnsupportedOperationException();
            }

            public int getServerPort() {
                throw new UnsupportedOperationException();
            }

            public String getServerName() {
                throw new UnsupportedOperationException();
            }

            public RequestDispatcher getRequestDispatcher(String path) {
                throw new UnsupportedOperationException();
            }

            public int getRemotePort() {
                throw new UnsupportedOperationException();
            }

            public String getRemoteHost() {
                throw new UnsupportedOperationException();
            }

            public String getRemoteAddr() {
                throw new UnsupportedOperationException();
            }

            public String getRealPath(String path) {
                throw new UnsupportedOperationException();
            }

            public BufferedReader getReader() {
                throw new UnsupportedOperationException();
            }

            public String getProtocol() {
                throw new UnsupportedOperationException();
            }

            public String[] getParameterValues(String name) {
                throw new UnsupportedOperationException();
            }

            public Enumeration<String> getParameterNames() {
                throw new UnsupportedOperationException();
            }

            public String getParameter(String name) {
                throw new UnsupportedOperationException();
            }

            public Enumeration<Locale> getLocales() {
                throw new UnsupportedOperationException();
            }

            public Locale getLocale() {
                throw new UnsupportedOperationException();
            }

            public int getLocalPort() {
                throw new UnsupportedOperationException();
            }

            public String getLocalName() {
                throw new UnsupportedOperationException();
            }

            public String getLocalAddr() {
                throw new UnsupportedOperationException();
            }

            public ServletInputStream getInputStream() {
                throw new UnsupportedOperationException();
            }

            public DispatcherType getDispatcherType() {
                throw new UnsupportedOperationException();
            }

            public String getContentType() {
                throw new UnsupportedOperationException();
            }

            public int getContentLength() {
                throw new UnsupportedOperationException();
            }

            public long getContentLengthLong() {
                throw new UnsupportedOperationException();
            }

            public String getCharacterEncoding() {
                throw new UnsupportedOperationException();
            }

            public Enumeration<String> getAttributeNames() {
                throw new UnsupportedOperationException();
            }

            public Object getAttribute(String name) {
                throw new UnsupportedOperationException();
            }

            public AsyncContext getAsyncContext() {
                throw new UnsupportedOperationException();
            }

            public void logout() throws ServletException {
                throw new UnsupportedOperationException();
            }

            public void login(String username, String password) {
                throw new UnsupportedOperationException();
            }

            public boolean isUserInRole(String role) {
                throw new UnsupportedOperationException();
            }

            public boolean isRequestedSessionIdValid() {
                throw new UnsupportedOperationException();
            }

            public boolean isRequestedSessionIdFromUrl() {
                throw new UnsupportedOperationException();
            }

            public boolean isRequestedSessionIdFromURL() {
                throw new UnsupportedOperationException();
            }

            public boolean isRequestedSessionIdFromCookie() {
                throw new UnsupportedOperationException();
            }

            public Principal getUserPrincipal() {
                throw new UnsupportedOperationException();
            }

            public HttpSession getSession(boolean create) {
                throw new UnsupportedOperationException();
            }

            public HttpSession getSession() {
                throw new UnsupportedOperationException();
            }

            public String changeSessionId() {
                throw new UnsupportedOperationException();
            }

            public String getServletPath() {
                throw new UnsupportedOperationException();
            }

            public String getRequestedSessionId() {
                throw new UnsupportedOperationException();
            }

            public StringBuffer getRequestURL() {
                throw new UnsupportedOperationException();
            }

            public String getRemoteUser() {
                throw new UnsupportedOperationException();
            }

            public String getPathTranslated() {
                throw new UnsupportedOperationException();
            }

            public Collection<Part> getParts() {
                throw new UnsupportedOperationException();
            }

            public Part getPart(String name) {
                throw new UnsupportedOperationException();
            }

            public <T extends HttpUpgradeHandler> T upgrade(Class<T> aClass) throws IOException, ServletException {
                throw new UnsupportedOperationException();
            }

            public int getIntHeader(String name) {
                throw new UnsupportedOperationException();
            }

            public Enumeration<String> getHeaders(String name) {
                throw new UnsupportedOperationException();
            }

            public Enumeration<String> getHeaderNames() {
                throw new UnsupportedOperationException();
            }

            public long getDateHeader(String name) {
                throw new UnsupportedOperationException();
            }

            public Cookie[] getCookies() {
                throw new UnsupportedOperationException();
            }

            public String getContextPath() {
                throw new UnsupportedOperationException();
            }

            public String getAuthType() {
                throw new UnsupportedOperationException();
            }

            public boolean authenticate(HttpServletResponse response) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

