/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.csp;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.security.csp.CSPPolicy;
import org.geoserver.security.csp.CSPRule;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.ParamResourceModel;

public class CSPRulePage
extends GeoServerSecuredPage {
    private static final long serialVersionUID = 8806565936027357459L;
    private TextField<String> nameField;
    private CSPPolicy policy;
    private CSPRule rule;

    public CSPRulePage(CSPRule rule, CSPPolicy policy) {
        this.policy = policy;
        this.rule = new CSPRule(rule);
        Model model = new Model((Serializable)this.rule);
        Form form = new Form("form", (IModel)new CompoundPropertyModel((IModel)model));
        this.nameField = new TextField("name", (IModel)new PropertyModel((Object)model, "name"));
        this.nameField.add((IValidator)new NameValidator());
        form.add(new Component[]{this.nameField.setRequired(true).setEnabled(this.rule.getName() == null)});
        form.add(new Component[]{new TextArea("description", (IModel)new PropertyModel((Object)model, "description"))});
        form.add(new Component[]{new CheckBox("enabled", (IModel)new PropertyModel((Object)model, "enabled"))});
        form.add(new Component[]{new TextArea("filter", (IModel)new PropertyModel((Object)model, "filter")).add((IValidator)new FilterValidator())});
        form.add(new Component[]{new TextArea("directives", (IModel)new PropertyModel((Object)model, "directives"))});
        form.add(new Component[]{new SubmitLink("save", form){
            private static final long serialVersionUID = 7615174589339108727L;

            public void onSubmit() {
                CSPRulePage.this.saveRule();
            }
        }});
        form.add(new Component[]{new Button("cancel"){
            private static final long serialVersionUID = 5040891804626008259L;

            public void onSubmit() {
                CSPRulePage.this.doReturn();
            }
        }});
        this.add(new Component[]{form});
    }

    private void saveRule() {
        List rules = this.policy.getRules();
        if (this.nameField.isEnabled()) {
            rules.add(new CSPRule(this.rule));
        } else {
            for (int i = 0; i < rules.size(); ++i) {
                if (!((CSPRule)rules.get(i)).getName().equals(this.rule.getName())) continue;
                rules.set(i, new CSPRule(this.rule));
                break;
            }
        }
        this.doReturn();
    }

    private class NameValidator
    implements IValidator<String> {
        private static final long serialVersionUID = -6504547974652587614L;

        private NameValidator() {
        }

        public void validate(IValidatable<String> validatable) {
            String name = (String)validatable.getValue();
            if (CSPRulePage.this.nameField.isEnabled() && CSPRulePage.this.policy.getRuleByName(name) != null) {
                ParamResourceModel message = new ParamResourceModel("duplicateRule", (Component)CSPRulePage.this, new Object[]{name});
                validatable.error((IValidationError)new ValidationError(message.getString()));
            }
        }
    }

    private static class FilterValidator
    implements IValidator<String> {
        private static final long serialVersionUID = -4027375126421815304L;

        private FilterValidator() {
        }

        public void validate(IValidatable<String> validatable) {
            try {
                CSPRule.parseFilter((String)((String)validatable.getValue()));
            }
            catch (Exception e) {
                Object message = e.getMessage();
                if (e.getCause() != null) {
                    message = (String)message + ": " + e.getCause().getMessage();
                }
                validatable.error((IValidationError)new ValidationError((String)message));
            }
        }
    }
}

